/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel;

import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.rex.RexVariableAliasCollector;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;

public class PushFilterVisitor
extends GraphShuttle {
    private final GraphBuilder builder;
    private final RexNode condition;
    private final List<Integer> distinctAliasIds;
    private boolean pushed;

    public PushFilterVisitor(GraphBuilder builder, RexNode condition) {
        this.builder = builder;
        this.condition = condition;
        this.distinctAliasIds = ((List)condition.accept(new RexVariableAliasCollector<Integer>(true, RexGraphVariable::getAliasId))).stream().distinct().collect(Collectors.toList());
    }

    @Override
    public RelNode visit(GraphLogicalSingleMatch match) {
        RelNode sentence = match.getSentence().accept((RelShuttle)this);
        if (!sentence.equals(match.getSentence())) {
            return this.builder.match(sentence, match.getMatchOpt()).build();
        }
        return match;
    }

    @Override
    public RelNode visit(GraphLogicalMultiMatch match) {
        List sentences = match.getSentences().stream().map(k -> k.accept((RelShuttle)this)).collect(Collectors.toList());
        if (!sentences.equals(match.getSentences())) {
            return this.builder.match((RelNode)sentences.get(0), sentences.subList(1, sentences.size())).build();
        }
        return match;
    }

    @Override
    public RelNode visit(GraphLogicalSource source) {
        return this.fuseFilter((RelNode)source);
    }

    @Override
    public RelNode visit(GraphLogicalExpand expand) {
        return this.fuseFilter(this.visitChildren((RelNode)expand));
    }

    @Override
    public RelNode visit(GraphLogicalGetV getV) {
        return this.fuseFilter(this.visitChildren((RelNode)getV));
    }

    public boolean isPushed() {
        return this.pushed;
    }

    private RelNode fuseFilter(RelNode node) {
        if (this.distinctAliasIds.size() != 1) {
            return node;
        }
        int aliasId = this.distinctAliasIds.get(0);
        RelDataType rowType = node.getRowType();
        for (RelDataTypeField field : rowType.getFieldList()) {
            if (aliasId == -1 || field.getIndex() != aliasId) continue;
            this.pushed = true;
            return this.builder.push(node).filter(this.condition).build();
        }
        return node;
    }
}

