/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.metadata.glogue;

import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.ElementDetails;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternDirection;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.EdgeTypeId;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class ExtendEdge {
    private int srcVertexOrder;
    private final List<EdgeTypeId> edgeTypeIds;
    private PatternDirection direction;
    private Double weight;
    private final ElementDetails elementDetails;

    public ExtendEdge(int srcVertexOrder, EdgeTypeId edgeTypeId, PatternDirection direction) {
        this(srcVertexOrder, edgeTypeId, direction, null);
    }

    public ExtendEdge(int srcVertexOrder, List<EdgeTypeId> edgeTypeIds, PatternDirection direction) {
        this(srcVertexOrder, edgeTypeIds, direction, null);
    }

    public ExtendEdge(int srcVertexOrder, EdgeTypeId edgeTypeId, PatternDirection direction, Double weight) {
        this(srcVertexOrder, (List<EdgeTypeId>)ImmutableList.of((Object)edgeTypeId), direction, weight, new ElementDetails());
    }

    public ExtendEdge(int srcVertexOrder, List<EdgeTypeId> edgeTypeIds, PatternDirection direction, Double weight) {
        this(srcVertexOrder, edgeTypeIds, direction, weight, new ElementDetails());
    }

    public ExtendEdge(int srcVertexOrder, List<EdgeTypeId> edgeTypeIds, PatternDirection direction, Double weight, ElementDetails elementDetails) {
        this.srcVertexOrder = srcVertexOrder;
        this.edgeTypeIds = edgeTypeIds;
        this.direction = direction;
        this.weight = weight;
        this.elementDetails = elementDetails;
    }

    public int getSrcVertexOrder() {
        return this.srcVertexOrder;
    }

    public EdgeTypeId getEdgeTypeId() {
        return this.edgeTypeIds.get(0);
    }

    public List<EdgeTypeId> getEdgeTypeIds() {
        return Collections.unmodifiableList(this.edgeTypeIds);
    }

    public PatternDirection getDirection() {
        return this.direction;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Double getWeight() {
        return this.weight;
    }

    public ElementDetails getElementDetails() {
        return this.elementDetails;
    }

    public String toString() {
        return this.srcVertexOrder + (this.edgeTypeIds.size() == 1 ? this.edgeTypeIds.get(0).toString() : this.edgeTypeIds.toString()) + ": " + this.weight;
    }
}

