/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.metadata.glogue;

import com.alibaba.graphscope.common.ir.rel.metadata.glogue.ExtendEdge;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class ExtendStep {
    private List<Integer> targetVertexTypes;
    private Integer targetVertexOrder;
    private List<ExtendEdge> extendEdges;
    private Double weight;

    public ExtendStep(Integer targetVertexType, List<ExtendEdge> extendEdges) {
        this.targetVertexTypes = ImmutableList.of((Object)targetVertexType);
        this.extendEdges = extendEdges;
    }

    public ExtendStep(List<Integer> targetVertexTypes, List<ExtendEdge> extendEdges) {
        this.targetVertexTypes = targetVertexTypes;
        this.extendEdges = extendEdges;
    }

    public ExtendStep(List<Integer> targetVertexTypes, Integer targetVertexOrder, List<ExtendEdge> extendEdges, Double weight) {
        this.targetVertexTypes = targetVertexTypes;
        this.targetVertexOrder = targetVertexOrder;
        this.extendEdges = extendEdges;
        this.weight = weight;
    }

    public Integer getTargetVertexType() {
        return this.targetVertexTypes.get(0);
    }

    public List<Integer> getTargetVertexTypes() {
        return Collections.unmodifiableList(this.targetVertexTypes);
    }

    public List<ExtendEdge> getExtendEdges() {
        return this.extendEdges;
    }

    public void sortExtendEdges() {
        this.extendEdges.sort((o1, o2) -> o1.getWeight().compareTo(o2.getWeight()));
    }

    public void setTargetVertexOrder(Integer targetVertexOrder) {
        this.targetVertexOrder = targetVertexOrder;
    }

    public Integer getTargetVertexOrder() {
        return this.targetVertexOrder;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Double getWeight() {
        return this.weight;
    }

    public String toString() {
        return "ExtendStep{targetType=" + (this.targetVertexTypes.size() == 1 ? this.targetVertexTypes.get(0) : this.targetVertexTypes) + ", targetOrder=" + this.targetVertexOrder + ", weight=" + this.weight + ", extendEdges=" + this.extendEdges + "}";
    }
}

