/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.metadata.glogue;

import com.alibaba.graphscope.common.ir.rel.metadata.glogue.ExtendEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.ExtendStep;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.Glogue;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueCardinalityEstimation;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueExtendIntersectEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.Pattern;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternDirection;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.GlogueSchema;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlogueBasicCardinalityEstimationImpl
implements GlogueCardinalityEstimation {
    private Map<Pattern, Double> patternCardinality = new HashMap<Pattern, Double>();
    private static Logger logger = LoggerFactory.getLogger(GlogueBasicCardinalityEstimationImpl.class);

    public GlogueBasicCardinalityEstimationImpl(Glogue glogue, GlogueSchema schema) {
        this.create(glogue, schema);
    }

    private GlogueBasicCardinalityEstimationImpl create(Glogue glogue, GlogueSchema schema) {
        ArrayDeque<Pattern> patternQueue = new ArrayDeque<Pattern>();
        List<Pattern> roots = glogue.getRoots();
        for (Pattern pattern : roots) {
            PatternVertex singleVertexPattern = pattern.getVertexSet().iterator().next();
            if (singleVertexPattern.getVertexTypeIds().size() != 1) {
                throw new UnsupportedOperationException("In GlogueBasicCardinalityEstimationImpl creation, singleVertexPattern " + singleVertexPattern + " is not of basic type.");
            }
            Integer vertexTypeId = singleVertexPattern.getVertexTypeIds().get(0);
            Double singleVertexPatternCount = schema.getVertexTypeCardinality(vertexTypeId);
            this.patternCardinality.put(pattern, singleVertexPatternCount);
            patternQueue.add(pattern);
        }
        while (patternQueue.size() > 0) {
            Pattern pattern = (Pattern)patternQueue.pop();
            Double patternCount = this.patternCardinality.get(pattern);
            for (GlogueEdge edge : glogue.getGlogueOutEdges(pattern)) {
                GlogueExtendIntersectEdge extendIntersectEdge = (GlogueExtendIntersectEdge)edge;
                Pattern newPattern = extendIntersectEdge.getDstPattern();
                ExtendStep extendStep = extendIntersectEdge.getExtendStep();
                if (this.containsPattern(newPattern)) {
                    Double extendStepWeight = this.estimateExtendWeight(schema, extendStep);
                    extendStep.setWeight(extendStepWeight);
                    continue;
                }
                Pair<Double, Double> patternCountWithWeight = this.estimatePatternCountWithExtendWeight(schema, patternCount, extendStep);
                this.patternCardinality.put(newPattern, (Double)patternCountWithWeight.getValue0());
                extendStep.setWeight((Double)patternCountWithWeight.getValue1());
                patternQueue.add(newPattern);
            }
        }
        return this;
    }

    private Pair<Double, Double> estimatePatternCountWithExtendWeight(GlogueSchema schema, Double srcPatternCount, ExtendStep extendStep) {
        Double targetPatternCount;
        this.initEdgeWeightsInExtendStep(schema, extendStep);
        Double commonTargetVertexTypeCount = schema.getVertexTypeCardinality(extendStep.getTargetVertexType());
        Iterator<ExtendEdge> iter = extendStep.getExtendEdges().iterator();
        Double intermediate = targetPatternCount = Double.valueOf(srcPatternCount * iter.next().getWeight());
        while (iter.hasNext()) {
            ExtendEdge extendEdge = iter.next();
            targetPatternCount = targetPatternCount * (extendEdge.getWeight() / commonTargetVertexTypeCount);
            intermediate = intermediate + targetPatternCount;
        }
        return Pair.with((Object)targetPatternCount, (Object)(intermediate / srcPatternCount));
    }

    private Double estimateExtendWeight(GlogueSchema schema, ExtendStep extendStep) {
        this.initEdgeWeightsInExtendStep(schema, extendStep);
        Double commonTargetVertexCount = schema.getVertexTypeCardinality(extendStep.getTargetVertexType());
        Iterator<ExtendEdge> iter = extendStep.getExtendEdges().iterator();
        Double extendStepWeight = iter.next().getWeight();
        Double intermediate = 1.0;
        while (iter.hasNext()) {
            ExtendEdge extendEdge = iter.next();
            intermediate = intermediate * (extendEdge.getWeight() / commonTargetVertexCount);
            extendStepWeight = extendStepWeight + intermediate;
        }
        return extendStepWeight;
    }

    private void initEdgeWeightsInExtendStep(GlogueSchema schema, ExtendStep extendStep) {
        for (ExtendEdge extendEdge : extendStep.getExtendEdges()) {
            Double extendEdgeCount = schema.getEdgeTypeCardinality(extendEdge.getEdgeTypeId());
            Integer srcVertexType = extendEdge.getDirection().equals((Object)PatternDirection.OUT) ? extendEdge.getEdgeTypeId().getSrcLabelId() : extendEdge.getEdgeTypeId().getDstLabelId();
            Double commonSrcVertexCount = schema.getVertexTypeCardinality(srcVertexType);
            extendEdge.setWeight(extendEdgeCount / commonSrcVertexCount);
        }
        extendStep.sortExtendEdges();
    }

    private boolean containsPattern(Pattern pattern) {
        return this.patternCardinality.containsKey(pattern);
    }

    @Override
    public Double getCardinality(Pattern queryPattern) {
        return this.getCardinality(queryPattern, false);
    }

    public @Nullable Double getCardinality(Pattern queryPattern, boolean allowsNull) {
        for (Pattern pattern : this.patternCardinality.keySet()) {
            if (!pattern.equals(queryPattern)) continue;
            return this.patternCardinality.get(pattern);
        }
        if (allowsNull) {
            return null;
        }
        logger.warn("pattern {} not found in glogue, return count = 1.0", (Object)queryPattern);
        return 1.0;
    }

    public String toString() {
        Object s = "";
        for (Pattern pattern : this.patternCardinality.keySet()) {
            s = (String)s + "Pattern " + pattern.getPatternId() + ": " + this.patternCardinality.get(pattern) + "\n";
        }
        return s;
    }
}

