/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern;

import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PathExpandRange;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ElementDetails
implements Comparable<ElementDetails> {
    private final double selectivity;
    private final @Nullable PathExpandRange range;
    private final List<Integer> pxdInnerGetVTypes;
    private final GraphOpt.PathExpandResult resultOpt;
    private final GraphOpt.PathExpandPath pathOpt;
    private boolean optional;

    public ElementDetails() {
        this(1.0);
    }

    public ElementDetails(double selectivity) {
        this(selectivity, null, (List<Integer>)ImmutableList.of(), null, null);
    }

    public ElementDetails(double selectivity, @Nullable PathExpandRange range, List<Integer> pxdInnerGetVTypes, GraphOpt.PathExpandResult resultOpt, GraphOpt.PathExpandPath pathOpt) {
        this(selectivity, range, pxdInnerGetVTypes, resultOpt, pathOpt, false);
    }

    public ElementDetails(double selectivity, boolean optional) {
        this(selectivity, null, (List<Integer>)ImmutableList.of(), null, null, optional);
    }

    public ElementDetails(double selectivity, @Nullable PathExpandRange range, List<Integer> pxdInnerVertexTypes, GraphOpt.PathExpandResult resultOpt, GraphOpt.PathExpandPath pathOpt, boolean optional) {
        this.selectivity = selectivity;
        this.range = range;
        this.pxdInnerGetVTypes = pxdInnerVertexTypes;
        this.optional = optional;
        this.resultOpt = resultOpt;
        this.pathOpt = pathOpt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementDetails details = (ElementDetails)o;
        return Double.compare(details.selectivity, this.selectivity) == 0 && Objects.equals(this.range, details.range) && Objects.equals(this.pxdInnerGetVTypes, details.pxdInnerGetVTypes) && this.optional == details.optional && Objects.equals((Object)this.resultOpt, (Object)details.resultOpt) && Objects.equals((Object)this.pathOpt, (Object)details.pathOpt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.selectivity, this.range, this.optional, this.pxdInnerGetVTypes, this.resultOpt, this.pathOpt});
    }

    public double getSelectivity() {
        return this.selectivity;
    }

    public @Nullable PathExpandRange getRange() {
        return this.range;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public List<Integer> getPxdInnerGetVTypes() {
        return Collections.unmodifiableList(this.pxdInnerGetVTypes);
    }

    public GraphOpt.PathExpandResult getResultOpt() {
        return this.resultOpt;
    }

    public GraphOpt.PathExpandPath getPathOpt() {
        return this.pathOpt;
    }

    @Override
    public int compareTo(ElementDetails o) {
        return o == null ? -1 : this.hashCode() - o.hashCode();
    }
}

