/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern;

import com.alibaba.graphscope.common.ir.rel.metadata.glogue.ExtendEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.ExtendStep;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternDirection;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternOrder;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternOrderCanonicalLabelingImpl;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.utils.Combinations;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.EdgeTypeId;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.GlogueSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.isomorphism.VF2GraphIsomorphismInspector;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pattern {
    private int id;
    private final Graph<PatternVertex, PatternEdge> patternGraph;
    private int maxVertexId;
    private int maxEdgeId;
    private PatternOrder patternOrder;
    private final ConnectivityInspector<PatternVertex, PatternEdge> connectivityInspector;
    private static Logger logger = LoggerFactory.getLogger(Pattern.class);
    static final Comparator<PatternVertex> vertexTypeComparator = Comparator.comparing(o -> o.getIsomorphismChecker());
    static final Comparator<PatternEdge> edgeTypeComparator = Comparator.comparing(o -> o.getIsomorphismChecker());

    public Pattern() {
        this.patternGraph = new SimpleDirectedGraph(PatternEdge.class);
        this.connectivityInspector = new ConnectivityInspector(this.patternGraph);
        this.maxVertexId = 0;
        this.maxEdgeId = 0;
    }

    public Pattern(Graph<PatternVertex, PatternEdge> patternGraph) {
        this.patternGraph = patternGraph;
        this.connectivityInspector = new ConnectivityInspector(this.patternGraph);
        this.maxVertexId = patternGraph.vertexSet().size();
        this.maxEdgeId = patternGraph.edgeSet().size();
        this.reordering();
    }

    public Pattern(Pattern pattern) {
        this.patternGraph = new SimpleDirectedGraph(PatternEdge.class);
        for (PatternVertex vertex : pattern.getVertexSet()) {
            this.addVertex(vertex);
        }
        for (PatternEdge edge : pattern.getEdgeSet()) {
            this.addEdge(edge.getSrcVertex(), edge.getDstVertex(), edge);
        }
        this.connectivityInspector = new ConnectivityInspector(this.patternGraph);
        this.maxVertexId = pattern.maxVertexId;
        this.maxEdgeId = pattern.maxEdgeId;
        this.patternOrder = pattern.patternOrder;
    }

    public Pattern(PatternVertex vertex) {
        this.patternGraph = new SimpleDirectedGraph(PatternEdge.class);
        this.patternGraph.addVertex((Object)vertex);
        this.connectivityInspector = new ConnectivityInspector(this.patternGraph);
        this.maxVertexId = 1;
        this.maxEdgeId = 0;
        this.reordering();
    }

    public void setPatternId(int id) {
        this.id = id;
    }

    public Integer getVertexNumber() {
        return this.maxVertexId;
    }

    public Integer getEdgeNumber() {
        return this.maxEdgeId;
    }

    public Set<PatternVertex> getVertexSet() {
        return this.patternGraph.vertexSet();
    }

    public Set<PatternEdge> getEdgeSet() {
        return this.patternGraph.edgeSet();
    }

    public Set<PatternEdge> getEdgesOf(PatternVertex vertex) {
        return this.patternGraph.edgesOf((Object)vertex);
    }

    public List<ExtendStep> getExtendSteps(GlogueSchema schema) {
        ArrayList<ExtendStep> extendSteps = new ArrayList<ExtendStep>();
        List<Integer> targetVertexTypes = schema.getVertexTypes();
        HashMap<Integer, ArrayList<ExtendEdge>> extendEdgesWithDstType = new HashMap<Integer, ArrayList<ExtendEdge>>();
        for (Integer n : targetVertexTypes) {
            HashSet<Integer> consideredGroup = new HashSet<Integer>();
            for (PatternVertex srcPatternVertex : this.getVertexSet()) {
                Integer srcVertexOrder = this.getVertexOrder(srcPatternVertex);
                if (consideredGroup.contains(this.getVertexGroup(srcPatternVertex))) continue;
                consideredGroup.add(srcVertexOrder);
                if (srcPatternVertex.getVertexTypeIds().size() != 1) {
                    throw new UnsupportedOperationException("In ExtendStep, srcPatternVertex " + srcPatternVertex + " is of basic type");
                }
                Integer n2 = srcPatternVertex.getVertexTypeIds().get(0);
                List<EdgeTypeId> outEdges = schema.getEdgeTypes(n2, n);
                for (EdgeTypeId outEdge : outEdges) {
                    if (n2.equals(outEdge.getSrcLabelId())) {
                        ExtendEdge extendEdge = new ExtendEdge((int)srcVertexOrder, outEdge, PatternDirection.OUT);
                        if (extendEdgesWithDstType.containsKey(outEdge.getDstLabelId())) {
                            ((List)extendEdgesWithDstType.get(outEdge.getDstLabelId())).add(extendEdge);
                            continue;
                        }
                        extendEdgesWithDstType.put(outEdge.getDstLabelId(), new ArrayList<ExtendEdge>(Arrays.asList(extendEdge)));
                        continue;
                    }
                    throw new UnsupportedOperationException("In ExtendStep, srcVertexType " + n2 + " is not equal to outEdge srcLabelId " + outEdge.getSrcLabelId());
                }
                List<EdgeTypeId> inEdges = schema.getEdgeTypes(n, n2);
                for (EdgeTypeId inEdge : inEdges) {
                    if (n2.equals(inEdge.getDstLabelId())) {
                        ExtendEdge extendEdge = new ExtendEdge((int)srcVertexOrder, inEdge, PatternDirection.IN);
                        if (extendEdgesWithDstType.containsKey(inEdge.getSrcLabelId())) {
                            ((List)extendEdgesWithDstType.get(inEdge.getSrcLabelId())).add(extendEdge);
                            continue;
                        }
                        extendEdgesWithDstType.put(inEdge.getSrcLabelId(), new ArrayList<ExtendEdge>(Arrays.asList(extendEdge)));
                        continue;
                    }
                    throw new UnsupportedOperationException("In ExtendStep, srcVertexType " + n2 + " is not equal to inEdge dstLabelId " + inEdge.getDstLabelId());
                }
            }
        }
        for (Map.Entry entry : extendEdgesWithDstType.entrySet()) {
            List orginalSet = (List)entry.getValue();
            for (int k = 1; k <= orginalSet.size(); ++k) {
                List subsets = Combinations.getCombinations(orginalSet, k);
                for (List<ExtendEdge> list : subsets) {
                    extendSteps.add(new ExtendStep((Integer)entry.getKey(), list));
                }
            }
        }
        return extendSteps;
    }

    public Pattern extend(ExtendStep extendStep) {
        Pattern newPattern = new Pattern(this);
        Integer targetVertexTypeId = extendStep.getTargetVertexType();
        SinglePatternVertex targetVertex = new SinglePatternVertex(targetVertexTypeId, newPattern.maxVertexId);
        newPattern.addVertex(targetVertex);
        for (ExtendEdge extendEdge : extendStep.getExtendEdges()) {
            SinglePatternEdge edge;
            PatternDirection dir = extendEdge.getDirection();
            Integer srcVertexOrder = extendEdge.getSrcVertexOrder();
            PatternVertex srcVertex = newPattern.getVertexByOrder(srcVertexOrder);
            EdgeTypeId edgeTypeId = extendEdge.getEdgeTypeId();
            if (dir.equals((Object)PatternDirection.OUT)) {
                edge = new SinglePatternEdge(srcVertex, targetVertex, edgeTypeId, newPattern.maxEdgeId);
                newPattern.addEdge(srcVertex, (PatternVertex)targetVertex, edge);
                continue;
            }
            edge = new SinglePatternEdge(targetVertex, srcVertex, edgeTypeId, newPattern.maxEdgeId);
            newPattern.addEdge((PatternVertex)targetVertex, srcVertex, edge);
        }
        newPattern.reordering();
        return newPattern;
    }

    public void reordering() {
        PatternOrderCanonicalLabelingImpl patternOrder = new PatternOrderCanonicalLabelingImpl(this.patternGraph);
        this.patternOrder = patternOrder;
    }

    public boolean addVertex(Integer type) {
        SinglePatternVertex vertex = new SinglePatternVertex(type, this.maxVertexId);
        return this.addVertex(vertex);
    }

    public boolean addVertex(PatternVertex vertex) {
        boolean added = this.patternGraph.addVertex((Object)vertex);
        if (added) {
            ++this.maxVertexId;
        }
        return added;
    }

    public List<Set<PatternVertex>> removeVertex(PatternVertex vertex) {
        boolean removed = this.patternGraph.removeVertex((Object)vertex);
        if (removed) {
            this.maxVertexId = this.patternGraph.vertexSet().size();
            this.maxEdgeId = this.patternGraph.edgeSet().size();
            this.reordering();
        }
        return this.connectivityInspector.connectedSets();
    }

    public boolean removeEdge(PatternEdge edge, boolean removeVertex) {
        boolean removed = this.patternGraph.removeEdge((Object)edge);
        if (removed) {
            if (removeVertex) {
                if (this.getEdgesOf(edge.getSrcVertex()).isEmpty()) {
                    this.patternGraph.removeVertex((Object)edge.getSrcVertex());
                }
                if (this.getEdgesOf(edge.getDstVertex()).isEmpty()) {
                    this.patternGraph.removeVertex((Object)edge.getDstVertex());
                }
                this.maxVertexId = this.patternGraph.vertexSet().size();
            }
            this.maxEdgeId = this.patternGraph.edgeSet().size();
            this.reordering();
        }
        return removed;
    }

    public boolean isConnected() {
        return this.connectivityInspector.connectedSets().size() == 1;
    }

    public List<Set<PatternVertex>> getConnectedComponents() {
        return this.connectivityInspector.connectedSets();
    }

    public int getDegree(PatternVertex vertex) {
        return this.patternGraph.degreeOf((Object)vertex);
    }

    public boolean addEdge(PatternVertex srcVertex, PatternVertex dstVertex, EdgeTypeId edgeTypeId) {
        SinglePatternEdge edge = new SinglePatternEdge(srcVertex, dstVertex, edgeTypeId, this.maxEdgeId);
        return this.addEdge(srcVertex, dstVertex, edge);
    }

    public boolean addEdge(PatternVertex srcVertex, PatternVertex dstVertex, PatternEdge edge) {
        boolean added = this.patternGraph.addEdge((Object)srcVertex, (Object)dstVertex, (Object)edge);
        if (added) {
            ++this.maxEdgeId;
        }
        return added;
    }

    public PatternVertex getVertexById(Integer vertexId) {
        for (PatternVertex vertex : this.patternGraph.vertexSet()) {
            if (!vertex.getId().equals(vertexId)) continue;
            return vertex;
        }
        return null;
    }

    public PatternVertex getVertexByOrder(int vertexId) {
        return this.patternOrder.getVertexByOrder(vertexId);
    }

    public Integer getVertexOrder(PatternVertex vertex) {
        return this.patternOrder.getVertexOrder(vertex);
    }

    public Integer getVertexGroup(PatternVertex vertex) {
        return this.patternOrder.getVertexGroup(vertex);
    }

    public int getPatternId() {
        return this.id;
    }

    public boolean containsVertex(PatternVertex vertex) {
        return this.patternGraph.containsVertex((Object)vertex);
    }

    public String toString() {
        return "Pattern " + this.id + " Vertices: " + this.patternGraph.vertexSet().toString() + ", PatternEdges: " + this.patternGraph.edgeSet().toString() + ", PatternOrder: " + this.patternOrder;
    }

    private boolean preCheck(Pattern other) {
        if (this.maxVertexId != other.maxVertexId || this.maxEdgeId != other.maxEdgeId) {
            return false;
        }
        if (this.patternOrder == null) {
            this.reordering();
        }
        if (other.patternOrder == null) {
            other.reordering();
        }
        return this.patternOrder.equals(other.patternOrder);
    }

    public boolean isIsomorphicTo(Pattern other) {
        return this.isIsomorphicTo(other, vertexTypeComparator, edgeTypeComparator);
    }

    public boolean isIsomorphicTo(Pattern other, Comparator<PatternVertex> vertexComparator, Comparator<PatternEdge> edgeComparator) {
        if (this == other) {
            return true;
        }
        if (!this.preCheck(other)) {
            return false;
        }
        VF2GraphIsomorphismInspector isomorphismInspector = new VF2GraphIsomorphismInspector(this.patternGraph, other.patternGraph, vertexComparator, edgeComparator);
        return isomorphismInspector.isomorphismExists();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pattern) {
            Pattern other = (Pattern)obj;
            return this.isIsomorphicTo(other);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.maxVertexId, this.maxEdgeId, this.patternOrder);
    }
}

