/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern;

import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.IsomorphismChecker;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternOrder;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.color.ColorRefinementAlgorithm;
import org.jgrapht.alg.interfaces.VertexColoringAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternOrderCanonicalLabelingImpl
extends PatternOrder {
    private VertexColoringAlgorithm.Coloring<PatternVertex> initColoring;
    private VertexColoringAlgorithm.Coloring<PatternVertex> uniqueColoring;
    private List<PatternVertex> uniqueColorClass;
    private Map<IsomorphismChecker, List<Integer>> mapCheckerToGroup;
    private static Logger logger = LoggerFactory.getLogger(PatternOrderCanonicalLabelingImpl.class);

    public PatternOrderCanonicalLabelingImpl(Graph<PatternVertex, PatternEdge> patternGraph) {
        HashMap<PatternVertex, Integer> initialColors = new HashMap<PatternVertex, Integer>();
        HashMap<IsomorphismChecker, Integer> initialMapCheckerToColor = new HashMap<IsomorphismChecker, Integer>();
        Integer colorId = 0;
        TreeSet<IsomorphismChecker> checkerSet = new TreeSet<IsomorphismChecker>();
        for (PatternVertex patternVertex : patternGraph.vertexSet()) {
            checkerSet.add(patternVertex.getIsomorphismChecker());
        }
        for (IsomorphismChecker checker : checkerSet) {
            initialMapCheckerToColor.put(checker, colorId);
            Integer n = colorId;
            Integer n2 = colorId = Integer.valueOf(colorId + 1);
        }
        for (PatternVertex patternVertex : patternGraph.vertexSet()) {
            initialColors.put(patternVertex, (Integer)initialMapCheckerToColor.get(patternVertex.getIsomorphismChecker()));
        }
        VertexColoringAlgorithm.ColoringImpl initialColoringImpl = new VertexColoringAlgorithm.ColoringImpl(initialColors, colorId.intValue());
        ColorRefinementAlgorithm colorRefinementAlgorithm = new ColorRefinementAlgorithm(patternGraph, (VertexColoringAlgorithm.Coloring)initialColoringImpl);
        VertexColoringAlgorithm.Coloring<PatternVertex> initColoring = colorRefinementAlgorithm.getColoring();
        this.setTypeGroupMapping(initColoring);
        this.initColoring = initColoring;
        boolean isUniqueColor = this.checkUniqueColor(initColoring);
        Object newColor = !isUniqueColor ? colorRefinementAlgorithm.getColoring() : initColoring;
        while (!isUniqueColor) {
            newColor = this.recolor(patternGraph, (VertexColoringAlgorithm.Coloring<PatternVertex>)newColor);
            isUniqueColor = this.checkUniqueColor((VertexColoringAlgorithm.Coloring<PatternVertex>)newColor);
        }
        this.uniqueColoring = newColor;
        this.uniqueColorClass = newColor.getColorClasses().stream().map(set -> (PatternVertex)set.iterator().next()).collect(Collectors.toList());
    }

    private boolean checkUniqueColor(VertexColoringAlgorithm.Coloring<PatternVertex> patternColoring) {
        List colorClasses = patternColoring.getColorClasses();
        for (Set coloredVertices : colorClasses) {
            if (coloredVertices.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private VertexColoringAlgorithm.Coloring<PatternVertex> recolor(Graph<PatternVertex, PatternEdge> patternGraph, VertexColoringAlgorithm.Coloring<PatternVertex> patternColoring) {
        Map initialColors = patternColoring.getColors();
        List colorClasses = patternColoring.getColorClasses();
        int maxColorId = colorClasses.size();
        for (Set coloredVertices : colorClasses) {
            if (coloredVertices.size() <= 1) continue;
            initialColors.put((PatternVertex)coloredVertices.iterator().next(), maxColorId++);
            break;
        }
        VertexColoringAlgorithm.ColoringImpl initialColoringImpl = new VertexColoringAlgorithm.ColoringImpl(initialColors, maxColorId);
        ColorRefinementAlgorithm colorRefinementAlgorithm = new ColorRefinementAlgorithm(patternGraph, (VertexColoringAlgorithm.Coloring)initialColoringImpl);
        VertexColoringAlgorithm.Coloring newColor = colorRefinementAlgorithm.getColoring();
        return newColor;
    }

    private void setTypeGroupMapping(VertexColoringAlgorithm.Coloring<PatternVertex> color) {
        this.mapCheckerToGroup = new TreeMap<IsomorphismChecker, List<Integer>>();
        Integer groupId = 0;
        List colorClasses = color.getColorClasses();
        for (Set coloredPatternVertices : colorClasses) {
            IsomorphismChecker checker = ((PatternVertex)coloredPatternVertices.iterator().next()).getIsomorphismChecker();
            if (this.mapCheckerToGroup.containsKey(checker)) {
                this.mapCheckerToGroup.get(checker).add(groupId);
            } else {
                this.mapCheckerToGroup.put(checker, new ArrayList<Integer>(Arrays.asList(groupId)));
            }
            Integer n = groupId;
            Integer n2 = groupId = Integer.valueOf(groupId + 1);
        }
    }

    @Override
    public Integer getVertexOrder(PatternVertex vertex) {
        return (Integer)this.uniqueColoring.getColors().get(vertex);
    }

    @Override
    public Integer getVertexGroup(PatternVertex vertex) {
        return (Integer)this.initColoring.getColors().get(vertex);
    }

    @Override
    public PatternVertex getVertexByOrder(Integer id) {
        return this.uniqueColorClass.get(id);
    }

    public String toString() {
        return "uniqueColoring :" + this.uniqueColoring.toString() + ", groupColoring: " + this.initColoring.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PatternOrderCanonicalLabelingImpl) {
            ArrayList<IsomorphismChecker> otherTypeList;
            PatternOrderCanonicalLabelingImpl other = (PatternOrderCanonicalLabelingImpl)obj;
            if (this.mapCheckerToGroup.size() != other.mapCheckerToGroup.size() || this.initColoring.getNumberColors() != other.initColoring.getNumberColors()) {
                return false;
            }
            ArrayList<IsomorphismChecker> thisTypeList = new ArrayList<IsomorphismChecker>(this.mapCheckerToGroup.keySet());
            if (!thisTypeList.equals(otherTypeList = new ArrayList<IsomorphismChecker>(other.mapCheckerToGroup.keySet()))) {
                return false;
            }
            for (IsomorphismChecker checker : this.mapCheckerToGroup.keySet()) {
                if (this.mapCheckerToGroup.get(checker).size() != other.mapCheckerToGroup.get(checker).size()) {
                    logger.debug("In color comparing, numbers of groups for type " + checker + " not equal: " + this.mapCheckerToGroup.get(checker).size() + " vs " + other.mapCheckerToGroup.get(checker).size());
                    return false;
                }
                List<Integer> colors1 = this.mapCheckerToGroup.get(checker);
                colors1.sort(Comparator.naturalOrder());
                List<Integer> colors2 = other.mapCheckerToGroup.get(checker);
                colors2.sort(Comparator.naturalOrder());
                if (colors1.equals(colors2)) continue;
                logger.debug("In groups comparing, groups for type " + checker + " not equal: " + colors1.toString() + " vs " + colors2.toString());
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.mapCheckerToGroup);
    }
}

