/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.type;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.commons.lang3.ObjectUtils;

public class TableConfig {
    private boolean isAll;
    private List<RelOptTable> tables;

    public TableConfig(List<RelOptTable> tables) {
        this.tables = (List)ObjectUtils.requireNonEmpty(tables);
        this.isAll = false;
    }

    public TableConfig isAll(boolean isAll) {
        this.isAll = isAll;
        return this;
    }

    public boolean isAll() {
        return this.isAll;
    }

    public List<RelOptTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public String toString() {
        List labelNames = this.tables.stream().filter(k -> ObjectUtils.isNotEmpty((Object)k.getQualifiedName())).map(k -> (String)k.getQualifiedName().get(0)).collect(Collectors.toList());
        return "{isAll=" + this.isAll + ", tables=" + labelNames + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableConfig that = (TableConfig)o;
        return this.isAll == that.isAll && Objects.equals(this.tables, that.tables);
    }

    public int hashCode() {
        return Objects.hash(this.isAll, this.tables);
    }
}

