/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex;

import com.alibaba.graphscope.common.ir.rex.AbstractCallBinding;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexCallBinding
extends AbstractCallBinding {
    private List<RexNode> rexOperands;
    private List<RelCollation> inputCollations;

    public RexCallBinding(RelDataTypeFactory typeFactory, SqlOperator operator, List<RexNode> operands, List<RelCollation> inputCollations) {
        super(typeFactory, operator);
        this.rexOperands = operands;
        this.inputCollations = inputCollations;
    }

    public @Nullable String getStringLiteralOperand(int ordinal) {
        return RexLiteral.stringValue((RexNode)this.rexOperands.get(ordinal));
    }

    public int getIntLiteralOperand(int ordinal) {
        return RexLiteral.intValue((RexNode)this.rexOperands.get(ordinal));
    }

    public <T> @Nullable T getOperandLiteralValue(int ordinal, Class<T> clazz) {
        RexNode node = this.rexOperands.get(ordinal);
        if (node instanceof RexLiteral) {
            return (T)((RexLiteral)node).getValueAs(clazz);
        }
        return clazz.cast(RexLiteral.value((RexNode)node));
    }

    public boolean isOperandNull(int ordinal, boolean allowCast) {
        return RexUtil.isNullLiteral((RexNode)this.rexOperands.get(ordinal), (boolean)allowCast);
    }

    public boolean isOperandLiteral(int ordinal, boolean allowCast) {
        return RexUtil.isLiteral((RexNode)this.rexOperands.get(ordinal), (boolean)allowCast);
    }

    public int getOperandCount() {
        return this.rexOperands.size();
    }

    public RelDataType getOperandType(int ordinal) {
        return this.rexOperands.get(ordinal).getType();
    }

    public SqlMonotonicity getOperandMonotonicity(int ordinal) {
        throw new UnsupportedOperationException("getOperandMonotonicity is unsupported for we will never use it");
    }

    public CalciteException newValidationSignatureError() {
        String message = String.format("Cannot apply %s to arguments of type %s. Supported form(s): %s", this.getOperator().getName(), this.getCallSignature(), this.getOperator().getAllowedSignatures());
        return new CalciteException(message, null);
    }

    public CalciteException newValidationError(Resources.ExInst<SqlValidatorException> ex) {
        Exception t = ex.ex();
        return new CalciteException(t.getMessage(), (Throwable)t);
    }

    private String getCallSignature() {
        ArrayList<String> signatureList = new ArrayList<String>();
        for (RexNode operand : this.getRexOperands()) {
            RelDataType argType = operand.getType();
            if (null == argType) continue;
            signatureList.add(argType.toString());
        }
        return SqlUtil.getOperatorSignature((SqlOperator)this.getOperator(), signatureList);
    }

    public List<RexNode> getRexOperands() {
        return this.rexOperands;
    }
}

