/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex;

import com.alibaba.graphscope.common.ir.rex.RexConverterAdaptor;
import com.alibaba.graphscope.common.ir.type.GraphProperty;
import java.util.Objects;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexGraphVariable
extends RexInputRef {
    private int aliasId;
    private @Nullable GraphProperty property;

    protected RexGraphVariable(int aliasId, int columnId, @Nullable String name, RelDataType type) {
        super(columnId, type);
        this.aliasId = aliasId;
        this.digest = name == null ? "" : name;
    }

    protected RexGraphVariable(int aliasId, GraphProperty property, int columnId, @Nullable String name, RelDataType type) {
        this(aliasId, columnId, name, type);
        this.property = Objects.requireNonNull(property);
    }

    public static RexGraphVariable of(int aliasId, int columnId, @Nullable String name, RelDataType type) {
        return new RexGraphVariable(aliasId, columnId, name, type);
    }

    public static RexGraphVariable of(int aliasId, GraphProperty property, int columnId, @Nullable String name, RelDataType type) {
        return new RexGraphVariable(aliasId, property, columnId, name, type);
    }

    public <R> R accept(RexVisitor<R> rexVisitor) {
        if (rexVisitor instanceof RexChecker) {
            return null;
        }
        if (rexVisitor instanceof RelOptUtil.RexInputConverter) {
            return (R)new RexConverterAdaptor(true, (RexVisitor<RexNode>)((RelOptUtil.RexInputConverter)rexVisitor)).visitInputRef(this);
        }
        return (R)rexVisitor.visitInputRef((RexInputRef)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RexGraphVariable that = (RexGraphVariable)((Object)o);
        return this.aliasId == that.aliasId && Objects.equals(this.property, that.property);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.aliasId, this.property);
    }

    public String getName() {
        return this.digest;
    }

    public @Nullable int getAliasId() {
        return this.aliasId;
    }

    public @Nullable GraphProperty getProperty() {
        return this.property;
    }
}

