/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex;

import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexGraphVariableList
extends RexGraphVariable
implements List<RexGraphVariable> {
    private final List<RexGraphVariable> innerList;

    protected RexGraphVariableList(int aliasId, int columnId, @Nullable String name, RelDataType type, List<RexGraphVariable> innerList) {
        super(aliasId, columnId, name, type);
        this.innerList = (List)ObjectUtils.requireNonEmpty(innerList);
    }

    public static RexGraphVariable of(List<RexGraphVariable> innerList) {
        if (innerList.size() == 1) {
            return innerList.get(0);
        }
        List digest = innerList.stream().map(var -> var.getName()).collect(Collectors.toList());
        RelRecordType fullyType = new RelRecordType(StructKind.FULLY_QUALIFIED, innerList.stream().map(var -> {
            String[] splits = var.getName().split(Pattern.quote("."));
            String aliasName = splits.length > 0 ? splits[0] : "_";
            return new RelDataTypeFieldImpl(aliasName, var.getAliasId(), var.getType());
        }).collect(Collectors.toList()));
        return new RexGraphVariableList(-1, 100, digest.toString(), (RelDataType)fullyType, innerList);
    }

    @Override
    public int size() {
        return this.innerList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.innerList.contains(o);
    }

    @Override
    public Iterator<RexGraphVariable> iterator() {
        return this.innerList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.innerList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.innerList.toArray(a);
    }

    @Override
    public boolean add(RexGraphVariable variable) {
        return this.innerList.add(variable);
    }

    @Override
    public boolean remove(Object o) {
        return this.innerList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.innerList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends RexGraphVariable> c) {
        return this.innerList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends RexGraphVariable> c) {
        return this.innerList.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.innerList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.innerList.retainAll(c);
    }

    @Override
    public void clear() {
        this.innerList.clear();
    }

    @Override
    public RexGraphVariable get(int index) {
        return this.innerList.get(index);
    }

    @Override
    public RexGraphVariable set(int index, RexGraphVariable element) {
        return this.innerList.set(index, element);
    }

    @Override
    public void add(int index, RexGraphVariable element) {
        this.innerList.add(index, element);
    }

    @Override
    public RexGraphVariable remove(int index) {
        return this.innerList.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.innerList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.innerList.lastIndexOf(o);
    }

    @Override
    public ListIterator<RexGraphVariable> listIterator() {
        return this.innerList.listIterator();
    }

    @Override
    public ListIterator<RexGraphVariable> listIterator(int index) {
        return this.innerList.listIterator(index);
    }

    @Override
    public List<RexGraphVariable> subList(int fromIndex, int toIndex) {
        return this.innerList.subList(fromIndex, toIndex);
    }
}

