/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex;

import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.type.GraphProperty;
import java.util.ArrayList;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;

public class RexVariableAliasConverter
extends RexVisitorImpl<RexNode> {
    private final GraphBuilder builder;
    private final String targetAliasName;
    private final int targetAliasId;

    public RexVariableAliasConverter(boolean deep, GraphBuilder builder, String targetAliasName, int targetAliasId) {
        super(deep);
        this.builder = builder;
        this.targetAliasName = targetAliasName;
        this.targetAliasId = targetAliasId;
    }

    public RexNode visitCall(RexCall call) {
        if (this.deep) {
            ArrayList<RexNode> results = new ArrayList<RexNode>();
            for (RexNode operand : call.getOperands()) {
                results.add((RexNode)operand.accept((RexVisitor)this));
            }
            return this.builder.call(call.getOperator(), results);
        }
        return null;
    }

    public RexNode visitLiteral(RexLiteral literal) {
        return literal;
    }

    public RexNode visitInputRef(RexInputRef inputRef) {
        return inputRef instanceof RexGraphVariable ? this.visitGraphVariable((RexGraphVariable)inputRef) : inputRef;
    }

    public RexNode visitGraphVariable(RexGraphVariable variable) {
        int delimPos = variable.getName().indexOf(".");
        String targetVarName = delimPos < 0 ? AliasInference.SIMPLE_NAME(this.targetAliasName) : AliasInference.SIMPLE_NAME(this.targetAliasName) + "." + variable.getName().substring(delimPos + 1);
        GraphProperty property = variable.getProperty();
        return property == null ? RexGraphVariable.of(this.targetAliasId, variable.getIndex(), targetVarName, variable.getType()) : RexGraphVariable.of(this.targetAliasId, property, variable.getIndex(), targetVarName, variable.getType());
    }

    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return dynamicParam;
    }

    public RexNode visitSubQuery(RexSubQuery subQuery) {
        return subQuery;
    }
}

