/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex.operator;

import com.alibaba.graphscope.common.ir.rex.RexCallBinding;
import com.alibaba.graphscope.common.ir.type.ArbitraryMapType;
import com.alibaba.graphscope.common.ir.type.GraphTypeFactoryImpl;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlMultisetValueConstructor;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlMapValueConstructor
extends SqlMultisetValueConstructor {
    public SqlMapValueConstructor() {
        super("MAP", SqlKind.MAP_VALUE_CONSTRUCTOR);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        List argTypes = opBinding.collectOperandTypes();
        List keyTypes = Util.quotientList((List)argTypes, (int)2, (int)0);
        List valueTypes = Util.quotientList((List)argTypes, (int)2, (int)1);
        RelDataType keyType = this.getComponentType(typeFactory, keyTypes);
        RelDataType valueType = this.getComponentType(typeFactory, valueTypes);
        if (keyType != null && keyType.getSqlTypeName() != SqlTypeName.ANY && valueType != null && valueType.getSqlTypeName() != SqlTypeName.ANY) {
            return SqlTypeUtil.createMapType((RelDataTypeFactory)opBinding.getTypeFactory(), (RelDataType)keyType, (RelDataType)valueType, (boolean)false);
        }
        HashMap keyValueTypeMap = Maps.newHashMap();
        List<RexNode> operands = ((RexCallBinding)opBinding).getRexOperands();
        for (int i = 0; i < operands.size(); i += 2) {
            keyValueTypeMap.put(operands.get(i), new ArbitraryMapType.KeyValueType((RelDataType)keyTypes.get(i / 2), (RelDataType)valueTypes.get(i / 2)));
        }
        return ((GraphTypeFactoryImpl)typeFactory).createArbitraryMapType(keyValueTypeMap, false);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List argTypes = callBinding.collectOperandTypes();
        if (argTypes.size() % 2 > 0) {
            throw callBinding.newValidationError(Static.RESOURCE.mapRequiresEvenArgCount());
        }
        return true;
    }

    protected @Nullable RelDataType getComponentType(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        try {
            RelDataType componentType = typeFactory.leastRestrictive(argTypes);
            return componentType == null ? typeFactory.createSqlType(SqlTypeName.ANY) : componentType;
        }
        catch (Throwable e) {
            return typeFactory.createSqlType(SqlTypeName.ANY);
        }
    }
}

