/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.runtime.ffi;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.intermediate.ArgUtils;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalAggregate;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalDedupBy;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalProject;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalSort;
import com.alibaba.graphscope.common.ir.rel.GraphRelShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.AbstractBindableTableScan;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphGroupKeys;
import com.alibaba.graphscope.common.ir.rel.type.order.GraphFieldCollation;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.runtime.ffi.Utils;
import com.alibaba.graphscope.common.ir.runtime.proto.RexToIndexPbConverter;
import com.alibaba.graphscope.common.ir.runtime.proto.RexToProtoConverter;
import com.alibaba.graphscope.common.ir.runtime.type.PhysicalNode;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.alibaba.graphscope.common.jna.IrCoreLibrary;
import com.alibaba.graphscope.common.jna.type.FfiAlias;
import com.alibaba.graphscope.common.jna.type.FfiBinderOpt;
import com.alibaba.graphscope.common.jna.type.FfiExpandOpt;
import com.alibaba.graphscope.common.jna.type.FfiJoinKind;
import com.alibaba.graphscope.common.jna.type.FfiPbPointer;
import com.alibaba.graphscope.common.jna.type.FfiResult;
import com.alibaba.graphscope.common.jna.type.ResultCode;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.GraphAlgebra;
import com.alibaba.graphscope.gaia.proto.OuterExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelToFfiConverter
implements GraphRelShuttle {
    private static final Logger logger = LoggerFactory.getLogger(RelToFfiConverter.class);
    private static final IrCoreLibrary LIB = IrCoreLibrary.INSTANCE;
    private final boolean isColumnId;
    private final RexBuilder rexBuilder;

    public RelToFfiConverter(boolean isColumnId, Configs configs) {
        this.isColumnId = isColumnId;
        this.rexBuilder = GraphPlanner.rexBuilderFactory.apply(configs);
    }

    @Override
    public RelNode visit(GraphLogicalSource source) {
        Pointer ptrScan = LIB.initScanOperator(Utils.ffiScanOpt(source.getOpt()));
        if (source.getUniqueKeyFilters() != null) {
            this.checkFfiResult(LIB.addIndexPredicatePb(ptrScan, this.ffiIndexPredicates(source.getUniqueKeyFilters())));
        }
        this.checkFfiResult(LIB.setScanParams(ptrScan, this.ffiQueryParams(source)));
        if (source.getAliasId() != -1) {
            this.checkFfiResult(LIB.setScanAlias(ptrScan, ArgUtils.asAlias(source.getAliasId())));
        }
        this.checkFfiResult(LIB.setScanMeta(ptrScan, new FfiPbPointer.ByValue(com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoRowType(source.getRowType(), this.isColumnId).get(0).toByteArray())));
        return new PhysicalNode<Pointer>((RelNode)source, ptrScan);
    }

    @Override
    public RelNode visit(GraphLogicalExpand expand) {
        Pointer ptrExpand = LIB.initEdgexpdOperator(FfiExpandOpt.Edge, Utils.ffiDirection(expand.getOpt()));
        this.checkFfiResult(LIB.setEdgexpdParams(ptrExpand, this.ffiQueryParams(expand)));
        if (expand.getAliasId() != -1) {
            this.checkFfiResult(LIB.setEdgexpdAlias(ptrExpand, ArgUtils.asAlias(expand.getAliasId())));
        }
        if (expand.getStartAlias().getAliasId() != -1) {
            this.checkFfiResult(LIB.setEdgexpdVtag(ptrExpand, ArgUtils.asNameOrId(expand.getStartAlias().getAliasId())));
        }
        this.checkFfiResult(LIB.setEdgexpdMeta(ptrExpand, new FfiPbPointer.ByValue(com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoRowType(expand.getRowType(), this.isColumnId).get(0).toByteArray())));
        return new PhysicalNode<Pointer>((RelNode)expand, ptrExpand);
    }

    @Override
    public RelNode visit(GraphPhysicalExpand physicalExpand) {
        GraphLogicalExpand fusedExpand = physicalExpand.getFusedExpand();
        Pointer ptrPhysicalExpand = LIB.initEdgexpdOperator(Utils.ffiPhysicalExpandOpt(physicalExpand.getPhysicalOpt()), Utils.ffiDirection(fusedExpand.getOpt()));
        this.checkFfiResult(LIB.setEdgexpdParams(ptrPhysicalExpand, this.ffiQueryParams(fusedExpand)));
        if (physicalExpand.getAliasId() != -1) {
            this.checkFfiResult(LIB.setEdgexpdAlias(ptrPhysicalExpand, ArgUtils.asAlias(physicalExpand.getAliasId())));
        }
        this.checkFfiResult(LIB.setEdgexpdMeta(ptrPhysicalExpand, new FfiPbPointer.ByValue(com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoRowType(physicalExpand.getRowType(), this.isColumnId).get(0).toByteArray())));
        return new PhysicalNode<Pointer>((RelNode)physicalExpand, ptrPhysicalExpand);
    }

    @Override
    public RelNode visit(GraphLogicalGetV getV) {
        Pointer ptrGetV = LIB.initGetvOperator(Utils.ffiVOpt(getV.getOpt()));
        this.checkFfiResult(LIB.setGetvParams(ptrGetV, this.ffiQueryParams(getV)));
        if (getV.getAliasId() != -1) {
            this.checkFfiResult(LIB.setGetvAlias(ptrGetV, ArgUtils.asAlias(getV.getAliasId())));
        }
        if (getV.getStartAlias().getAliasId() != -1) {
            this.checkFfiResult(LIB.setGetvTag(ptrGetV, ArgUtils.asNameOrId(getV.getStartAlias().getAliasId())));
        }
        this.checkFfiResult(LIB.setGetvMeta(ptrGetV, new FfiPbPointer.ByValue(com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoRowType(getV.getRowType(), this.isColumnId).get(0).toByteArray())));
        return new PhysicalNode<Pointer>((RelNode)getV, ptrGetV);
    }

    @Override
    public RelNode visit(GraphLogicalPathExpand pxd) {
        PhysicalNode expand = (PhysicalNode)this.visit((GraphLogicalExpand)pxd.getExpand());
        PhysicalNode getV = (PhysicalNode)this.visit((GraphLogicalGetV)pxd.getGetV());
        Pointer ptrPxd = LIB.initPathxpdOperatorWithExpandBase((Pointer)expand.getNode(), (Pointer)getV.getNode(), Utils.ffiPathOpt(pxd.getPathOpt()), Utils.ffiResultOpt(pxd.getResultOpt()));
        List<Integer> hops = this.range(pxd.getOffset(), pxd.getFetch());
        this.checkFfiResult(LIB.setPathxpdHops(ptrPxd, hops.get(0), hops.get(1)));
        if (pxd.getAliasId() != -1) {
            this.checkFfiResult(LIB.setPathxpdAlias(ptrPxd, ArgUtils.asAlias(pxd.getAliasId())));
        }
        if (pxd.getStartAlias().getAliasId() != -1) {
            this.checkFfiResult(LIB.setPathxpdTag(ptrPxd, ArgUtils.asNameOrId(pxd.getStartAlias().getAliasId())));
        }
        return new PhysicalNode<Pointer>((RelNode)pxd, ptrPxd);
    }

    @Override
    public RelNode visit(GraphLogicalSingleMatch match) {
        switch (match.getMatchOpt()) {
            case INNER: {
                Pointer ptrPattern = LIB.initPatternOperator();
                Pointer ptrSentence = LIB.initPatternSentence(FfiJoinKind.Inner);
                this.addFfiBinder(ptrSentence, match.getSentence(), true);
                this.checkFfiResult(LIB.addPatternSentence(ptrPattern, ptrSentence));
                com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoRowType(match.getRowType(), this.isColumnId).forEach(k -> this.checkFfiResult(LIB.addPatternMeta(ptrPattern, new FfiPbPointer.ByValue(k.toByteArray()))));
                Pointer ptrScan = LIB.initScanOperator(Utils.ffiScanOpt(GraphOpt.Source.VERTEX));
                return new PhysicalNode((RelNode)match, ImmutableList.of((Object)ptrScan, (Object)ptrPattern));
            }
        }
        throw new UnsupportedOperationException("optional or anti is unsupported yet");
    }

    @Override
    public RelNode visit(GraphLogicalMultiMatch match) {
        Pointer ptrPattern = LIB.initPatternOperator();
        for (RelNode sentence : match.getSentences()) {
            Pointer ptrSentence = LIB.initPatternSentence(FfiJoinKind.Inner);
            this.addFfiBinder(ptrSentence, sentence, true);
            this.checkFfiResult(LIB.addPatternSentence(ptrPattern, ptrSentence));
        }
        com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoRowType(match.getRowType(), this.isColumnId).forEach(k -> this.checkFfiResult(LIB.addPatternMeta(ptrPattern, new FfiPbPointer.ByValue(k.toByteArray()))));
        Pointer ptrScan = LIB.initScanOperator(Utils.ffiScanOpt(GraphOpt.Source.VERTEX));
        return new PhysicalNode((RelNode)match, ImmutableList.of((Object)ptrScan, (Object)ptrPattern));
    }

    @Override
    public RelNode visit(LogicalFilter logicalFilter) {
        OuterExpression.Expression exprProto = (OuterExpression.Expression)logicalFilter.getCondition().accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
        Pointer ptrFilter = LIB.initSelectOperator();
        this.checkFfiResult(LIB.setSelectPredicatePb(ptrFilter, new FfiPbPointer.ByValue(exprProto.toByteArray())));
        return new PhysicalNode<Pointer>((RelNode)logicalFilter, ptrFilter);
    }

    public PhysicalNode visit(GraphLogicalProject project) {
        Pointer ptrProject = LIB.initProjectOperator(project.isAppend());
        List fields = project.getRowType().getFieldList();
        for (int i = 0; i < project.getProjects().size(); ++i) {
            OuterExpression.Expression expression = (OuterExpression.Expression)((RexNode)project.getProjects().get(i)).accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
            int aliasId = ((RelDataTypeField)fields.get(i)).getIndex();
            FfiAlias.ByValue ffiAlias = aliasId == -1 ? ArgUtils.asNoneAlias() : ArgUtils.asAlias(aliasId);
            this.checkFfiResult(LIB.addProjectExprPbAlias(ptrProject, new FfiPbPointer.ByValue(expression.toByteArray()), ffiAlias));
        }
        com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoRowType(project.getRowType(), this.isColumnId).forEach(k -> this.checkFfiResult(LIB.addProjectMeta(ptrProject, new FfiPbPointer.ByValue(k.toByteArray()))));
        return new PhysicalNode<Pointer>((RelNode)project, ptrProject);
    }

    public PhysicalNode visit(GraphLogicalAggregate aggregate) {
        int aliasId;
        int i;
        List<GraphAggCall> groupCalls = aggregate.getAggCalls();
        if (groupCalls.isEmpty()) {
            GraphGroupKeys keys = aggregate.getGroupKey();
            Preconditions.checkArgument((keys.groupKeyCount() > 0 ? 1 : 0) != 0, (Object)"group keys should not be empty while group calls is empty");
            List fields = aggregate.getRowType().getFieldList();
            Pointer ptrProject = LIB.initProjectOperator(false);
            for (int i2 = 0; i2 < keys.groupKeyCount(); ++i2) {
                int aliasId2;
                RexNode var = keys.getVariables().get(i2);
                Preconditions.checkArgument((boolean)(var instanceof RexGraphVariable), (String)"each group key should be type %s, but is %s", RexGraphVariable.class, var.getClass());
                OuterExpression.Expression expr = (OuterExpression.Expression)var.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
                if (i2 >= fields.size() || (aliasId2 = ((RelDataTypeField)fields.get(i2)).getIndex()) == -1) {
                    throw new IllegalArgumentException("each group key should have an alias if need dedup");
                }
                this.checkFfiResult(LIB.addProjectExprPbAlias(ptrProject, new FfiPbPointer.ByValue(expr.toByteArray()), ArgUtils.asAlias(aliasId2)));
            }
            Pointer ptrDedup = LIB.initDedupOperator();
            for (int i3 = 0; i3 < keys.groupKeyCount(); ++i3) {
                RelDataTypeField field = (RelDataTypeField)fields.get(i3);
                RexGraphVariable rexVar = RexGraphVariable.of(field.getIndex(), 100, field.getName(), field.getType());
                OuterExpression.Variable exprVar = ((OuterExpression.Expression)rexVar.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
                this.checkFfiResult(LIB.addDedupKeyPb(ptrDedup, new FfiPbPointer.ByValue(exprVar.toByteArray())));
            }
            return new PhysicalNode((RelNode)aggregate, ImmutableList.of((Object)ptrProject, (Object)ptrDedup));
        }
        Pointer ptrGroup = LIB.initGroupbyOperator();
        List fields = aggregate.getRowType().getFieldList();
        List<RexNode> groupKeys = aggregate.getGroupKey().getVariables();
        for (i = 0; i < groupKeys.size(); ++i) {
            Preconditions.checkArgument((boolean)(groupKeys.get(i) instanceof RexGraphVariable), (String)"each group key should be type %s, but is %s", RexGraphVariable.class, groupKeys.get(i).getClass());
            OuterExpression.Variable var = ((OuterExpression.Expression)groupKeys.get(i).accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
            aliasId = ((RelDataTypeField)fields.get(i)).getIndex();
            FfiAlias.ByValue ffiAlias = aliasId == -1 ? ArgUtils.asNoneAlias() : ArgUtils.asAlias(aliasId);
            this.checkFfiResult(LIB.addGroupbyKeyPbAlias(ptrGroup, new FfiPbPointer.ByValue(var.toByteArray()), ffiAlias));
        }
        for (i = 0; i < groupCalls.size(); ++i) {
            List<RexNode> operands = groupCalls.get(i).getOperands();
            if (operands.isEmpty()) {
                throw new IllegalArgumentException("operands in aggregate call should not be empty");
            }
            aliasId = ((RelDataTypeField)fields.get(i + groupKeys.size())).getIndex();
            Common.NameOrId alias = aliasId == -1 ? Common.NameOrId.newBuilder().build() : Common.NameOrId.newBuilder().setId(aliasId).build();
            List vars = operands.stream().map(k -> {
                Preconditions.checkArgument((boolean)(k instanceof RexGraphVariable), (String)"each operand in aggregate call should be type %s, but is %s", RexGraphVariable.class, k.getClass());
                return ((OuterExpression.Expression)k.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
            }).collect(Collectors.toList());
            this.checkFfiResult(LIB.addGroupbyAggFnPb(ptrGroup, new FfiPbPointer.ByValue(GraphAlgebra.GroupBy.AggFunc.newBuilder().addAllVars(vars).setAggregate(com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoAggFn(groupCalls.get(i))).setAlias(alias).build().toByteArray())));
        }
        com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoRowType(aggregate.getRowType(), this.isColumnId).forEach(k -> this.checkFfiResult(LIB.addGroupbyKeyValueMeta(ptrGroup, new FfiPbPointer.ByValue(k.toByteArray()))));
        return new PhysicalNode<Pointer>((RelNode)aggregate, ptrGroup);
    }

    public PhysicalNode visit(GraphLogicalDedupBy dedupBy) {
        Preconditions.checkArgument((!dedupBy.getDedupByKeys().isEmpty() ? 1 : 0) != 0, (Object)"dedup by keys should not be empty");
        Pointer ptrDedup = LIB.initDedupOperator();
        for (RexNode key : dedupBy.getDedupByKeys()) {
            Preconditions.checkArgument((boolean)(key instanceof RexGraphVariable), (String)"each dedup by key should be type %s, but is %s", RexGraphVariable.class, key.getClass());
            OuterExpression.Variable var = ((OuterExpression.Expression)key.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
            this.checkFfiResult(LIB.addDedupKeyPb(ptrDedup, new FfiPbPointer.ByValue(var.toByteArray())));
        }
        return new PhysicalNode<Pointer>((RelNode)dedupBy, ptrDedup);
    }

    public PhysicalNode visit(GraphLogicalSort sort) {
        List collations = sort.getCollation().getFieldCollations();
        Pointer ptrNode = null;
        if (!collations.isEmpty()) {
            ptrNode = LIB.initOrderbyOperator();
            for (int i = 0; i < collations.size(); ++i) {
                RexGraphVariable expr = ((GraphFieldCollation)((Object)collations.get(i))).getVariable();
                OuterExpression.Variable var = ((OuterExpression.Expression)expr.accept(new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
                this.checkFfiResult(LIB.addOrderbyPairPb(ptrNode, new FfiPbPointer.ByValue(var.toByteArray()), Utils.ffiOrderOpt(((RelFieldCollation)collations.get((int)i)).direction)));
            }
        }
        if (sort.offset != null || sort.fetch != null) {
            List<Integer> limitRange = this.range(sort.offset, sort.fetch);
            if (collations.isEmpty()) {
                ptrNode = LIB.initLimitOperator();
                this.checkFfiResult(LIB.setLimitRange(ptrNode, limitRange.get(0), limitRange.get(1)));
            } else if (ptrNode != null) {
                this.checkFfiResult(LIB.setOrderbyLimit(ptrNode, limitRange.get(0), limitRange.get(1)));
            }
        }
        return new PhysicalNode<Pointer>((RelNode)sort, ptrNode);
    }

    public PhysicalNode visit(LogicalJoin join) {
        Pointer ptrJoin = LIB.initJoinOperator(Utils.ffiJoinKind(join.getJoinType()));
        List conditions = RelOptUtil.conjunctions((RexNode)join.getCondition());
        String errorMessage = "join condition in ir core should be 'AND' of equal conditions, each equal condition has two variables as operands";
        Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0, (Object)errorMessage);
        for (RexNode condition : conditions) {
            List<RexGraphVariable> leftRightVars = this.getLeftRightVariables(condition);
            Preconditions.checkArgument((leftRightVars.size() == 2 ? 1 : 0) != 0, (Object)errorMessage);
            OuterExpression.Variable leftVar = ((OuterExpression.Expression)leftRightVars.get(0).accept(new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
            OuterExpression.Variable rightVar = ((OuterExpression.Expression)leftRightVars.get(1).accept(new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
            this.checkFfiResult(LIB.addJoinKeyPairPb(ptrJoin, new FfiPbPointer.ByValue(leftVar.toByteArray()), new FfiPbPointer.ByValue(rightVar.toByteArray())));
        }
        return new PhysicalNode<Pointer>((RelNode)join, ptrJoin);
    }

    private List<RexGraphVariable> getLeftRightVariables(RexNode condition) {
        RexCall call;
        ArrayList vars = Lists.newArrayList();
        if (condition instanceof RexCall && (call = (RexCall)condition).getOperator().getKind() == SqlKind.EQUALS) {
            RexNode left = (RexNode)call.getOperands().get(0);
            RexNode right = (RexNode)call.getOperands().get(1);
            if (left instanceof RexGraphVariable && right instanceof RexGraphVariable) {
                vars.add((RexGraphVariable)left);
                vars.add((RexGraphVariable)right);
            }
        }
        return vars;
    }

    private Pointer ffiQueryParams(AbstractBindableTableScan tableScan) {
        Set<Integer> uniqueLabelIds = this.getGraphLabels(tableScan).getLabelsEntry().stream().map(k -> k.getLabelId()).collect(Collectors.toSet());
        Pointer params = LIB.initQueryParams();
        uniqueLabelIds.forEach(k -> this.checkFfiResult(LIB.addParamsTable(params, ArgUtils.asNameOrId(k))));
        if (ObjectUtils.isNotEmpty(tableScan.getFilters())) {
            OuterExpression.Expression expression = (OuterExpression.Expression)((RexNode)tableScan.getFilters().get(0)).accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
            this.checkFfiResult(LIB.setParamsPredicatePb(params, new FfiPbPointer.ByValue(expression.toByteArray())));
        }
        return params;
    }

    private FfiPbPointer.ByValue ffiIndexPredicates(RexNode uniqueKeyFilters) {
        GraphAlgebra.IndexPredicate indexPredicate = (GraphAlgebra.IndexPredicate)uniqueKeyFilters.accept((RexVisitor)new RexToIndexPbConverter(true, this.isColumnId, this.rexBuilder));
        return new FfiPbPointer.ByValue(indexPredicate.toByteArray());
    }

    private List<Integer> range(RexNode offset, RexNode fetch) {
        if (offset != null && !(offset instanceof RexLiteral) || fetch != null && !(fetch instanceof RexLiteral)) {
            throw new IllegalArgumentException("can not get INTEGER hops from types instead of RexLiteral");
        }
        int lower = offset == null ? 0 : ((Number)((Object)((RexLiteral)offset).getValue())).intValue();
        int upper = fetch == null ? Integer.MAX_VALUE : lower + ((Number)((Object)((RexLiteral)fetch).getValue())).intValue();
        return ImmutableList.of((Object)lower, (Object)upper);
    }

    private void addFfiBinder(Pointer ptrSentence, RelNode binder, boolean isTail) {
        if (binder.getInputs().isEmpty()) {
            if (!(binder instanceof GraphLogicalSource) || ((GraphLogicalSource)binder).getOpt() != GraphOpt.Source.VERTEX) {
                throw new IllegalArgumentException("start binder in each sentence should be vertex type");
            }
            GraphLogicalSource source = (GraphLogicalSource)binder;
            int aliasId = source.getAliasId();
            if (aliasId == -1) {
                throw new IllegalArgumentException("start binder should have a given tag");
            }
            this.checkFfiResult(LIB.setSentenceStart(ptrSentence, ArgUtils.asNameOrId(aliasId)));
            this.addFilterToFfiBinder(ptrSentence, source);
        } else {
            this.addFfiBinder(ptrSentence, binder.getInput(0), false);
            if (binder instanceof AbstractBindableTableScan) {
                PhysicalNode node;
                if (binder instanceof GraphLogicalExpand) {
                    node = (PhysicalNode)this.visit((GraphLogicalExpand)binder);
                    this.checkFfiResult(LIB.addSentenceBinder(ptrSentence, (Pointer)node.getNode(), FfiBinderOpt.Edge));
                } else {
                    node = (PhysicalNode)this.visit((GraphLogicalGetV)binder);
                    this.checkFfiResult(LIB.addSentenceBinder(ptrSentence, (Pointer)node.getNode(), FfiBinderOpt.Vertex));
                }
                int aliasId = ((AbstractBindableTableScan)binder).getAliasId();
                if (isTail && aliasId != -1) {
                    this.checkFfiResult(LIB.setSentenceEnd(ptrSentence, ArgUtils.asNameOrId(aliasId)));
                }
            } else if (binder instanceof GraphLogicalPathExpand) {
                PhysicalNode node = (PhysicalNode)this.visit((GraphLogicalPathExpand)binder);
                this.checkFfiResult(LIB.addSentenceBinder(ptrSentence, (Pointer)node.getNode(), FfiBinderOpt.Path));
                int aliasId = ((GraphLogicalPathExpand)binder).getAliasId();
                if (isTail && aliasId != -1) {
                    this.checkFfiResult(LIB.setSentenceEnd(ptrSentence, ArgUtils.asNameOrId(aliasId)));
                }
            } else {
                throw new IllegalArgumentException("invalid type " + binder.getClass() + " in match sentence");
            }
        }
    }

    private void addFilterToFfiBinder(Pointer ptrSentence, AbstractBindableTableScan tableScan) {
        ImmutableList<RexNode> filters;
        OuterExpression.Expression exprProto;
        GraphLogicalSource source;
        Set uniqueLabelIds = this.getGraphLabels(tableScan).getLabelsEntry().stream().map(k -> k.getLabelId()).collect(Collectors.toSet());
        if (ObjectUtils.isNotEmpty(uniqueLabelIds)) {
            Pointer ptrFilter = LIB.initSelectOperator();
            StringBuilder predicateBuilder = new StringBuilder();
            predicateBuilder.append("@.~label within [");
            int i = 0;
            Iterator it = uniqueLabelIds.iterator();
            while (it.hasNext()) {
                if (i > 0) {
                    predicateBuilder.append(",");
                }
                predicateBuilder.append(it.next());
                ++i;
            }
            predicateBuilder.append("]");
            this.checkFfiResult(LIB.setSelectPredicate(ptrFilter, predicateBuilder.toString()));
            this.checkFfiResult(LIB.addSentenceBinder(ptrSentence, ptrFilter, FfiBinderOpt.Select));
        }
        if (tableScan instanceof GraphLogicalSource && (source = (GraphLogicalSource)tableScan).getUniqueKeyFilters() != null) {
            exprProto = (OuterExpression.Expression)source.getUniqueKeyFilters().accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
            Pointer ptrFilter = LIB.initSelectOperator();
            this.checkFfiResult(LIB.setSelectPredicatePb(ptrFilter, new FfiPbPointer.ByValue(exprProto.toByteArray())));
            this.checkFfiResult(LIB.addSentenceBinder(ptrSentence, ptrFilter, FfiBinderOpt.Select));
        }
        if (ObjectUtils.isNotEmpty(filters = tableScan.getFilters())) {
            exprProto = (OuterExpression.Expression)((RexNode)filters.get(0)).accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
            Pointer ptrFilter = LIB.initSelectOperator();
            this.checkFfiResult(LIB.setSelectPredicatePb(ptrFilter, new FfiPbPointer.ByValue(exprProto.toByteArray())));
            this.checkFfiResult(LIB.addSentenceBinder(ptrSentence, ptrFilter, FfiBinderOpt.Select));
        }
    }

    private GraphLabelType getGraphLabels(AbstractBindableTableScan tableScan) {
        List fields = tableScan.getRowType().getFieldList();
        Preconditions.checkArgument((!fields.isEmpty() && ((RelDataTypeField)fields.get(0)).getType() instanceof GraphSchemaType ? 1 : 0) != 0, (String)"data type of graph operators should be %s ", GraphSchemaType.class);
        GraphSchemaType schemaType = (GraphSchemaType)((RelDataTypeField)fields.get(0)).getType();
        return schemaType.getLabelType();
    }

    private void checkFfiResult(FfiResult res) {
        if (res == null || res.code != ResultCode.Success) {
            throw new IllegalStateException("build logical node, unexpected ffi results from ir_core, msg : %s" + res);
        }
    }
}

