/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.runtime.ffi;

import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.jna.type.FfiAggOpt;
import com.alibaba.graphscope.common.jna.type.FfiConst;
import com.alibaba.graphscope.common.jna.type.FfiDataType;
import com.alibaba.graphscope.common.jna.type.FfiDirection;
import com.alibaba.graphscope.common.jna.type.FfiExpandOpt;
import com.alibaba.graphscope.common.jna.type.FfiJoinKind;
import com.alibaba.graphscope.common.jna.type.FfiOrderOpt;
import com.alibaba.graphscope.common.jna.type.FfiScanOpt;
import com.alibaba.graphscope.common.jna.type.FfiVOpt;
import com.alibaba.graphscope.common.jna.type.PathOpt;
import com.alibaba.graphscope.common.jna.type.ResultOpt;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.NlsString;

public abstract class Utils {
    public static final FfiScanOpt ffiScanOpt(GraphOpt.Source opt) {
        switch (opt) {
            case VERTEX: {
                return FfiScanOpt.Entity;
            }
        }
        return FfiScanOpt.Relation;
    }

    public static final FfiDirection ffiDirection(GraphOpt.Expand opt) {
        switch (opt) {
            case OUT: {
                return FfiDirection.Out;
            }
            case IN: {
                return FfiDirection.In;
            }
        }
        return FfiDirection.Both;
    }

    public static final FfiExpandOpt ffiPhysicalExpandOpt(GraphOpt.PhysicalExpandOpt opt) {
        switch (opt) {
            case DEGREE: {
                return FfiExpandOpt.Degree;
            }
            case EDGE: {
                return FfiExpandOpt.Edge;
            }
        }
        return FfiExpandOpt.Vertex;
    }

    public static final FfiVOpt ffiVOpt(GraphOpt.GetV opt) {
        switch (opt) {
            case START: {
                return FfiVOpt.Start;
            }
            case END: {
                return FfiVOpt.End;
            }
            case OTHER: {
                return FfiVOpt.Other;
            }
        }
        return FfiVOpt.Both;
    }

    public static final FfiConst.ByValue ffiConst(RexLiteral literal) {
        FfiConst.ByValue ffiConst = new FfiConst.ByValue();
        switch (literal.getType().getSqlTypeName()) {
            case BOOLEAN: {
                ffiConst.dataType = FfiDataType.Boolean;
                ffiConst.bool = (Boolean)literal.getValue();
                break;
            }
            case INTEGER: {
                ffiConst.dataType = FfiDataType.I32;
                ffiConst.int32 = ((Number)((Object)literal.getValue())).intValue();
                break;
            }
            case BIGINT: {
                ffiConst.dataType = FfiDataType.I64;
                ffiConst.int64 = ((Number)((Object)literal.getValue())).longValue();
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                ffiConst.dataType = FfiDataType.F64;
                ffiConst.float64 = ((Number)((Object)literal.getValue())).doubleValue();
                break;
            }
            case CHAR: {
                ffiConst.dataType = FfiDataType.Str;
                ffiConst.cstr = literal.getValue() instanceof NlsString ? ((NlsString)literal.getValue()).getValue() : (String)((Object)literal.getValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException("convert type " + literal.getType().getSqlTypeName() + " to FfiConst is unsupported");
            }
        }
        return ffiConst;
    }

    public static final PathOpt ffiPathOpt(GraphOpt.PathExpandPath opt) {
        switch (opt) {
            case ARBITRARY: {
                return PathOpt.Arbitrary;
            }
            case TRAIL: {
                return PathOpt.Trail;
            }
        }
        return PathOpt.Simple;
    }

    public static final ResultOpt ffiResultOpt(GraphOpt.PathExpandResult opt) {
        switch (opt) {
            case END_V: {
                return ResultOpt.EndV;
            }
            case ALL_V: {
                return ResultOpt.AllV;
            }
        }
        return ResultOpt.AllVE;
    }

    public static final FfiAggOpt ffiAggOpt(GraphAggCall aggCall) {
        switch (aggCall.getAggFunction().kind) {
            case COUNT: {
                return aggCall.isDistinct() ? FfiAggOpt.CountDistinct : FfiAggOpt.Count;
            }
            case COLLECT: {
                return aggCall.isDistinct() ? FfiAggOpt.ToSet : FfiAggOpt.ToList;
            }
            case SUM: 
            case SUM0: {
                return FfiAggOpt.Sum;
            }
            case AVG: {
                return FfiAggOpt.Avg;
            }
            case MIN: {
                return FfiAggOpt.Min;
            }
            case MAX: {
                return FfiAggOpt.Max;
            }
            case FIRST_VALUE: {
                return FfiAggOpt.First;
            }
        }
        throw new UnsupportedOperationException("aggregate opt " + aggCall.getAggFunction().kind + " is unsupported yet");
    }

    public static final FfiOrderOpt ffiOrderOpt(RelFieldCollation.Direction direction) {
        switch (direction) {
            case ASCENDING: {
                return FfiOrderOpt.Asc;
            }
            case DESCENDING: {
                return FfiOrderOpt.Desc;
            }
            case CLUSTERED: {
                return FfiOrderOpt.Shuffle;
            }
        }
        throw new UnsupportedOperationException("direction " + direction + " in order is unsupported yet");
    }

    public static FfiJoinKind ffiJoinKind(JoinRelType joinType) {
        switch (joinType) {
            case INNER: {
                return FfiJoinKind.Inner;
            }
            case LEFT: {
                return FfiJoinKind.LeftOuter;
            }
            case RIGHT: {
                return FfiJoinKind.RightOuter;
            }
            case FULL: {
                return FfiJoinKind.FullOuter;
            }
            case SEMI: {
                return FfiJoinKind.Semi;
            }
            case ANTI: {
                return FfiJoinKind.Anti;
            }
        }
        throw new UnsupportedOperationException("join type " + joinType + " is unsupported yet");
    }
}

