/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.runtime.proto;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.SnapshotId;
import com.alibaba.graphscope.common.ir.meta.schema.CommonOptTable;
import com.alibaba.graphscope.common.ir.rel.CommonTableScan;
import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.runtime.PhysicalBuilder;
import com.alibaba.graphscope.common.ir.runtime.PhysicalPlan;
import com.alibaba.graphscope.common.ir.runtime.proto.GraphRelToProtoConverter;
import com.alibaba.graphscope.common.ir.runtime.proto.Utils;
import com.alibaba.graphscope.common.ir.tools.LogicalPlan;
import com.alibaba.graphscope.gaia.proto.GraphAlgebra;
import com.alibaba.graphscope.gaia.proto.GraphAlgebraPhysical;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelDigest;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphRelProtoPhysicalBuilder
extends PhysicalBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GraphRelProtoPhysicalBuilder.class);
    private final GraphShuttle relShuttle;
    private final GraphAlgebraPhysical.PhysicalPlan.Builder physicalBuilder = GraphAlgebraPhysical.PhysicalPlan.newBuilder();
    private final IdentityHashMap<RelNode, List<CommonTableScan>> relToCommons;
    private final boolean skipSinkColumns;

    public GraphRelProtoPhysicalBuilder(Configs graphConfig, IrMeta irMeta, LogicalPlan logicalPlan) {
        this(graphConfig, irMeta, logicalPlan, false);
    }

    @VisibleForTesting
    public GraphRelProtoPhysicalBuilder(Configs graphConfig, IrMeta irMeta, LogicalPlan logicalPlan, boolean skipSinkColumns) {
        super(logicalPlan);
        this.relToCommons = this.createRelToCommons(logicalPlan);
        this.relShuttle = new GraphRelToProtoConverter(irMeta.getSchema().isColumnId(), graphConfig, this.physicalBuilder, this.relToCommons, this.createExtraParams(irMeta));
        this.skipSinkColumns = skipSinkColumns;
    }

    @Override
    public PhysicalPlan build() {
        String plan = null;
        try {
            RelNode regularQuery = this.logicalPlan.getRegularQuery();
            regularQuery.accept((RelShuttle)this.relShuttle);
            this.physicalBuilder.addPlan(GraphAlgebraPhysical.PhysicalOpr.newBuilder().setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setSink(this.getSinkByColumns(regularQuery))));
            plan = this.getPlanAsJson(this.physicalBuilder.build());
            int planId = Objects.hash(this.logicalPlan);
            this.physicalBuilder.setPlanId(planId);
            GraphAlgebraPhysical.PhysicalPlan physicalPlan = this.physicalBuilder.build();
            byte[] bytes = physicalPlan.toByteArray();
            return new PhysicalPlan<byte[]>(bytes, plan);
        }
        catch (Exception e) {
            logger.error("ir physical plan {}, error {}", plan, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private GraphAlgebraPhysical.Sink getSinkByColumns(RelNode regularQuery) {
        GraphAlgebraPhysical.Sink.Builder sinkBuilder = GraphAlgebraPhysical.Sink.newBuilder();
        sinkBuilder.setSinkTarget(GraphAlgebra.Sink.SinkTarget.newBuilder().setSinkDefault(GraphAlgebra.SinkDefault.newBuilder().build()));
        regularQuery.getRowType().getFieldList().forEach(k -> {
            if (!this.skipSinkColumns && k.getIndex() != -1) {
                sinkBuilder.addTags(GraphAlgebraPhysical.Sink.OptTag.newBuilder().setTag(Utils.asAliasId(k.getIndex())));
            }
        });
        return sinkBuilder.build();
    }

    private String getPlanAsJson(GraphAlgebraPhysical.PhysicalPlan physicalPlan) {
        try {
            return JsonFormat.printer().print((MessageOrBuilder)physicalPlan);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    private IdentityHashMap<RelNode, List<CommonTableScan>> createRelToCommons(LogicalPlan logicalPlan) {
        IdentityHashMap<RelNode, List<CommonTableScan>> relToCommons = new IdentityHashMap<RelNode, List<CommonTableScan>>();
        RelNode top = logicalPlan.getRegularQuery();
        if (top == null) {
            return relToCommons;
        }
        ArrayList rels = Lists.newArrayList((Object[])new RelNode[]{top});
        ArrayList commons = Lists.newArrayList();
        while (!rels.isEmpty()) {
            List<CommonTableScan> inputCommons = this.getInputCommons((RelNode)rels.remove(0));
            commons.addAll(inputCommons);
            inputCommons.forEach(k -> rels.add(((CommonOptTable)k.getTable()).getCommon()));
        }
        LinkedHashMap digestToCommons = Maps.newLinkedHashMap();
        commons.forEach(k -> {
            RelDigest digest = k.getRelDigest();
            digestToCommons.computeIfAbsent(digest, k1 -> Lists.newArrayList()).add(k);
        });
        digestToCommons.forEach((k, v) -> {
            if (v.size() > 1) {
                RelNode ancestor = this.lowestCommonAncestor(top, (List<CommonTableScan>)v, Lists.newArrayList());
                Preconditions.checkArgument((ancestor != null ? 1 : 0) != 0, (String)"lowest common ancestor of [%s] should not be null", (Object)v);
                relToCommons.computeIfAbsent(ancestor, k1 -> Lists.newArrayList()).add((CommonTableScan)((Object)((Object)v.get(0))));
            }
        });
        return relToCommons;
    }

    private HashMap<String, String> createExtraParams(IrMeta irMeta) {
        HashMap<String, String> extraParams = new HashMap<String, String>();
        SnapshotId snapshotId = irMeta.getSnapshotId();
        if (snapshotId.isAcquired()) {
            extraParams.put("SID", String.valueOf(snapshotId.getId()));
        }
        return extraParams;
    }

    private @Nullable RelNode lowestCommonAncestor(RelNode top, List<CommonTableScan> commons, List<CommonTableScan> contains) {
        ArrayList inputContains = Lists.newArrayList();
        for (RelNode input : top.getInputs()) {
            inputContains.add(Lists.newArrayList());
            RelNode inputAncestor = this.lowestCommonAncestor(input, commons, (List)inputContains.get(inputContains.size() - 1));
            if (inputAncestor == null) continue;
            return inputAncestor;
        }
        if (top instanceof CommonTableScan) {
            CommonTableScan common = (CommonTableScan)top;
            inputContains.add(Lists.newArrayList());
            this.lowestCommonAncestor(((CommonOptTable)common.getTable()).getCommon(), commons, (List)inputContains.get(inputContains.size() - 1));
        }
        inputContains.forEach(k -> contains.addAll((Collection<CommonTableScan>)k));
        if (top instanceof CommonTableScan && commons.contains(top)) {
            contains.add((CommonTableScan)top);
        }
        if (contains.size() >= commons.size() && contains.containsAll(commons)) {
            return top;
        }
        return null;
    }

    private List<CommonTableScan> getInputCommons(RelNode top) {
        ArrayList inputCommons = Lists.newArrayList();
        if (top instanceof CommonTableScan) {
            inputCommons.add((CommonTableScan)top);
        } else {
            top.getInputs().forEach(k -> inputCommons.addAll(this.getInputCommons((RelNode)k)));
        }
        return inputCommons;
    }
}

