/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.runtime.proto;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.PegasusConfig;
import com.alibaba.graphscope.common.ir.meta.schema.CommonOptTable;
import com.alibaba.graphscope.common.ir.rel.CommonTableScan;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalAggregate;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalDedupBy;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalProject;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalSort;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalUnfold;
import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.AbstractBindableTableScan;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphGroupKeys;
import com.alibaba.graphscope.common.ir.rel.type.order.GraphFieldCollation;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.runtime.proto.RexToIndexPbConverter;
import com.alibaba.graphscope.common.ir.runtime.proto.RexToProtoConverter;
import com.alibaba.graphscope.common.ir.runtime.proto.Utils;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphNameOrId;
import com.alibaba.graphscope.gaia.proto.GraphAlgebra;
import com.alibaba.graphscope.gaia.proto.GraphAlgebraPhysical;
import com.alibaba.graphscope.gaia.proto.OuterExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphRelToProtoConverter
extends GraphShuttle {
    private final boolean isColumnId;
    private final RexBuilder rexBuilder;
    private final Configs graphConfig;
    private GraphAlgebraPhysical.PhysicalPlan.Builder physicalBuilder;
    private final boolean isPartitioned;
    private boolean preCacheEdgeProps;
    private final IdentityHashMap<RelNode, List<CommonTableScan>> relToCommons;
    private final int depth;
    private final HashMap<String, String> extraParams = new HashMap();

    public GraphRelToProtoConverter(boolean isColumnId, Configs configs, GraphAlgebraPhysical.PhysicalPlan.Builder physicalBuilder, IdentityHashMap<RelNode, List<CommonTableScan>> relToCommons, HashMap<String, String> extraParams) {
        this(isColumnId, configs, physicalBuilder, relToCommons, extraParams, 0);
    }

    public GraphRelToProtoConverter(boolean isColumnId, Configs configs, GraphAlgebraPhysical.PhysicalPlan.Builder physicalBuilder, IdentityHashMap<RelNode, List<CommonTableScan>> relToCommons, HashMap<String, String> extraParams, int depth) {
        this.isColumnId = isColumnId;
        this.rexBuilder = GraphPlanner.rexBuilderFactory.apply(configs);
        this.graphConfig = configs;
        this.physicalBuilder = physicalBuilder;
        this.isPartitioned = PegasusConfig.PEGASUS_HOSTS.get(configs).split(",").length != 1 || PegasusConfig.PEGASUS_WORKER_NUM.get(configs) != 1;
        this.preCacheEdgeProps = true;
        this.relToCommons = relToCommons;
        this.extraParams.putAll(extraParams);
        this.depth = depth;
    }

    @Override
    public RelNode visit(GraphLogicalSource source) {
        GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.Scan.Builder scanBuilder = GraphAlgebraPhysical.Scan.newBuilder();
        RexNode uniqueKeyFilters = source.getUniqueKeyFilters();
        if (uniqueKeyFilters != null) {
            GraphAlgebra.IndexPredicate indexPredicate = this.buildIndexPredicates(uniqueKeyFilters);
            scanBuilder.setIdxPredicate(indexPredicate);
        }
        GraphAlgebra.QueryParams.Builder queryParamsBuilder = this.buildQueryParams(source);
        if (this.preCacheEdgeProps && GraphOpt.Source.EDGE.equals((Object)source.getOpt())) {
            this.addQueryColumns(queryParamsBuilder, Utils.extractColumnsFromRelDataType(source.getRowType(), this.isColumnId));
        }
        scanBuilder.setParams(queryParamsBuilder);
        if (source.getAliasId() != -1) {
            scanBuilder.setAlias(Utils.asAliasId(source.getAliasId()));
        }
        scanBuilder.setScanOpt(Utils.protoScanOpt(source.getOpt()));
        oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setScan(scanBuilder));
        oprBuilder.addAllMetaData(Utils.physicalProtoRowType(source.getRowType(), this.isColumnId));
        this.physicalBuilder.addPlan(oprBuilder.build());
        return source;
    }

    @Override
    public RelNode visit(GraphLogicalExpand expand) {
        this.visitChildren((RelNode)expand);
        GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.EdgeExpand.Builder edgeExpand = this.buildEdgeExpand(expand);
        oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setEdge(edgeExpand));
        oprBuilder.addAllMetaData(Utils.physicalProtoRowType(expand.getRowType(), this.isColumnId));
        if (this.isPartitioned) {
            this.addRepartitionToAnother(expand.getStartAlias().getAliasId());
        }
        this.physicalBuilder.addPlan(oprBuilder.build());
        return expand;
    }

    @Override
    public RelNode visit(GraphLogicalGetV getV) {
        this.visitChildren((RelNode)getV);
        if (ObjectUtils.isEmpty(getV.getFilters())) {
            GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
            GraphAlgebraPhysical.GetV.Builder getVertex = this.buildGetV(getV);
            oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setVertex(getVertex));
            oprBuilder.addAllMetaData(Utils.physicalProtoRowType(getV.getRowType(), this.isColumnId));
            this.physicalBuilder.addPlan(oprBuilder.build());
            return getV;
        }
        GraphAlgebraPhysical.PhysicalOpr.Builder adjOprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.GetV.Builder adjVertexBuilder = GraphAlgebraPhysical.GetV.newBuilder();
        adjVertexBuilder.setOpt(Utils.protoGetVOpt(GraphOpt.PhysicalGetVOpt.valueOf(getV.getOpt().name())));
        GraphAlgebra.QueryParams.Builder adjParamsBuilder = this.defaultQueryParams();
        this.addQueryTables(adjParamsBuilder, com.alibaba.graphscope.common.ir.tools.Utils.getGraphLabels(getV.getRowType()).getLabelsEntry());
        adjVertexBuilder.setParams(adjParamsBuilder);
        if (getV.getStartAlias().getAliasId() != -1) {
            adjVertexBuilder.setTag(Utils.asAliasId(getV.getStartAlias().getAliasId()));
        }
        if (getV.getAliasId() != -1) {
            adjVertexBuilder.setAlias(Utils.asAliasId(getV.getAliasId()));
        }
        adjOprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setVertex(adjVertexBuilder));
        adjOprBuilder.addAllMetaData(Utils.physicalProtoRowType(getV.getRowType(), this.isColumnId));
        this.physicalBuilder.addPlan(adjOprBuilder.build());
        GraphAlgebraPhysical.PhysicalOpr.Builder auxiliaOprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.GetV.Builder auxiliaBuilder = GraphAlgebraPhysical.GetV.newBuilder();
        auxiliaBuilder.setOpt(Utils.protoGetVOpt(GraphOpt.PhysicalGetVOpt.ITSELF));
        GraphAlgebra.QueryParams.Builder auxiliaParamsBuilder = this.defaultQueryParams();
        this.addQueryFilters(auxiliaParamsBuilder, getV.getFilters());
        auxiliaBuilder.setParams(auxiliaParamsBuilder);
        auxiliaOprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setVertex(auxiliaBuilder));
        auxiliaOprBuilder.addAllMetaData(Utils.physicalProtoRowType(getV.getRowType(), this.isColumnId));
        if (this.isPartitioned) {
            this.addRepartitionToAnother(getV.getAliasId());
        }
        this.physicalBuilder.addPlan(auxiliaOprBuilder.build());
        return getV;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RelNode visit(GraphLogicalPathExpand pxd) {
        RelDataType rowType;
        GraphAlgebraPhysical.EdgeExpand.Builder edgeExpandBuilder;
        GraphLogicalGetV originalGetV;
        this.visitChildren((RelNode)pxd);
        GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.PathExpand.Builder pathExpandBuilder = GraphAlgebraPhysical.PathExpand.newBuilder();
        GraphAlgebraPhysical.PathExpand.ExpandBase.Builder expandBaseBuilder = GraphAlgebraPhysical.PathExpand.ExpandBase.newBuilder();
        RelNode fused = pxd.getFused();
        GraphAlgebraPhysical.GetV.Builder getVBuilder = null;
        if (fused != null) {
            if (fused instanceof GraphPhysicalGetV) {
                GraphPhysicalGetV fusedGetV = (GraphPhysicalGetV)fused;
                getVBuilder = this.buildAuxilia(fusedGetV);
                originalGetV = fusedGetV.getFusedGetV();
                if (!(fusedGetV.getInput() instanceof GraphPhysicalExpand)) throw new UnsupportedOperationException("unsupported fused plan in path expand base: " + fusedGetV.getInput().getClass().getName());
                GraphPhysicalExpand fusedExpand = (GraphPhysicalExpand)fusedGetV.getInput();
                edgeExpandBuilder = this.buildEdgeExpand(fusedExpand);
                rowType = fusedExpand.getRowType();
            } else {
                if (!(fused instanceof GraphPhysicalExpand)) throw new UnsupportedOperationException("unsupported fused plan in path expand base");
                GraphPhysicalExpand fusedExpand = (GraphPhysicalExpand)fused;
                edgeExpandBuilder = this.buildEdgeExpand(fusedExpand);
                originalGetV = fusedExpand.getFusedGetV();
                rowType = fusedExpand.getFusedExpand().getRowType();
            }
        } else {
            edgeExpandBuilder = this.buildEdgeExpand((GraphLogicalExpand)pxd.getExpand());
            originalGetV = (GraphLogicalGetV)pxd.getGetV();
            getVBuilder = this.buildGetV(originalGetV);
            rowType = pxd.getExpand().getRowType();
        }
        expandBaseBuilder.setEdgeExpand(edgeExpandBuilder);
        Set<GraphNameOrId> vertexColumns = Utils.extractColumnsFromRelDataType(originalGetV.getRowType(), this.isColumnId);
        if (this.isPartitioned && !vertexColumns.isEmpty() && pxd.getResultOpt() != GraphOpt.PathExpandResult.END_V) {
            GraphAlgebraPhysical.GetV.Builder startAuxiliaBuilder = GraphAlgebraPhysical.GetV.newBuilder();
            startAuxiliaBuilder.setOpt(Utils.protoGetVOpt(GraphOpt.PhysicalGetVOpt.ITSELF));
            GraphAlgebra.QueryParams.Builder startParamsBuilder = this.defaultQueryParams();
            this.addQueryColumns(startParamsBuilder, vertexColumns);
            startAuxiliaBuilder.setParams(startParamsBuilder);
            if (pxd.getStartAlias().getAliasId() != -1) {
                startAuxiliaBuilder.setTag(Utils.asAliasId(pxd.getStartAlias().getAliasId()));
                startAuxiliaBuilder.setAlias(Utils.asAliasId(pxd.getStartAlias().getAliasId()));
            }
            GraphAlgebraPhysical.PhysicalOpr.Builder startAuxiliaOprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
            startAuxiliaOprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setVertex(startAuxiliaBuilder));
            startAuxiliaOprBuilder.addAllMetaData(Utils.physicalProtoRowType(originalGetV.getRowType(), this.isColumnId));
            this.addRepartitionToAnother(pxd.getStartAlias().getAliasId());
            this.physicalBuilder.addPlan(startAuxiliaOprBuilder.build());
            if (getVBuilder == null) {
                getVBuilder = this.buildVertex(originalGetV, GraphOpt.PhysicalGetVOpt.ITSELF);
            }
            GraphAlgebra.QueryParams.Builder paramsBuilder = getVBuilder.getParamsBuilder();
            this.addQueryColumns(paramsBuilder, vertexColumns);
            getVBuilder.setParams(paramsBuilder);
            expandBaseBuilder.setGetV(getVBuilder);
        } else if (getVBuilder != null) {
            expandBaseBuilder.setGetV(getVBuilder);
        }
        pathExpandBuilder.setBase(expandBaseBuilder);
        pathExpandBuilder.setPathOpt(Utils.protoPathOpt(pxd.getPathOpt()));
        pathExpandBuilder.setResultOpt(Utils.protoPathResultOpt(pxd.getResultOpt()));
        GraphAlgebra.Range range = this.buildRange(pxd.getOffset(), pxd.getFetch());
        pathExpandBuilder.setHopRange(range);
        if (pxd.getUntilCondition() != null) {
            OuterExpression.Expression untilCondition = (OuterExpression.Expression)pxd.getUntilCondition().accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
            pathExpandBuilder.setCondition(untilCondition);
        }
        if (pxd.getAliasId() != -1) {
            pathExpandBuilder.setAlias(Utils.asAliasId(pxd.getAliasId()));
        }
        if (pxd.getStartAlias().getAliasId() != -1) {
            pathExpandBuilder.setStartTag(Utils.asAliasId(pxd.getStartAlias().getAliasId()));
        }
        pathExpandBuilder.setIsOptional(pxd.isOptional());
        oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setPath(pathExpandBuilder));
        oprBuilder.addAllMetaData(Utils.physicalProtoRowType(rowType, this.isColumnId));
        if (this.isPartitioned) {
            this.addRepartitionToAnother(pxd.getStartAlias().getAliasId());
        }
        this.physicalBuilder.addPlan(oprBuilder.build());
        return pxd;
    }

    @Override
    public RelNode visit(GraphPhysicalExpand physicalExpand) {
        this.visitChildren((RelNode)physicalExpand);
        GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.EdgeExpand.Builder edgeExpand = this.buildEdgeExpand(physicalExpand);
        oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setEdge(edgeExpand));
        oprBuilder.addAllMetaData(Utils.physicalProtoRowType(physicalExpand.getFusedExpand().getRowType(), this.isColumnId));
        if (this.isPartitioned) {
            this.addRepartitionToAnother(physicalExpand.getStartAlias().getAliasId());
        }
        this.physicalBuilder.addPlan(oprBuilder.build());
        return physicalExpand;
    }

    @Override
    public RelNode visit(GraphPhysicalGetV physicalGetV) {
        this.visitChildren((RelNode)physicalGetV);
        GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.GetV.Builder auxilia = this.buildAuxilia(physicalGetV);
        oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setVertex(auxilia));
        oprBuilder.addAllMetaData(Utils.physicalProtoRowType(physicalGetV.getRowType(), this.isColumnId));
        if (this.isPartitioned) {
            this.addRepartitionToAnother(physicalGetV.getStartAlias().getAliasId());
        }
        this.physicalBuilder.addPlan(oprBuilder.build());
        return physicalGetV;
    }

    public RelNode visit(LogicalFilter filter) {
        this.visitChildren((RelNode)filter);
        RexNode condition = filter.getCondition();
        GraphAlgebraPhysical.PhysicalOpr.Operator.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder();
        if (this.isSubQueryOfExistsKind(condition)) {
            oprBuilder.setApply(this.buildApply((RexSubQuery)condition, GraphAlgebraPhysical.Join.JoinKind.SEMI, -1));
        } else if (this.isSubQueryOfNotExistsKind(condition)) {
            oprBuilder.setApply(this.buildApply((RexSubQuery)((RexCall)condition).getOperands().get(0), GraphAlgebraPhysical.Join.JoinKind.ANTI, -1));
        } else {
            OuterExpression.Expression exprProto = (OuterExpression.Expression)condition.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
            oprBuilder.setSelect(GraphAlgebra.Select.newBuilder().setPredicate(exprProto));
            if (this.isPartitioned) {
                Map<Integer, Set<GraphNameOrId>> tagColumns = Utils.extractTagColumnsFromRexNodes(List.of(filter.getCondition()));
                if (this.preCacheEdgeProps) {
                    Utils.removeEdgeProperties(com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(filter.getInput()), tagColumns);
                }
                this.lazyPropertyFetching(tagColumns, true);
            }
        }
        this.physicalBuilder.addPlan(GraphAlgebraPhysical.PhysicalOpr.newBuilder().setOpr(oprBuilder).addAllMetaData(Utils.physicalProtoRowType(filter.getRowType(), this.isColumnId)));
        return filter;
    }

    private boolean isSubQueryOfExistsKind(RexNode condition) {
        return condition instanceof RexSubQuery && condition.getKind() == SqlKind.EXISTS;
    }

    private boolean isSubQueryOfNotExistsKind(RexNode condition) {
        return condition.getKind() == SqlKind.NOT && this.isSubQueryOfExistsKind((RexNode)((RexCall)condition).getOperands().get(0));
    }

    @Override
    public RelNode visit(GraphLogicalProject project) {
        this.visitChildren((RelNode)project);
        List fields = project.getRowType().getFieldList();
        ArrayList applyColumns = Lists.newArrayList();
        ArrayList exprColumns = Lists.newArrayList();
        for (int i = 0; i < project.getProjects().size(); ++i) {
            RexNode expr = (RexNode)project.getProjects().get(i);
            if (expr instanceof RexSubQuery) {
                applyColumns.add(i);
                continue;
            }
            exprColumns.add(i);
        }
        if (!applyColumns.isEmpty()) {
            for (Integer column : applyColumns) {
                GraphAlgebraPhysical.Apply.Builder applyBuilder = this.buildApply((RexSubQuery)project.getProjects().get(column), GraphAlgebraPhysical.Join.JoinKind.INNER, ((RelDataTypeField)fields.get(column)).getIndex());
                this.physicalBuilder.addPlan(GraphAlgebraPhysical.PhysicalOpr.newBuilder().setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setApply(applyBuilder)).build());
            }
        }
        if (!exprColumns.isEmpty()) {
            GraphAlgebraPhysical.Project.Builder projectBuilder = GraphAlgebraPhysical.Project.newBuilder().setIsAppend(project.isAppend());
            ArrayList newExprs = Lists.newArrayList();
            ArrayList newFields = Lists.newArrayList();
            for (Integer column : exprColumns) {
                int aliasId = ((RelDataTypeField)fields.get(column)).getIndex();
                OuterExpression.Expression expression = (OuterExpression.Expression)((RexNode)project.getProjects().get(column)).accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
                GraphAlgebraPhysical.Project.ExprAlias.Builder projectExprAliasBuilder = GraphAlgebraPhysical.Project.ExprAlias.newBuilder();
                projectExprAliasBuilder.setExpr(expression);
                if (aliasId != -1) {
                    projectExprAliasBuilder.setAlias(Utils.asAliasId(aliasId));
                }
                projectBuilder.addMappings(projectExprAliasBuilder);
                newExprs.add((RexNode)project.getProjects().get(column));
                newFields.add((RelDataTypeField)fields.get(column));
            }
            if (this.isPartitioned) {
                Map<Integer, Set<GraphNameOrId>> tagColumns = Utils.extractTagColumnsFromRexNodes(newExprs);
                if (this.preCacheEdgeProps) {
                    Utils.removeEdgeProperties(com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(project.getInput()), tagColumns);
                }
                this.lazyPropertyFetching(tagColumns, true);
            }
            RelRecordType newType = new RelRecordType(StructKind.FULLY_QUALIFIED, (List)newFields);
            this.physicalBuilder.addPlan(GraphAlgebraPhysical.PhysicalOpr.newBuilder().setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setProject(projectBuilder).build()).addAllMetaData(Utils.physicalProtoRowType((RelDataType)newType, this.isColumnId)).build());
        }
        return project;
    }

    private GraphAlgebraPhysical.Apply.Builder buildApply(RexSubQuery query, GraphAlgebraPhysical.Join.JoinKind joinKind, int aliasId) {
        GraphAlgebraPhysical.PhysicalPlan.Builder applyPlanBuilder = GraphAlgebraPhysical.PhysicalPlan.newBuilder();
        query.rel.accept((RelShuttle)new GraphRelToProtoConverter(this.isColumnId, this.graphConfig, applyPlanBuilder, this.relToCommons, this.extraParams, this.depth + 1));
        GraphAlgebraPhysical.Apply.Builder applyBuilder = GraphAlgebraPhysical.Apply.newBuilder().setSubPlan(applyPlanBuilder).setJoinKind(joinKind);
        if (aliasId != -1) {
            applyBuilder.setAlias(Utils.asAliasId(aliasId));
        }
        return applyBuilder;
    }

    @Override
    public RelNode visit(GraphLogicalAggregate aggregate) {
        this.visitChildren((RelNode)aggregate);
        List fields = aggregate.getRowType().getFieldList();
        List<GraphAggCall> groupCalls = aggregate.getAggCalls();
        GraphGroupKeys keys = aggregate.getGroupKey();
        if (groupCalls.isEmpty()) {
            Preconditions.checkArgument((keys.groupKeyCount() > 0 ? 1 : 0) != 0, (Object)"group keys should not be empty while group calls is empty");
            GraphAlgebraPhysical.Project.Builder projectBuilder = GraphAlgebraPhysical.Project.newBuilder();
            for (int i = 0; i < keys.groupKeyCount(); ++i) {
                int aliasId;
                RexNode var = keys.getVariables().get(i);
                Preconditions.checkArgument((boolean)(var instanceof RexGraphVariable), (String)"each group key should be type %s, but is %s", RexGraphVariable.class, var.getClass());
                OuterExpression.Expression expr = (OuterExpression.Expression)var.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
                if (i >= fields.size() || (aliasId = ((RelDataTypeField)fields.get(i)).getIndex()) == -1) {
                    throw new IllegalArgumentException("each group key should have an alias if need dedup");
                }
                GraphAlgebraPhysical.Project.ExprAlias.Builder projectExprAliasBuilder = GraphAlgebraPhysical.Project.ExprAlias.newBuilder();
                projectExprAliasBuilder.setExpr(expr);
                if (aliasId != -1) {
                    projectExprAliasBuilder.setAlias(Utils.asAliasId(aliasId));
                }
                projectBuilder.addMappings(projectExprAliasBuilder.build());
            }
            GraphAlgebra.Dedup.Builder dedupBuilder = GraphAlgebra.Dedup.newBuilder();
            for (int i = 0; i < keys.groupKeyCount(); ++i) {
                RelDataTypeField field = (RelDataTypeField)fields.get(i);
                RexGraphVariable rexVar = RexGraphVariable.of(field.getIndex(), 100, field.getName(), field.getType());
                OuterExpression.Variable exprVar = ((OuterExpression.Expression)rexVar.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
                dedupBuilder.addKeys(exprVar);
            }
            GraphAlgebraPhysical.PhysicalOpr.Builder projectOprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
            projectOprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setProject(projectBuilder));
            GraphAlgebraPhysical.PhysicalOpr.Builder dedupOprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
            dedupOprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setDedup(dedupBuilder));
            if (this.isPartitioned) {
                Map<Integer, Set<GraphNameOrId>> tagColumns = Utils.extractTagColumnsFromRexNodes(keys.getVariables());
                if (this.preCacheEdgeProps) {
                    Utils.removeEdgeProperties(com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(aggregate.getInput()), tagColumns);
                }
                this.lazyPropertyFetching(tagColumns);
            }
            this.physicalBuilder.addPlan(projectOprBuilder.build());
            this.physicalBuilder.addPlan(dedupOprBuilder.build());
        } else {
            int i;
            GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
            GraphAlgebraPhysical.GroupBy.Builder groupByBuilder = GraphAlgebraPhysical.GroupBy.newBuilder();
            for (i = 0; i < keys.groupKeyCount(); ++i) {
                RexNode var = keys.getVariables().get(i);
                Preconditions.checkArgument((boolean)(var instanceof RexGraphVariable), (String)"each group key should be type %s, but is %s", RexGraphVariable.class, var.getClass());
                OuterExpression.Variable exprVar = ((OuterExpression.Expression)var.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
                int aliasId = ((RelDataTypeField)fields.get(i)).getIndex();
                GraphAlgebraPhysical.GroupBy.KeyAlias.Builder keyAliasBuilder = GraphAlgebraPhysical.GroupBy.KeyAlias.newBuilder();
                keyAliasBuilder.setKey(exprVar);
                if (aliasId != -1) {
                    keyAliasBuilder.setAlias(Utils.asAliasId(aliasId));
                }
                groupByBuilder.addMappings(keyAliasBuilder);
            }
            for (i = 0; i < groupCalls.size(); ++i) {
                List<RexNode> operands = groupCalls.get(i).getOperands();
                if (operands.isEmpty()) {
                    throw new IllegalArgumentException("operands in aggregate call should not be empty");
                }
                GraphAlgebraPhysical.GroupBy.AggFunc.Builder aggFnAliasBuilder = GraphAlgebraPhysical.GroupBy.AggFunc.newBuilder();
                for (RexNode operand : operands) {
                    Preconditions.checkArgument((boolean)(operand instanceof RexGraphVariable), (String)"each expression in aggregate call should be type %s, but is %s", RexGraphVariable.class, operand.getClass());
                    OuterExpression.Variable var = ((OuterExpression.Expression)operand.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
                    aggFnAliasBuilder.addVars(var);
                }
                GraphAlgebraPhysical.GroupBy.AggFunc.Aggregate aggOpt = Utils.protoAggOpt(groupCalls.get(i));
                aggFnAliasBuilder.setAggregate(aggOpt);
                int aliasId = ((RelDataTypeField)fields.get(i + keys.groupKeyCount())).getIndex();
                if (aliasId != -1) {
                    aggFnAliasBuilder.setAlias(Utils.asAliasId(aliasId));
                }
                groupByBuilder.addFunctions(aggFnAliasBuilder);
            }
            oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setGroupBy(groupByBuilder));
            oprBuilder.addAllMetaData(Utils.physicalProtoRowType(aggregate.getRowType(), this.isColumnId));
            if (this.isPartitioned) {
                ArrayList keysAndAggs = Lists.newArrayList();
                keysAndAggs.addAll(keys.getVariables());
                keysAndAggs.addAll(groupCalls.stream().flatMap(k -> k.getOperands().stream()).collect(Collectors.toList()));
                Map<Integer, Set<GraphNameOrId>> tagColumns = Utils.extractTagColumnsFromRexNodes(keysAndAggs);
                if (this.preCacheEdgeProps) {
                    Utils.removeEdgeProperties(com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(aggregate.getInput()), tagColumns);
                }
                this.lazyPropertyFetching(tagColumns);
            }
            this.physicalBuilder.addPlan(oprBuilder.build());
        }
        return aggregate;
    }

    @Override
    public RelNode visit(GraphLogicalDedupBy dedupBy) {
        this.visitChildren((RelNode)dedupBy);
        GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebra.Dedup.Builder dedupBuilder = GraphAlgebra.Dedup.newBuilder();
        for (RexNode expr : dedupBy.getDedupByKeys()) {
            Preconditions.checkArgument((boolean)(expr instanceof RexGraphVariable), (String)"each expression in dedup by should be type %s, but is %s", RexGraphVariable.class, expr.getClass());
            OuterExpression.Variable var = ((OuterExpression.Expression)expr.accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
            dedupBuilder.addKeys(var);
        }
        oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setDedup(dedupBuilder));
        oprBuilder.addAllMetaData(Utils.physicalProtoRowType(dedupBy.getRowType(), this.isColumnId));
        if (this.isPartitioned) {
            Map<Integer, Set<GraphNameOrId>> tagColumns = Utils.extractTagColumnsFromRexNodes(dedupBy.getDedupByKeys());
            if (this.preCacheEdgeProps) {
                Utils.removeEdgeProperties(com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(dedupBy.getInput()), tagColumns);
            }
            this.lazyPropertyFetching(tagColumns);
        }
        this.physicalBuilder.addPlan(oprBuilder.build());
        return dedupBy;
    }

    @Override
    public RelNode visit(GraphLogicalSort sort) {
        this.visitChildren((RelNode)sort);
        GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        List collations = sort.getCollation().getFieldCollations();
        if (!collations.isEmpty()) {
            GraphAlgebra.OrderBy.Builder orderByBuilder = GraphAlgebra.OrderBy.newBuilder();
            for (int i = 0; i < collations.size(); ++i) {
                GraphAlgebra.OrderBy.OrderingPair.Builder orderingPairBuilder = GraphAlgebra.OrderBy.OrderingPair.newBuilder();
                RexGraphVariable expr = ((GraphFieldCollation)((Object)collations.get(i))).getVariable();
                OuterExpression.Variable var = ((OuterExpression.Expression)expr.accept(new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
                orderingPairBuilder.setKey(var);
                orderingPairBuilder.setOrder(Utils.protoOrderOpt(((RelFieldCollation)collations.get(i)).getDirection()));
                orderByBuilder.addPairs(orderingPairBuilder.build());
            }
            if (sort.offset != null || sort.fetch != null) {
                orderByBuilder.setLimit(this.buildRange(sort.offset, sort.fetch));
            }
            oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setOrderBy(orderByBuilder));
            if (this.isPartitioned) {
                Map<Integer, Set<GraphNameOrId>> tagColumns = Utils.extractTagColumnsFromRexNodes(collations.stream().map(k -> ((GraphFieldCollation)((Object)k)).getVariable()).collect(Collectors.toList()));
                if (this.preCacheEdgeProps) {
                    Utils.removeEdgeProperties(com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(sort.getInput()), tagColumns);
                }
                this.lazyPropertyFetching(tagColumns);
            }
        } else {
            GraphAlgebra.Limit.Builder limitBuilder = GraphAlgebra.Limit.newBuilder();
            limitBuilder.setRange(this.buildRange(sort.offset, sort.fetch));
            oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setLimit(limitBuilder));
        }
        this.physicalBuilder.addPlan(oprBuilder.build());
        return sort;
    }

    @Override
    public RelNode visit(LogicalJoin join) {
        GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.Join.Builder joinBuilder = GraphAlgebraPhysical.Join.newBuilder();
        joinBuilder.setJoinKind(Utils.protoJoinKind(join.getJoinType()));
        List conditions = RelOptUtil.conjunctions((RexNode)join.getCondition());
        Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0, (Object)"join condition in physical should not be empty");
        ArrayList leftKeys = Lists.newArrayList();
        ArrayList rightKeys = Lists.newArrayList();
        for (RexNode condition : conditions) {
            List<RexGraphVariable> leftRightVars = this.getLeftRightVariables(condition);
            Preconditions.checkArgument((leftRightVars.size() == 2 ? 1 : 0) != 0, (String)"join condition in physical should have two operands, while it is %s", (int)leftRightVars.size());
            leftKeys.add((RexNode)leftRightVars.get(0));
            rightKeys.add((RexNode)leftRightVars.get(1));
            OuterExpression.Variable leftVar = ((OuterExpression.Expression)leftRightVars.get(0).accept(new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
            OuterExpression.Variable rightVar = ((OuterExpression.Expression)leftRightVars.get(1).accept(new RexToProtoConverter(true, this.isColumnId, this.rexBuilder))).getOperators(0).getVar();
            joinBuilder.addLeftKeys(leftVar);
            joinBuilder.addRightKeys(rightVar);
        }
        GraphAlgebraPhysical.PhysicalPlan.Builder leftPlanBuilder = GraphAlgebraPhysical.PhysicalPlan.newBuilder();
        GraphAlgebraPhysical.PhysicalPlan.Builder rightPlanBuilder = GraphAlgebraPhysical.PhysicalPlan.newBuilder();
        RelNode left = join.getLeft();
        left.accept((RelShuttle)new GraphRelToProtoConverter(this.isColumnId, this.graphConfig, leftPlanBuilder, this.relToCommons, this.extraParams, this.depth + 1));
        RelNode right = join.getRight();
        right.accept((RelShuttle)new GraphRelToProtoConverter(this.isColumnId, this.graphConfig, rightPlanBuilder, this.relToCommons, this.extraParams, this.depth + 1));
        if (this.isPartitioned) {
            Map<Integer, Set<GraphNameOrId>> leftTagColumns = Utils.extractTagColumnsFromRexNodes(leftKeys);
            Map<Integer, Set<GraphNameOrId>> rightTagColumns = Utils.extractTagColumnsFromRexNodes(rightKeys);
            if (this.preCacheEdgeProps) {
                Utils.removeEdgeProperties(com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(join.getLeft()), leftTagColumns);
                Utils.removeEdgeProperties(com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(join.getRight()), rightTagColumns);
            }
            this.lazyPropertyFetching(leftPlanBuilder, leftTagColumns, false);
            this.lazyPropertyFetching(rightPlanBuilder, rightTagColumns, false);
        }
        joinBuilder.setLeftPlan(leftPlanBuilder);
        joinBuilder.setRightPlan(rightPlanBuilder);
        oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setJoin(joinBuilder));
        this.physicalBuilder.addPlan(oprBuilder.build());
        return join;
    }

    public RelNode visit(LogicalUnion union) {
        List<CommonTableScan> commons = this.relToCommons.get(union);
        if (ObjectUtils.isNotEmpty(commons)) {
            GraphAlgebraPhysical.PhysicalPlan.Builder commonPlanBuilder = GraphAlgebraPhysical.PhysicalPlan.newBuilder();
            for (int i = commons.size() - 1; i >= 0; --i) {
                RelNode commonRel = ((CommonOptTable)commons.get(i).getTable()).getCommon();
                commonRel.accept((RelShuttle)new GraphRelToProtoConverter(this.isColumnId, this.graphConfig, commonPlanBuilder, this.relToCommons, this.extraParams, this.depth + 1));
            }
            this.physicalBuilder.addAllPlan(commonPlanBuilder.getPlanList());
        } else if (this.depth == 0) {
            this.physicalBuilder.addPlan(GraphAlgebraPhysical.PhysicalOpr.newBuilder().setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setRoot(GraphAlgebraPhysical.Root.newBuilder())));
        }
        GraphAlgebraPhysical.PhysicalOpr.Builder oprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.Union.Builder unionBuilder = GraphAlgebraPhysical.Union.newBuilder();
        for (RelNode input : union.getInputs()) {
            GraphAlgebraPhysical.PhysicalPlan.Builder inputPlanBuilder = GraphAlgebraPhysical.PhysicalPlan.newBuilder();
            input.accept((RelShuttle)new GraphRelToProtoConverter(this.isColumnId, this.graphConfig, inputPlanBuilder, this.relToCommons, this.extraParams, this.depth + 1));
            unionBuilder.addSubPlans(inputPlanBuilder);
        }
        oprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setUnion(unionBuilder));
        this.physicalBuilder.addPlan(oprBuilder.build());
        return union;
    }

    @Override
    public RelNode visit(MultiJoin multiJoin) {
        List<CommonTableScan> commons = this.relToCommons.get(multiJoin);
        if (ObjectUtils.isNotEmpty(commons)) {
            GraphAlgebraPhysical.PhysicalPlan.Builder commonPlanBuilder = GraphAlgebraPhysical.PhysicalPlan.newBuilder();
            for (int i = commons.size() - 1; i >= 0; --i) {
                RelNode commonRel = ((CommonOptTable)commons.get(i).getTable()).getCommon();
                commonRel.accept((RelShuttle)new GraphRelToProtoConverter(this.isColumnId, this.graphConfig, commonPlanBuilder, this.relToCommons, this.extraParams, this.depth + 1));
            }
            this.physicalBuilder.addAllPlan(commonPlanBuilder.getPlanList());
        }
        GraphAlgebraPhysical.PhysicalOpr.Builder intersectOprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.Intersect.Builder intersectBuilder = GraphAlgebraPhysical.Intersect.newBuilder();
        List conditions = RelOptUtil.conjunctions((RexNode)multiJoin.getJoinFilter());
        int intersectKey = -1;
        for (RexNode condition : conditions) {
            List<RexGraphVariable> leftRightVars = this.getLeftRightVariables(condition);
            Preconditions.checkArgument((leftRightVars.size() == 2 ? 1 : 0) != 0, (Object)"the condition of multi-join should be equal condition");
            if (intersectKey == -1) {
                intersectKey = leftRightVars.get(0).getAliasId();
                continue;
            }
            Preconditions.checkArgument((intersectKey == leftRightVars.get(0).getAliasId() ? 1 : 0) != 0, (Object)("the intersect key should be the same in multi-join: " + intersectKey + " " + leftRightVars.get(0).getAliasId()));
        }
        Preconditions.checkArgument((intersectKey != -1 ? 1 : 0) != 0, (Object)"intersect key should be set");
        intersectBuilder.setKey(intersectKey);
        for (RelNode input : multiJoin.getInputs()) {
            GraphAlgebraPhysical.PhysicalPlan.Builder subPlanBuilder = GraphAlgebraPhysical.PhysicalPlan.newBuilder();
            input.accept((RelShuttle)new GraphRelToProtoConverter(this.isColumnId, this.graphConfig, subPlanBuilder, this.relToCommons, this.extraParams, this.depth + 1));
            intersectBuilder.addSubPlans(subPlanBuilder);
        }
        intersectOprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setIntersect(intersectBuilder));
        this.physicalBuilder.addPlan(intersectOprBuilder.build());
        return multiJoin;
    }

    @Override
    public RelNode visit(GraphLogicalUnfold unfold) {
        List fullFields;
        this.visitChildren((RelNode)unfold);
        RexNode unfoldKey = unfold.getUnfoldKey();
        Preconditions.checkArgument((boolean)(unfoldKey instanceof RexGraphVariable), (String)"unfold key should be a variable, but is [%s]", (Object)unfoldKey);
        int keyAliasId = ((RexGraphVariable)unfoldKey).getAliasId();
        GraphAlgebraPhysical.Unfold.Builder unfoldBuilder = GraphAlgebraPhysical.Unfold.newBuilder().setTag(Utils.asAliasId(keyAliasId));
        if (unfold.getAliasId() != -1) {
            unfoldBuilder.setAlias(Utils.asAliasId(unfold.getAliasId()));
        }
        Preconditions.checkArgument((!(fullFields = unfold.getRowType().getFieldList()).isEmpty() ? 1 : 0) != 0, (Object)"there is no fields in unfold row type");
        RelRecordType curRowType = new RelRecordType(StructKind.FULLY_QUALIFIED, fullFields.subList(fullFields.size() - 1, fullFields.size()));
        this.physicalBuilder.addPlan(GraphAlgebraPhysical.PhysicalOpr.newBuilder().setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setUnfold(unfoldBuilder).build()).addAllMetaData(Utils.physicalProtoRowType((RelDataType)curRowType, this.isColumnId)).build());
        return unfold;
    }

    private List<RexGraphVariable> getLeftRightVariables(RexNode condition) {
        RexCall call;
        ArrayList vars = Lists.newArrayList();
        if (condition instanceof RexCall && (call = (RexCall)condition).getOperator().getKind() == SqlKind.EQUALS) {
            RexNode left = (RexNode)call.getOperands().get(0);
            RexNode right = (RexNode)call.getOperands().get(1);
            if (left instanceof RexGraphVariable && right instanceof RexGraphVariable) {
                vars.add((RexGraphVariable)left);
                vars.add((RexGraphVariable)right);
            }
        }
        return vars;
    }

    private GraphAlgebraPhysical.EdgeExpand.Builder buildEdgeExpand(GraphLogicalExpand expand, GraphOpt.PhysicalExpandOpt opt, int aliasId) {
        GraphAlgebraPhysical.EdgeExpand.Builder expandBuilder = GraphAlgebraPhysical.EdgeExpand.newBuilder();
        expandBuilder.setDirection(Utils.protoExpandDirOpt(expand.getOpt()));
        GraphAlgebra.QueryParams.Builder queryParamsBuilder = this.buildQueryParams(expand);
        if (this.preCacheEdgeProps && GraphOpt.PhysicalExpandOpt.EDGE.equals((Object)opt)) {
            this.addQueryColumns(queryParamsBuilder, Utils.extractColumnsFromRelDataType(expand.getRowType(), this.isColumnId));
        }
        expandBuilder.setParams(queryParamsBuilder);
        if (aliasId != -1) {
            expandBuilder.setAlias(Utils.asAliasId(aliasId));
        }
        if (expand.getStartAlias().getAliasId() != -1) {
            expandBuilder.setVTag(Utils.asAliasId(expand.getStartAlias().getAliasId()));
        }
        expandBuilder.setExpandOpt(Utils.protoExpandOpt(opt));
        expandBuilder.setIsOptional(expand.isOptional());
        return expandBuilder;
    }

    private GraphAlgebraPhysical.EdgeExpand.Builder buildEdgeExpand(GraphLogicalExpand expand) {
        return this.buildEdgeExpand(expand, GraphOpt.PhysicalExpandOpt.EDGE, expand.getAliasId());
    }

    private GraphAlgebraPhysical.EdgeExpand.Builder buildEdgeExpand(GraphPhysicalExpand physicalExpand) {
        return this.buildEdgeExpand(physicalExpand.getFusedExpand(), physicalExpand.getPhysicalOpt(), physicalExpand.getAliasId());
    }

    private GraphAlgebraPhysical.GetV.Builder buildVertex(GraphLogicalGetV getV, GraphOpt.PhysicalGetVOpt opt) {
        GraphAlgebraPhysical.GetV.Builder vertexBuilder = GraphAlgebraPhysical.GetV.newBuilder();
        vertexBuilder.setOpt(Utils.protoGetVOpt(opt));
        vertexBuilder.setParams(this.buildQueryParams(getV));
        if (getV.getAliasId() != -1) {
            vertexBuilder.setAlias(Utils.asAliasId(getV.getAliasId()));
        }
        if (getV.getStartAlias().getAliasId() != -1) {
            vertexBuilder.setTag(Utils.asAliasId(getV.getStartAlias().getAliasId()));
        }
        return vertexBuilder;
    }

    private GraphAlgebraPhysical.GetV.Builder buildGetV(GraphLogicalGetV getV) {
        return this.buildVertex(getV, GraphOpt.PhysicalGetVOpt.valueOf(getV.getOpt().name()));
    }

    private GraphAlgebraPhysical.GetV.Builder buildAuxilia(GraphPhysicalGetV getV) {
        return this.buildVertex(getV.getFusedGetV(), GraphOpt.PhysicalGetVOpt.ITSELF);
    }

    private GraphAlgebra.Range buildRange(RexNode offset, RexNode fetch) {
        if (offset != null && !(offset instanceof RexLiteral) || fetch != null && !(fetch instanceof RexLiteral)) {
            throw new IllegalArgumentException("can not get INTEGER hops from types instead of RexLiteral");
        }
        GraphAlgebra.Range.Builder rangeBuilder = GraphAlgebra.Range.newBuilder();
        int lower = offset == null ? 0 : ((Number)((Object)((RexLiteral)offset).getValue())).intValue();
        rangeBuilder.setLower(lower);
        rangeBuilder.setUpper(fetch == null ? Integer.MAX_VALUE : lower + ((Number)((Object)((RexLiteral)fetch).getValue())).intValue());
        return rangeBuilder.build();
    }

    private GraphAlgebra.IndexPredicate buildIndexPredicates(RexNode uniqueKeyFilters) {
        GraphAlgebra.IndexPredicate indexPredicate = (GraphAlgebra.IndexPredicate)uniqueKeyFilters.accept((RexVisitor)new RexToIndexPbConverter(true, this.isColumnId, this.rexBuilder));
        return indexPredicate;
    }

    private GraphAlgebra.QueryParams.Builder defaultQueryParams() {
        GraphAlgebra.QueryParams.Builder paramsBuilder = GraphAlgebra.QueryParams.newBuilder();
        paramsBuilder.setSampleRatio(1.0);
        if (!this.extraParams.isEmpty()) {
            paramsBuilder.putAllExtra(this.extraParams);
        }
        return paramsBuilder;
    }

    private void addQueryTables(GraphAlgebra.QueryParams.Builder paramsBuilder, List<GraphLabelType.Entry> labels) {
        Set<Integer> uniqueLabelIds = labels.stream().map(k -> k.getLabelId()).collect(Collectors.toSet());
        uniqueLabelIds.forEach(k -> paramsBuilder.addTables(Utils.asNameOrId(k)));
    }

    private void addQueryFilters(GraphAlgebra.QueryParams.Builder paramsBuilder, @Nullable ImmutableList<RexNode> filters) {
        if (ObjectUtils.isNotEmpty(filters)) {
            OuterExpression.Expression expression = (OuterExpression.Expression)((RexNode)filters.get(0)).accept((RexVisitor)new RexToProtoConverter(true, this.isColumnId, this.rexBuilder));
            paramsBuilder.setPredicate(expression);
        }
    }

    private void addQueryColumns(GraphAlgebra.QueryParams.Builder paramsBuilder, Set<GraphNameOrId> columns) {
        for (GraphNameOrId column : columns) {
            paramsBuilder.addColumns(Utils.protoNameOrId(column));
        }
    }

    private GraphAlgebra.QueryParams.Builder buildQueryParams(AbstractBindableTableScan tableScan) {
        GraphAlgebra.QueryParams.Builder paramsBuilder = this.defaultQueryParams();
        this.addQueryTables(paramsBuilder, com.alibaba.graphscope.common.ir.tools.Utils.getGraphLabels(tableScan.getRowType()).getLabelsEntry());
        this.addQueryFilters(paramsBuilder, tableScan.getFilters());
        return paramsBuilder;
    }

    private void addRepartitionToAnother(int repartitionKey) {
        this.addRepartitionToAnother(this.physicalBuilder, repartitionKey);
    }

    private void addRepartitionToAnother(GraphAlgebraPhysical.PhysicalPlan.Builder physicalBuilder, int repartitionKey) {
        GraphAlgebraPhysical.PhysicalOpr.Builder repartitionOprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.Repartition repartition = Utils.protoShuffleRepartition(repartitionKey);
        repartitionOprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setRepartition(repartition));
        physicalBuilder.addPlan(repartitionOprBuilder.build());
    }

    private void addAuxilia(GraphAlgebraPhysical.PhysicalPlan.Builder physicalBuilder, Integer tag, Set<GraphNameOrId> columns) {
        GraphAlgebraPhysical.PhysicalOpr.Builder auxiliaOprBuilder = GraphAlgebraPhysical.PhysicalOpr.newBuilder();
        GraphAlgebraPhysical.GetV.Builder vertexBuilder = GraphAlgebraPhysical.GetV.newBuilder();
        vertexBuilder.setOpt(Utils.protoGetVOpt(GraphOpt.PhysicalGetVOpt.ITSELF));
        GraphAlgebra.QueryParams.Builder paramsBuilder = this.defaultQueryParams();
        this.addQueryColumns(paramsBuilder, columns);
        vertexBuilder.setParams(paramsBuilder);
        if (tag != -1) {
            vertexBuilder.setTag(Utils.asAliasId(tag));
            vertexBuilder.setAlias(Utils.asAliasId(tag));
        }
        auxiliaOprBuilder.setOpr(GraphAlgebraPhysical.PhysicalOpr.Operator.newBuilder().setVertex(vertexBuilder));
        physicalBuilder.addPlan(auxiliaOprBuilder.build());
    }

    private void lazyPropertyFetching(Map<Integer, Set<GraphNameOrId>> columns) {
        this.lazyPropertyFetching(columns, false);
    }

    private void lazyPropertyFetching(Map<Integer, Set<GraphNameOrId>> tagColumns, boolean optimizedNoCaching) {
        this.lazyPropertyFetching(this.physicalBuilder, tagColumns, optimizedNoCaching);
    }

    private void lazyPropertyFetching(GraphAlgebraPhysical.PhysicalPlan.Builder physicalBuilder, Map<Integer, Set<GraphNameOrId>> tagColumns, boolean optimizedNoCaching) {
        if (tagColumns.isEmpty()) {
            return;
        }
        if (tagColumns.size() == 1 && optimizedNoCaching) {
            this.addRepartitionToAnother(physicalBuilder, tagColumns.keySet().iterator().next());
        } else {
            for (Map.Entry<Integer, Set<GraphNameOrId>> tagColumn : tagColumns.entrySet()) {
                this.addRepartitionToAnother(physicalBuilder, tagColumn.getKey());
                this.addAuxilia(physicalBuilder, tagColumn.getKey(), tagColumn.getValue());
            }
        }
    }

    @Override
    public RelNode visit(GraphLogicalSingleMatch match) {
        throw new UnsupportedOperationException("converting logical match to physical plan is unsupported yet");
    }

    @Override
    public RelNode visit(GraphLogicalMultiMatch match) {
        throw new UnsupportedOperationException("converting logical match to physical plan is unsupported yet");
    }
}

