/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.runtime.proto;

import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.runtime.proto.RexToProtoConverter;
import com.alibaba.graphscope.common.ir.runtime.proto.Utils;
import com.alibaba.graphscope.gaia.proto.GraphAlgebra;
import com.alibaba.graphscope.gaia.proto.OuterExpression;
import com.google.common.base.Preconditions;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;

public class RexToIndexPbConverter
extends RexVisitorImpl<GraphAlgebra.IndexPredicate> {
    private final boolean isColumnId;
    private final RexBuilder rexBuilder;

    public RexToIndexPbConverter(boolean deep, boolean isColumnId, RexBuilder rexBuilder) {
        super(deep);
        this.isColumnId = isColumnId;
        this.rexBuilder = rexBuilder;
    }

    public GraphAlgebra.IndexPredicate visitCall(RexCall call) {
        GraphAlgebra.IndexPredicate.Builder indexBuilder = GraphAlgebra.IndexPredicate.newBuilder();
        for (RexNode disjunction : RelOptUtil.disjunctions((RexNode)call)) {
            if (disjunction instanceof RexCall) {
                indexBuilder.addOrPredicates(GraphAlgebra.IndexPredicate.AndPredicate.newBuilder().addPredicates(this.protoTriplet((RexCall)disjunction)).build());
                continue;
            }
            throw new IllegalArgumentException("invalid unique key filter pattern=" + disjunction);
        }
        return indexBuilder.build();
    }

    private GraphAlgebra.IndexPredicate.Triplet protoTriplet(RexCall rexCall) {
        SqlOperator operator = rexCall.getOperator();
        switch (operator.getKind()) {
            case EQUALS: 
            case SEARCH: {
                RexNode left = (RexNode)rexCall.getOperands().get(0);
                RexNode right = (RexNode)rexCall.getOperands().get(1);
                if (left instanceof RexGraphVariable && (right instanceof RexLiteral || right instanceof RexDynamicParam)) {
                    GraphAlgebra.IndexPredicate.Triplet.Builder tripletBuilder = GraphAlgebra.IndexPredicate.Triplet.newBuilder().setKey(this.protoProperty((RexGraphVariable)left)).setCmp(operator.getKind() == SqlKind.EQUALS ? OuterExpression.Logical.EQ : OuterExpression.Logical.WITHIN);
                    OuterExpression.Expression value = (OuterExpression.Expression)right.accept((RexVisitor)new RexToProtoConverter(this.deep, this.isColumnId, this.rexBuilder));
                    if (right instanceof RexLiteral) {
                        tripletBuilder.setConst(value.getOperators(0).getConst());
                    } else {
                        tripletBuilder.setParam(value.getOperators(0).getParam());
                    }
                    return tripletBuilder.build();
                }
                if (!(right instanceof RexGraphVariable) || !(left instanceof RexLiteral) && !(left instanceof RexDynamicParam)) break;
                GraphAlgebra.IndexPredicate.Triplet.Builder tripletBuilder = GraphAlgebra.IndexPredicate.Triplet.newBuilder().setKey(this.protoProperty((RexGraphVariable)right)).setCmp(operator.getKind() == SqlKind.EQUALS ? OuterExpression.Logical.EQ : OuterExpression.Logical.WITHIN);
                OuterExpression.Expression value = (OuterExpression.Expression)left.accept((RexVisitor)new RexToProtoConverter(this.deep, this.isColumnId, this.rexBuilder));
                if (left instanceof RexLiteral) {
                    tripletBuilder.setConst(value.getOperators(0).getConst());
                } else {
                    tripletBuilder.setParam(value.getOperators(0).getParam());
                }
                return tripletBuilder.build();
            }
        }
        throw new IllegalArgumentException("can not convert unique key filter pattern=" + rexCall + " to ir core index predicate");
    }

    private OuterExpression.Property protoProperty(RexGraphVariable variable) {
        Preconditions.checkArgument((variable.getProperty() != null ? 1 : 0) != 0, (Object)"cannot convert null property to index predicate");
        return Utils.protoProperty(variable.getProperty());
    }
}

