/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.runtime.proto;

import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.runtime.proto.Utils;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.DataType;
import com.alibaba.graphscope.gaia.proto.OuterExpression;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.util.Sarg;

public class RexToProtoConverter
extends RexVisitorImpl<OuterExpression.Expression> {
    private final boolean isColumnId;
    private final RexBuilder rexBuilder;

    public RexToProtoConverter(boolean deep, boolean isColumnId, RexBuilder rexBuilder) {
        super(deep);
        this.isColumnId = isColumnId;
        this.rexBuilder = rexBuilder;
    }

    public OuterExpression.Expression visitCall(RexCall call) {
        if (!this.deep) {
            return null;
        }
        SqlOperator operator = call.getOperator();
        if (operator.getKind() == SqlKind.CASE) {
            return this.visitCase(call);
        }
        if (operator.getKind() == SqlKind.ARRAY_VALUE_CONSTRUCTOR) {
            return this.visitArrayValueConstructor(call);
        }
        if (operator.getKind() == SqlKind.MAP_VALUE_CONSTRUCTOR) {
            return this.visitMapValueConstructor(call);
        }
        if (operator.getKind() == SqlKind.OTHER && operator.getName().equals("PATH_CONCAT")) {
            return this.visitPathConcat(call);
        }
        if (operator.getKind() == SqlKind.OTHER && operator.getName().equals("PATH_FUNCTION")) {
            return this.visitPathFunction(call);
        }
        if (operator.getKind() == SqlKind.EXTRACT) {
            return this.visitExtract(call);
        }
        if (operator.getKind() == SqlKind.OTHER && operator.getName().equals("DATETIME_MINUS")) {
            return this.visitDateMinus(call);
        }
        if (operator.getKind() == SqlKind.OTHER && operator.getName().startsWith("gs.function.")) {
            return this.visitUserDefinedFunction(call);
        }
        if (call.getOperands().size() == 1) {
            return this.visitUnaryOperator(call);
        }
        return this.visitBinaryOperator(call);
    }

    private OuterExpression.Expression visitUserDefinedFunction(RexCall call) {
        List operands = call.getOperands();
        List parameters = operands.stream().map(operand -> (OuterExpression.Expression)operand.accept((RexVisitor)this)).collect(Collectors.toList());
        return OuterExpression.Expression.newBuilder().addOperators(OuterExpression.ExprOpr.newBuilder().setUdfFunc(OuterExpression.UserDefinedFunction.newBuilder().setName(call.op.getName()).addAllParameters(parameters).build()).setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId))).build();
    }

    private OuterExpression.Expression visitPathFunction(RexCall call) {
        List operands = call.getOperands();
        RexGraphVariable variable = (RexGraphVariable)((Object)operands.get(0));
        OuterExpression.PathFunction.Builder builder = OuterExpression.PathFunction.newBuilder();
        if (variable.getAliasId() != -1) {
            builder.setTag(Common.NameOrId.newBuilder().setId(variable.getAliasId()).build());
        }
        GraphOpt.PathExpandFunction funcOpt = (GraphOpt.PathExpandFunction)((Object)((RexLiteral)operands.get(1)).getValueAs(GraphOpt.PathExpandFunction.class));
        builder.setOpt(OuterExpression.PathFunction.FuncOpt.valueOf(funcOpt.name()));
        this.setPathFunctionProjection(builder, (RexNode)operands.get(2));
        return OuterExpression.Expression.newBuilder().addOperators(OuterExpression.ExprOpr.newBuilder().setPathFunc(builder).setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId))).build();
    }

    private void setPathFunctionProjection(OuterExpression.PathFunction.Builder builder, RexNode projection) {
        switch (projection.getKind()) {
            case MAP_VALUE_CONSTRUCTOR: {
                List operands = ((RexCall)projection).getOperands();
                OuterExpression.PathFunction.PathElementKeyValues.Builder keyValuesBuilder = OuterExpression.PathFunction.PathElementKeyValues.newBuilder();
                for (int i = 0; i < operands.size(); i += 2) {
                    keyValuesBuilder.addKeyVals(OuterExpression.PathFunction.PathElementKeyValues.PathElementKeyValue.newBuilder().setKey(((OuterExpression.Expression)((RexNode)operands.get(i)).accept((RexVisitor)this)).getOperators(0).getConst()).setVal(this.visitPathFunctionProperty((RexNode)operands.get(i + 1))));
                }
                builder.setMap(keyValuesBuilder);
                break;
            }
            case ARRAY_VALUE_CONSTRUCTOR: {
                OuterExpression.PathFunction.PathElementKeys.Builder valuesBuilder = OuterExpression.PathFunction.PathElementKeys.newBuilder();
                ((RexCall)projection).getOperands().forEach(operand -> valuesBuilder.addKeys(this.visitPathFunctionProperty((RexNode)operand)));
                builder.setVars(valuesBuilder);
                break;
            }
            default: {
                builder.setProperty(this.visitPathFunctionProperty(projection));
            }
        }
    }

    private OuterExpression.Property visitPathFunctionProperty(RexNode variable) {
        Preconditions.checkArgument((variable instanceof RexGraphVariable && ((RexGraphVariable)variable).getProperty() != null ? 1 : 0) != 0, (Object)("cannot get path function property from variable [" + variable + "]"));
        return Utils.protoProperty(((RexGraphVariable)variable).getProperty());
    }

    private OuterExpression.Expression visitPathConcat(RexCall call) {
        List operands = call.getOperands();
        return OuterExpression.Expression.newBuilder().addOperators(OuterExpression.ExprOpr.newBuilder().setPathConcat(OuterExpression.PathConcat.newBuilder().setLeft(this.convertPathInfo(operands)).setRight(this.convertPathInfo(operands.subList(2, operands.size()))))).build();
    }

    private OuterExpression.PathConcat.ConcatPathInfo convertPathInfo(List<RexNode> operands) {
        Preconditions.checkArgument((operands.size() >= 2 && operands.get(0) instanceof RexGraphVariable && operands.get(1) instanceof RexLiteral ? 1 : 0) != 0);
        OuterExpression.Variable variable = ((OuterExpression.Expression)operands.get(0).accept((RexVisitor)this)).getOperators(0).getVar();
        GraphOpt.GetV direction = (GraphOpt.GetV)((Object)((RexLiteral)operands.get(1)).getValueAs(GraphOpt.GetV.class));
        return OuterExpression.PathConcat.ConcatPathInfo.newBuilder().setPathTag(variable).setEndpoint(this.convertPathDirection(direction)).build();
    }

    private OuterExpression.PathConcat.Endpoint convertPathDirection(GraphOpt.GetV direction) {
        switch (direction) {
            case START: {
                return OuterExpression.PathConcat.Endpoint.START;
            }
            case END: {
                return OuterExpression.PathConcat.Endpoint.END;
            }
        }
        throw new IllegalArgumentException("invalid path concat direction [" + direction.name() + "], cannot convert to any physical expression");
    }

    private OuterExpression.Expression visitDateMinus(RexCall call) {
        OuterExpression.Expression.Builder exprBuilder = OuterExpression.Expression.newBuilder();
        RexLiteral interval = (RexLiteral)call.getOperands().get(2);
        SqlOperator operator = call.getOperator();
        for (int i = 0; i < 2; ++i) {
            RexNode operand = (RexNode)call.getOperands().get(i);
            if (i != 0) {
                exprBuilder.addOperators(OuterExpression.ExprOpr.newBuilder().setDateTimeMinus(OuterExpression.DateTimeMinus.newBuilder().setInterval(Utils.protoInterval(interval))).setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId)));
            }
            if (this.needBrace(operator, operand)) {
                exprBuilder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.LEFT_BRACE).build());
            }
            exprBuilder.addAllOperators(((OuterExpression.Expression)operand.accept((RexVisitor)this)).getOperatorsList());
            if (!this.needBrace(operator, operand)) continue;
            exprBuilder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.RIGHT_BRACE).build());
        }
        return exprBuilder.build();
    }

    private OuterExpression.Expression visitCase(RexCall call) {
        OuterExpression.Case.Builder caseBuilder = OuterExpression.Case.newBuilder();
        int operandCount = call.getOperands().size();
        Preconditions.checkArgument((operandCount > 2 && (operandCount & 1) == 1 ? 1 : 0) != 0);
        for (int i = 1; i < operandCount - 1; i += 2) {
            RexNode whenNode = (RexNode)call.getOperands().get(i - 1);
            RexNode thenNode = (RexNode)call.getOperands().get(i);
            caseBuilder.addWhenThenExpressions(OuterExpression.Case.WhenThen.newBuilder().setWhenExpression((OuterExpression.Expression)whenNode.accept((RexVisitor)this)).setThenResultExpression((OuterExpression.Expression)thenNode.accept((RexVisitor)this)));
        }
        caseBuilder.setElseResultExpression((OuterExpression.Expression)((RexNode)call.getOperands().get(operandCount - 1)).accept((RexVisitor)this));
        return OuterExpression.Expression.newBuilder().addOperators(OuterExpression.ExprOpr.newBuilder().setCase(caseBuilder).setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId))).build();
    }

    private OuterExpression.Expression visitArrayValueConstructor(RexCall call) {
        OuterExpression.VariableKeys.Builder varsBuilder = OuterExpression.VariableKeys.newBuilder();
        call.getOperands().forEach(operand -> {
            Preconditions.checkArgument((boolean)(operand instanceof RexGraphVariable), (Object)"component type of 'ARRAY_VALUE_CONSTRUCTOR' should be 'variable' in ir core structure");
            varsBuilder.addKeys(((OuterExpression.Expression)operand.accept((RexVisitor)this)).getOperators(0).getVar());
        });
        return OuterExpression.Expression.newBuilder().addOperators(OuterExpression.ExprOpr.newBuilder().setVars(varsBuilder).setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId))).build();
    }

    private OuterExpression.Expression visitMapValueConstructor(RexCall call) {
        OuterExpression.VariableKeyValues.Builder varMapBuilder = OuterExpression.VariableKeyValues.newBuilder();
        List operands = call.getOperands();
        for (int i = 0; i < operands.size() - 1; i += 2) {
            RexNode key = (RexNode)operands.get(i);
            RexNode value = (RexNode)operands.get(i + 1);
            Preconditions.checkArgument((boolean)(key instanceof RexLiteral), (Object)("key type of 'MAP_VALUE_CONSTRUCTOR' should be 'literal', but is " + key.getClass()));
            OuterExpression.ExprOpr valueOpr = ((OuterExpression.Expression)value.accept((RexVisitor)this)).getOperators(0);
            OuterExpression.VariableKeyValue.Builder keyValueBuilder = OuterExpression.VariableKeyValue.newBuilder().setKey(((OuterExpression.Expression)key.accept((RexVisitor)this)).getOperators(0).getConst());
            switch (valueOpr.getItemCase()) {
                case VAR: {
                    keyValueBuilder.setVal(valueOpr.getVar());
                    break;
                }
                case MAP: {
                    keyValueBuilder.setNested(valueOpr.getMap());
                    break;
                }
                case PATH_FUNC: {
                    keyValueBuilder.setPathFunc(valueOpr.getPathFunc());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("can not convert value [" + value + "] of 'MAP_VALUE_CONSTRUCTOR' to physical plan");
                }
            }
            varMapBuilder.addKeyVals(keyValueBuilder);
        }
        return OuterExpression.Expression.newBuilder().addOperators(OuterExpression.ExprOpr.newBuilder().setMap(varMapBuilder).setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId))).build();
    }

    private OuterExpression.Expression visitExtract(RexCall call) {
        List operands = call.getOperands();
        Preconditions.checkArgument((operands.size() == 2 && operands.get(0) instanceof RexLiteral ? 1 : 0) != 0, (Object)("'EXTRACT' operator has invalid operands " + operands));
        OuterExpression.Expression.Builder builder = OuterExpression.Expression.newBuilder();
        builder.addOperators(OuterExpression.ExprOpr.newBuilder().setExtract(OuterExpression.Extract.newBuilder().setInterval(Utils.protoInterval((RexLiteral)operands.get(0)))).setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId)));
        SqlOperator operator = call.getOperator();
        RexNode operand = (RexNode)operands.get(1);
        boolean needBrace = this.needBrace(operator, operand);
        if (needBrace) {
            builder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.LEFT_BRACE));
        }
        builder.addAllOperators(((OuterExpression.Expression)operand.accept((RexVisitor)this)).getOperatorsList());
        if (needBrace) {
            builder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.RIGHT_BRACE));
        }
        return builder.build();
    }

    private OuterExpression.Expression visitUnaryOperator(RexCall call) {
        SqlOperator operator = call.getOperator();
        RexNode operand = (RexNode)call.getOperands().get(0);
        switch (operator.getKind()) {
            case IS_NOT_NULL: {
                return OuterExpression.Expression.newBuilder().addOperators(Utils.protoOperator((SqlOperator)GraphStdOperatorTable.NOT).toBuilder().setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId))).addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.LEFT_BRACE)).addAllOperators(this.visitUnaryOperator((SqlOperator)GraphStdOperatorTable.IS_NULL, operand, call.getType()).getOperatorsList()).addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.RIGHT_BRACE)).build();
            }
        }
        return this.visitUnaryOperator(operator, operand, call.getType());
    }

    private OuterExpression.Expression visitUnaryOperator(SqlOperator operator, RexNode operand, RelDataType dataType) {
        OuterExpression.Expression.Builder builder = OuterExpression.Expression.newBuilder();
        builder.addOperators(Utils.protoOperator(operator).toBuilder().setNodeType(Utils.protoIrDataType(dataType, this.isColumnId)));
        boolean needBrace = this.needBrace(operator, operand);
        if (needBrace) {
            builder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.LEFT_BRACE));
        }
        builder.addAllOperators(((OuterExpression.Expression)operand.accept((RexVisitor)this)).getOperatorsList());
        if (needBrace) {
            builder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.RIGHT_BRACE));
        }
        return builder.build();
    }

    private OuterExpression.Expression visitBinaryOperator(RexCall call) {
        RexNode operand;
        if (call.getOperator().getKind() == SqlKind.SEARCH) {
            Sarg sarg;
            RexNode left = (RexNode)call.getOperands().get(0);
            RexNode right = (RexNode)call.getOperands().get(1);
            RexLiteral literal = null;
            if (left instanceof RexLiteral) {
                literal = (RexLiteral)left;
            } else if (right instanceof RexLiteral) {
                literal = (RexLiteral)right;
            }
            if (literal != null && literal.getValue() instanceof Sarg && !(sarg = (Sarg)literal.getValue()).isPoints()) {
                call = (RexCall)RexUtil.expandSearch((RexBuilder)this.rexBuilder, null, (RexNode)call);
            }
        }
        SqlOperator operator = call.getOperator();
        OuterExpression.Expression.Builder exprBuilder = OuterExpression.Expression.newBuilder();
        if (operator.getLeftPrec() <= operator.getRightPrec()) {
            for (int i = 0; i < call.getOperands().size(); ++i) {
                operand = (RexNode)call.getOperands().get(i);
                if (i != 0) {
                    exprBuilder.addOperators(Utils.protoOperator(operator).toBuilder().setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId)));
                }
                if (this.needBrace(operator, operand)) {
                    exprBuilder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.LEFT_BRACE).build());
                }
                exprBuilder.addAllOperators(((OuterExpression.Expression)operand.accept((RexVisitor)this)).getOperatorsList());
                if (!this.needBrace(operator, operand)) continue;
                exprBuilder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.RIGHT_BRACE).build());
            }
        } else {
            for (int i = call.getOperands().size() - 1; i >= 0; --i) {
                operand = (RexNode)call.getOperands().get(i);
                if (i != 0) {
                    exprBuilder.addOperators(Utils.protoOperator(operator).toBuilder().setNodeType(Utils.protoIrDataType(call.getType(), this.isColumnId)));
                }
                if (this.needBrace(operator, operand)) {
                    exprBuilder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.LEFT_BRACE).build());
                }
                exprBuilder.addAllOperators(((OuterExpression.Expression)operand.accept((RexVisitor)this)).getOperatorsList());
                if (!this.needBrace(operator, operand)) continue;
                exprBuilder.addOperators(OuterExpression.ExprOpr.newBuilder().setBrace(OuterExpression.ExprOpr.Brace.RIGHT_BRACE).build());
            }
        }
        return exprBuilder.build();
    }

    private boolean needBrace(SqlOperator operator, RexNode operand) {
        switch (operator.getKind()) {
            case NOT: {
                return true;
            }
        }
        return operand instanceof RexCall && ((RexCall)operand).getOperator().getLeftPrec() <= operator.getLeftPrec();
    }

    public OuterExpression.Expression visitInputRef(RexInputRef inputRef) {
        OuterExpression.Expression.Builder builder = OuterExpression.Expression.newBuilder();
        if (inputRef instanceof RexGraphVariable) {
            RexGraphVariable var = (RexGraphVariable)inputRef;
            OuterExpression.Variable.Builder varBuilder = OuterExpression.Variable.newBuilder();
            if (var.getAliasId() != -1) {
                varBuilder.setTag(Common.NameOrId.newBuilder().setId(var.getAliasId()).build());
            }
            if (var.getProperty() != null) {
                varBuilder.setProperty(Utils.protoProperty(var.getProperty()));
            }
            DataType.IrDataType varDataType = Utils.protoIrDataType(inputRef.getType(), this.isColumnId);
            varBuilder.setNodeType(varDataType);
            builder.addOperators(OuterExpression.ExprOpr.newBuilder().setVar(varBuilder.build()).setNodeType(varDataType).build());
        }
        return builder.build();
    }

    public OuterExpression.Expression visitLiteral(RexLiteral literal) {
        OuterExpression.ExprOpr.Builder oprBuilder = OuterExpression.ExprOpr.newBuilder();
        if (literal.getType() instanceof IntervalSqlType) {
            oprBuilder.setTimeInterval(OuterExpression.TimeInterval.newBuilder().setInterval(Utils.protoInterval(literal)).setConst(Common.Value.newBuilder().setI64(((Number)literal.getValueAs(Number.class)).longValue())));
        } else {
            oprBuilder.setConst(Utils.protoValue(literal));
        }
        return OuterExpression.Expression.newBuilder().addOperators(oprBuilder.setNodeType(Utils.protoIrDataType(literal.getType(), this.isColumnId)).build()).build();
    }

    public OuterExpression.Expression visitDynamicParam(RexDynamicParam dynamicParam) {
        DataType.IrDataType paramDataType = Utils.protoIrDataType(dynamicParam.getType(), this.isColumnId);
        return OuterExpression.Expression.newBuilder().addOperators(OuterExpression.ExprOpr.newBuilder().setParam(OuterExpression.DynamicParam.newBuilder().setName(dynamicParam.getName()).setIndex(dynamicParam.getIndex()).setDataType(paramDataType).build()).setNodeType(paramDataType).build()).build();
    }

    public OuterExpression.Expression visitSubQuery(RexSubQuery subQuery) {
        throw new IllegalArgumentException("cannot convert sub query [" + subQuery + "] to physical expression, please use 'apply' instead");
    }
}

