/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.runtime.type;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.commons.lang3.ObjectUtils;

public class PhysicalNode<T>
extends AbstractRelNode {
    private final RelNode original;
    private final List<T> nodes;

    protected PhysicalNode(RelOptCluster cluster, RelTraitSet traitSet, RelNode original, List<T> nodes) {
        super(cluster, traitSet);
        this.original = Objects.requireNonNull(original);
        this.nodes = (List)ObjectUtils.requireNonEmpty(nodes);
    }

    public PhysicalNode(RelNode original, T node) {
        this(original.getCluster(), RelTraitSet.createEmpty(), original, (List<T>)ImmutableList.of(node));
    }

    public PhysicalNode(RelNode original, List<T> nodes) {
        this(original.getCluster(), RelTraitSet.createEmpty(), original, nodes);
    }

    public RelNode getOriginal() {
        return this.original;
    }

    public T getNode() {
        return this.nodes.get(0);
    }

    public List<T> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }
}

