/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.tools;

import com.alibaba.graphscope.common.ir.rel.GraphLogicalProject;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.NlsString;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AliasInference {
    public static final String DEFAULT_NAME = "_";
    public static final int DEFAULT_ID = -1;
    public static final String STAR = "*";
    public static final int DEFAULT_COLUMN_ID = 100;
    public static final String DELIMITER = ".";

    public static final String SIMPLE_NAME(String alias) {
        return alias == DEFAULT_NAME ? DEFAULT_NAME : alias;
    }

    public static final String inferDefault(@Nullable String fieldName, Set<String> uniqueNameList) throws IllegalArgumentException {
        if (AliasInference.isDefaultAlias(fieldName)) {
            return DEFAULT_NAME;
        }
        if (uniqueNameList.contains(fieldName)) {
            throw new IllegalArgumentException("alias=" + fieldName + " exists in " + uniqueNameList);
        }
        return fieldName;
    }

    public static final List<String> inferProject(List<RexNode> exprList, List<@Nullable String> fieldNameList, Set<String> uniqueNameList) throws IllegalArgumentException {
        int i;
        ObjectUtils.requireNonEmpty(exprList);
        Objects.requireNonNull(fieldNameList);
        Objects.requireNonNull(uniqueNameList);
        while (fieldNameList.size() < exprList.size()) {
            fieldNameList.add(null);
        }
        for (i = 0; i < fieldNameList.size(); ++i) {
            if (AliasInference.isDefaultAlias(fieldNameList.get(i))) {
                String inferred = AliasInference.innerInfer(exprList, exprList.get(i), i);
                fieldNameList.set(i, AliasInference.isDefaultAlias(inferred) ? null : inferred);
                continue;
            }
            String field = fieldNameList.get(i);
            if (fieldNameList.lastIndexOf(field) == i && !uniqueNameList.contains(field)) continue;
            throw new IllegalArgumentException("alias=" + field + " exists in " + CollectionUtils.union(fieldNameList, uniqueNameList));
        }
        for (i = 0; i < fieldNameList.size(); ++i) {
            String name;
            String originalName = name = fieldNameList.get(i);
            if (name == null || uniqueNameList.contains(name)) {
                int j = 0;
                if (name == null) {
                    j = i;
                }
                while (uniqueNameList.contains(name = SqlValidatorUtil.F_SUGGESTER.apply(originalName, j, j++))) {
                }
                fieldNameList.set(i, name);
            }
            uniqueNameList.add(name);
        }
        return fieldNameList;
    }

    private static @Nullable String innerInfer(List<RexNode> exprList, RexNode expr, int i) {
        if (expr instanceof RexGraphVariable) {
            String name = ((RexGraphVariable)expr).getName();
            String[] nameArray = name.split(Pattern.quote(DELIMITER));
            if (ObjectUtils.isEmpty((Object)nameArray)) {
                return null;
            }
            if (nameArray.length == 1) {
                return nameArray[0];
            }
            return nameArray[1];
        }
        switch (expr.getKind()) {
            case CAST: {
                return AliasInference.innerInfer(exprList, (RexNode)((RexCall)expr).getOperands().get(0), -1);
            }
            case AS: {
                RexCall call = (RexCall)expr;
                if (i >= 0) {
                    exprList.set(i, (RexNode)call.getOperands().get(0));
                }
                NlsString value = (NlsString)((RexLiteral)call.getOperands().get(1)).getValue();
                return ((NlsString)Nullness.castNonNull((Object)value)).getValue();
            }
        }
        return null;
    }

    public static final Set<String> getUniqueAliasList(@Nullable RelNode input, boolean isAppend) {
        HashSet<String> uniqueNames = new HashSet<String>();
        if (!isAppend || input == null) {
            return uniqueNames;
        }
        ArrayList inputsQueue = Lists.newArrayList((Object[])new RelNode[]{input});
        while (!inputsQueue.isEmpty()) {
            RelNode cur = (RelNode)inputsQueue.remove(0);
            for (RelDataTypeField field : cur.getRowType().getFieldList()) {
                if (AliasInference.isDefaultAlias(field.getName())) continue;
                uniqueNames.add(field.getName());
            }
            if (AliasInference.removeAlias(cur)) break;
            inputsQueue.addAll(cur.getInputs());
        }
        return uniqueNames;
    }

    public static final boolean removeAlias(RelNode node) {
        return node instanceof Aggregate || node instanceof GraphLogicalProject && !((GraphLogicalProject)node).isAppend();
    }

    public static final boolean isDefaultAlias(@Nullable String alias) {
        return alias == null || alias.equals(DEFAULT_NAME);
    }

    public static final String inferAliasWithPrefix(String prefix, Set<String> uniqueNameList) {
        String name;
        int j = 0;
        do {
            name = prefix + j;
            ++j;
        } while (uniqueNameList.contains(name));
        return name;
    }
}

