/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.tools;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.FrontendConfig;
import com.alibaba.graphscope.common.config.GraphConfig;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.IrMetaTracker;
import com.alibaba.graphscope.common.ir.meta.fetcher.IrMetaFetcher;
import com.alibaba.graphscope.common.ir.meta.fetcher.StaticIrMetaFetcher;
import com.alibaba.graphscope.common.ir.meta.procedure.StoredProcedureMeta;
import com.alibaba.graphscope.common.ir.meta.reader.HttpIrMetaReader;
import com.alibaba.graphscope.common.ir.meta.reader.LocalIrMetaReader;
import com.alibaba.graphscope.common.ir.meta.schema.GraphOptSchema;
import com.alibaba.graphscope.common.ir.meta.schema.IrGraphSchema;
import com.alibaba.graphscope.common.ir.planner.GraphIOProcessor;
import com.alibaba.graphscope.common.ir.planner.GraphRelOptimizer;
import com.alibaba.graphscope.common.ir.planner.PlannerGroupManager;
import com.alibaba.graphscope.common.ir.runtime.PhysicalBuilder;
import com.alibaba.graphscope.common.ir.runtime.PhysicalPlan;
import com.alibaba.graphscope.common.ir.runtime.ProcedurePhysicalBuilder;
import com.alibaba.graphscope.common.ir.runtime.ffi.FfiPhysicalBuilder;
import com.alibaba.graphscope.common.ir.runtime.proto.GraphRelProtoPhysicalBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphRexBuilder;
import com.alibaba.graphscope.common.ir.tools.LogicalPlan;
import com.alibaba.graphscope.common.ir.tools.LogicalPlanFactory;
import com.alibaba.graphscope.common.ir.type.GraphTypeFactoryImpl;
import com.alibaba.graphscope.common.utils.ClassUtils;
import com.alibaba.graphscope.proto.frontend.Code;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class GraphPlanner {
    private static final Logger logger = LoggerFactory.getLogger(GraphPlanner.class);
    private final Configs graphConfig;
    private final GraphRelOptimizer optimizer;
    private final RexBuilder rexBuilder;
    private final LogicalPlanFactory logicalPlanFactory;
    public static final Function<Configs, RexBuilder> rexBuilderFactory = configs -> new GraphRexBuilder((RelDataTypeFactory)new GraphTypeFactoryImpl((Configs)configs));

    public GraphPlanner(Configs graphConfig, LogicalPlanFactory logicalPlanFactory, GraphRelOptimizer optimizer) {
        this.graphConfig = graphConfig;
        this.optimizer = optimizer;
        this.logicalPlanFactory = logicalPlanFactory;
        this.rexBuilder = rexBuilderFactory.apply(graphConfig);
    }

    public PlannerInstance instance(String query, IrMeta irMeta) {
        GraphOptCluster optCluster = GraphOptCluster.create(this.optimizer.getMatchPlanner(), this.rexBuilder);
        RelMetadataQuery mq = ClassUtils.callException(() -> this.optimizer.createMetaDataQuery(irMeta), Code.META_STATISTICS_NOT_READY);
        if (mq != null) {
            optCluster.setMetadataQuerySupplier(() -> mq);
        }
        IrGraphSchema schema = irMeta.getSchema();
        GraphBuilder graphBuilder = GraphBuilder.create(this.graphConfig, optCluster, new GraphOptSchema(optCluster, schema));
        LogicalPlan logicalPlan = this.logicalPlanFactory.create(graphBuilder, irMeta, query);
        return new PlannerInstance(query, logicalPlan, graphBuilder, irMeta);
    }

    private static Configs createExtraConfigs(@Nullable String extraYamlFile) throws Exception {
        HashMap keyValueMap = Maps.newHashMap();
        if (!StringUtils.isEmpty((CharSequence)extraYamlFile)) {
            String extraYaml = FileUtils.readFileToString((File)new File(extraYamlFile), (Charset)StandardCharsets.UTF_8);
            Yaml yaml = new Yaml();
            Map yamlMap = (Map)yaml.load(extraYaml);
            yamlMap.forEach((k, v) -> {
                if (v != null) {
                    keyValueMap.put(k, v.toString());
                }
            });
        }
        return new Configs(keyValueMap);
    }

    private static IrMetaFetcher createIrMetaFetcher(Configs configs, IrMetaTracker tracker) throws IOException {
        URI schemaUri = URI.create(GraphConfig.GRAPH_META_SCHEMA_URI.get(configs));
        if (schemaUri.getScheme() == null || schemaUri.getScheme().equals("file")) {
            return new StaticIrMetaFetcher(new LocalIrMetaReader(configs), tracker);
        }
        if (schemaUri.getScheme().equals("http")) {
            return new StaticIrMetaFetcher(new HttpIrMetaReader(configs), tracker);
        }
        throw new IllegalArgumentException("unknown graph meta reader mode: " + schemaUri.getScheme());
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4 || args[0].isEmpty() || args[1].isEmpty() || args[2].isEmpty() || args[3].isEmpty()) {
            throw new IllegalArgumentException("usage: GraphPlanner '<path_to_config_file>' '<path_to_query_file>'  '<path_to_physical_output_file>' '<path_to_procedure_file>' 'optional <extra_key_value_config_file>'");
        }
        Configs configs = Configs.Factory.create(args[0]);
        GraphRelOptimizer optimizer = new GraphRelOptimizer(configs, PlannerGroupManager.Static.class);
        IrMetaFetcher metaFetcher = GraphPlanner.createIrMetaFetcher(configs, optimizer.getGlogueHolder());
        String query = FileUtils.readFileToString((File)new File(args[1]), (Charset)StandardCharsets.UTF_8);
        GraphPlanner planner = new GraphPlanner(configs, new LogicalPlanFactory.Cypher(), optimizer);
        PlannerInstance instance = planner.instance(query, metaFetcher.fetch().get());
        Summary summary = instance.plan();
        PhysicalPlan physicalPlan = summary.physicalPlan;
        FileUtils.writeByteArrayToFile((File)new File(args[2]), (byte[])((byte[])physicalPlan.getContent()));
        LogicalPlan logicalPlan = summary.getLogicalPlan();
        Configs extraConfigs = GraphPlanner.createExtraConfigs(args.length > 4 ? args[4] : null);
        StoredProcedureMeta procedureMeta = new StoredProcedureMeta(extraConfigs, query, logicalPlan.getOutputType(), logicalPlan.getDynamicParams());
        StoredProcedureMeta.Serializer.perform(procedureMeta, new FileOutputStream(args[3]));
    }

    public static class Summary {
        private final LogicalPlan logicalPlan;
        private final PhysicalPlan physicalPlan;

        public Summary(LogicalPlan logicalPlan, PhysicalPlan physicalPlan) {
            this.logicalPlan = Objects.requireNonNull(logicalPlan);
            this.physicalPlan = Objects.requireNonNull(physicalPlan);
        }

        public LogicalPlan getLogicalPlan() {
            return this.logicalPlan;
        }

        public PhysicalPlan getPhysicalPlan() {
            return this.physicalPlan;
        }
    }

    public class PlannerInstance {
        private final String query;
        private final LogicalPlan parsedPlan;
        private final GraphBuilder graphBuilder;
        private final IrMeta irMeta;

        public PlannerInstance(String query, LogicalPlan parsedPlan, GraphBuilder graphBuilder, IrMeta irMeta) {
            this.query = query;
            this.parsedPlan = parsedPlan;
            this.graphBuilder = graphBuilder;
            this.irMeta = irMeta;
        }

        public LogicalPlan getParsedPlan() {
            return this.parsedPlan;
        }

        public Summary plan() {
            LogicalPlan logicalPlan = ClassUtils.callException(() -> this.planLogical(), Code.LOGICAL_PLAN_BUILD_FAILED);
            return new Summary(logicalPlan, ClassUtils.callException(() -> this.planPhysical(logicalPlan), Code.PHYSICAL_PLAN_BUILD_FAILED));
        }

        public LogicalPlan planLogical() {
            RelNode before;
            RelNode after;
            LogicalPlan logicalPlan = this.parsedPlan;
            if (logicalPlan.getRegularQuery() != null && !logicalPlan.isReturnEmpty() && (after = GraphPlanner.this.optimizer.optimize(before = logicalPlan.getRegularQuery(), new GraphIOProcessor(this.graphBuilder, this.irMeta))) != before) {
                logicalPlan = new LogicalPlan(after, logicalPlan.getDynamicParams());
            }
            return logicalPlan;
        }

        public PhysicalPlan planPhysical(LogicalPlan logicalPlan) {
            if (logicalPlan.isReturnEmpty()) {
                return PhysicalPlan.createEmpty();
            }
            if (logicalPlan.getRegularQuery() != null) {
                PhysicalPlan physicalPlan;
                String physicalOpt = FrontendConfig.GRAPH_PHYSICAL_OPT.get(GraphPlanner.this.graphConfig);
                if ("proto".equals(physicalOpt.toLowerCase())) {
                    PhysicalPlan physicalPlan2;
                    logger.debug("physical type is proto");
                    GraphRelProtoPhysicalBuilder physicalBuilder = new GraphRelProtoPhysicalBuilder(GraphPlanner.this.graphConfig, this.irMeta, logicalPlan);
                    try {
                        physicalPlan2 = physicalBuilder.build();
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                physicalBuilder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    physicalBuilder.close();
                    return physicalPlan2;
                }
                logger.debug("physical type is ffi");
                FfiPhysicalBuilder physicalBuilder = new FfiPhysicalBuilder(GraphPlanner.this.graphConfig, this.irMeta, logicalPlan);
                try {
                    physicalPlan = ((PhysicalBuilder)physicalBuilder).build();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            physicalBuilder.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                physicalBuilder.close();
                return physicalPlan;
            }
            return new ProcedurePhysicalBuilder(logicalPlan).build();
        }
    }
}

