/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.tools;

import com.alibaba.graphscope.common.ir.rex.RexGraphDynamicParam;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Util;

public class GraphRexBuilder
extends RexBuilder {
    public GraphRexBuilder(RelDataTypeFactory typeFactory) {
        super(typeFactory);
    }

    public RexGraphDynamicParam makeGraphDynamicParam(String name, int index) {
        return this.makeGraphDynamicParam(this.getTypeFactory().createUnknownType(), name, index);
    }

    public RexGraphDynamicParam makeGraphDynamicParam(RelDataType dataType, String name, int index) {
        return new RexGraphDynamicParam(dataType, name, index);
    }

    public RexNode makeIn(RexNode arg, List<? extends RexNode> ranges) {
        ArrayList flatRanges = Lists.newArrayList();
        ranges.forEach(k -> {
            if (k.getKind() == SqlKind.ARRAY_VALUE_CONSTRUCTOR) {
                flatRanges.addAll(((RexCall)k).getOperands());
            } else {
                flatRanges.add(k);
            }
        });
        Method m1 = this.getMethod("areAssignable", RexNode.class, List.class);
        if (((Boolean)this.invoke(m1, arg, flatRanges)).booleanValue()) {
            Method m2 = this.getMethod("toSarg", Class.class, List.class, RexUnknownAs.class);
            Sarg sarg = (Sarg)this.invoke(m2, Comparable.class, flatRanges, RexUnknownAs.UNKNOWN);
            if (sarg != null) {
                List types = flatRanges.stream().map(RexNode::getType).collect(Collectors.toList());
                RelDataType sargType = Objects.requireNonNull(this.typeFactory.leastRestrictive(types), () -> "Can't find leastRestrictive type for SARG among " + types);
                return this.makeCall((SqlOperator)GraphStdOperatorTable.SEARCH, new RexNode[]{arg, this.makeSearchArgumentLiteral(sarg, sargType)});
            }
        }
        if (ranges.size() == 1) {
            RexNode range = ranges.get(0);
            switch (range.getKind()) {
                case DYNAMIC_PARAM: 
                case INPUT_REF: {
                    return this.makeCall(GraphStdOperatorTable.IN, new RexNode[]{arg, ranges.get(0)});
                }
            }
        }
        return RexUtil.composeDisjunction((RexBuilder)this, (Iterable)((Iterable)flatRanges.stream().map(r -> this.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{arg, r})).collect(Util.toImmutableList())));
    }

    private Method getMethod(String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = RexBuilder.class.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object invoke(Method method, Object ... args) {
        try {
            return method.invoke(null, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

