/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.tools;

import com.alibaba.graphscope.common.ir.rex.RexTmpVariable;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;

public class Registrar {
    private final GraphBuilder builder;
    private List<RexNode> extraNodes;
    private List<String> extraAliases;
    private boolean isAppend;
    private Set<String> uniqueNames;

    public Registrar(GraphBuilder builder, RelNode input, boolean isAppend) {
        this.builder = builder;
        this.extraNodes = new ArrayList<RexNode>();
        this.extraAliases = new ArrayList<String>();
        this.isAppend = isAppend;
        this.uniqueNames = AliasInference.getUniqueAliasList(input, isAppend);
    }

    public List<RexNode> registerExpressions(List<RexNode> nodes) {
        return nodes.stream().map(k -> this.registerExpression((RexNode)k)).collect(Collectors.toList());
    }

    private RexNode registerExpression(RexNode node) {
        String variableName;
        if (node instanceof RexInputRef) {
            return node;
        }
        switch (node.getKind()) {
            case AS: {
                RexNode left = (RexNode)((RexCall)node).getOperands().get(0);
                RexNode right = (RexNode)((RexCall)node).getOperands().get(1);
                return this.builder.alias(this.registerExpression(left), RexLiteral.stringValue((RexNode)right));
            }
            case DESCENDING: {
                RexNode operand = (RexNode)((RexCall)node).getOperands().get(0);
                return this.builder.desc(this.registerExpression(operand));
            }
        }
        int index = this.extraNodes.indexOf(node);
        if (index >= 0) {
            variableName = this.extraAliases.get(index);
        } else {
            this.extraNodes.add(node);
            variableName = this.inferAlias(node);
            this.extraAliases.add(variableName);
            this.uniqueNames.add(variableName);
        }
        return RexTmpVariable.of(variableName, node.getType());
    }

    private String inferAlias(RexNode node) {
        ArrayList<String> newAliases = new ArrayList<String>();
        AliasInference.inferProject((List<RexNode>)ImmutableList.of((Object)node), newAliases, Sets.newHashSet(this.uniqueNames));
        return (String)newAliases.get(0);
    }

    public List<RexNode> getExtraNodes() {
        return Collections.unmodifiableList(this.extraNodes);
    }

    public List<String> getExtraAliases() {
        return Collections.unmodifiableList(this.extraAliases);
    }

    public boolean isAppend() {
        return this.isAppend;
    }
}

