/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.tools.config;

import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.type.AliasNameWithId;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.config.ExpandConfig;
import com.alibaba.graphscope.common.ir.tools.config.GetVConfig;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PathExpandConfig {
    private final RelNode expand;
    private final RelNode getV;
    private final int offset;
    private final int fetch;
    private final GraphOpt.PathExpandPath pathOpt;
    private final GraphOpt.PathExpandResult resultOpt;
    private final @Nullable RexNode untilCondition;
    private final @Nullable String alias;
    private final @Nullable String startAlias;

    protected PathExpandConfig(RelNode expand, RelNode getV, int offset, int fetch, GraphOpt.PathExpandResult resultOpt, GraphOpt.PathExpandPath pathOpt, @Nullable RexNode untilCondition, @Nullable String alias, @Nullable String startAlias) {
        this.expand = Objects.requireNonNull(expand);
        this.getV = Objects.requireNonNull(getV);
        this.offset = offset;
        this.fetch = fetch;
        this.resultOpt = resultOpt;
        this.pathOpt = pathOpt;
        this.untilCondition = untilCondition;
        this.alias = alias;
        this.startAlias = startAlias;
    }

    public static Builder newBuilder(GraphBuilder innerBuilder) {
        return new Builder(innerBuilder);
    }

    public @Nullable String getAlias() {
        return this.alias;
    }

    public @Nullable String getStartAlias() {
        return this.startAlias;
    }

    public GraphOpt.PathExpandPath getPathOpt() {
        return this.pathOpt;
    }

    public GraphOpt.PathExpandResult getResultOpt() {
        return this.resultOpt;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getFetch() {
        return this.fetch;
    }

    public RelNode getExpand() {
        return this.expand;
    }

    public RelNode getGetV() {
        return this.getV;
    }

    public @Nullable RexNode getUntilCondition() {
        return this.untilCondition;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PathExpandConfig{");
        builder.append("expand=" + this.expand.explain());
        builder.append(", getV=" + this.getV.explain());
        builder.append(", offset=" + this.offset);
        builder.append(", fetch=" + this.fetch);
        builder.append(", pathOpt=" + this.pathOpt);
        builder.append(", resultOpt=" + this.resultOpt);
        if (this.untilCondition != null) {
            builder.append(", untilCondition=" + this.untilCondition);
        }
        builder.append(", alias='" + this.alias + "'");
        builder.append("}");
        return builder.toString();
    }

    public static final class Builder
    extends GraphBuilder {
        private RelNode expand;
        private RelNode getV;
        private int offset;
        private int fetch;
        private GraphOpt.PathExpandPath pathOpt;
        private GraphOpt.PathExpandResult resultOpt;
        private @Nullable RexNode untilCondition;
        private @Nullable String alias;
        private @Nullable String startAlias;

        protected Builder(GraphBuilder parentBuilder) {
            super(parentBuilder.getContext(), (GraphOptCluster)parentBuilder.getCluster(), parentBuilder.getRelOptSchema());
            if (parentBuilder.size() > 0) {
                this.push(parentBuilder.peek());
            }
            this.pathOpt = GraphOpt.PathExpandPath.ARBITRARY;
            this.resultOpt = GraphOpt.PathExpandResult.END_V;
        }

        @Override
        public Builder expand(ExpandConfig config) {
            if (this.getV == null && this.expand == null) {
                GraphLogicalExpand expandRel = (GraphLogicalExpand)super.expand(config).build();
                this.expand = GraphLogicalExpand.create((GraphOptCluster)expandRel.getCluster(), (List<RelHint>)ImmutableList.of(), null, expandRel.getOpt(), expandRel.getTableConfig(), "_", AliasNameWithId.DEFAULT);
                this.push(this.expand);
            }
            return this;
        }

        @Override
        public Builder getV(GetVConfig config) {
            if (this.expand != null && this.getV == null) {
                GraphLogicalGetV getVRel = (GraphLogicalGetV)super.getV(config).build();
                this.getV = GraphLogicalGetV.create((GraphOptCluster)getVRel.getCluster(), (List<RelHint>)ImmutableList.of(), null, getVRel.getOpt(), getVRel.getTableConfig(), "_", AliasNameWithId.DEFAULT);
                this.push(this.getV);
            }
            return this;
        }

        @Override
        public Builder filter(RexNode ... conjunctions) {
            return (Builder)super.filter(conjunctions);
        }

        public Builder untilCondition(@Nullable RexNode untilCondition) {
            this.untilCondition = untilCondition;
            return this;
        }

        public Builder range(int offset, int fetch) {
            this.offset = offset;
            this.fetch = fetch;
            return this;
        }

        public Builder pathOpt(GraphOpt.PathExpandPath pathOpt) {
            this.pathOpt = pathOpt;
            return this;
        }

        public Builder resultOpt(GraphOpt.PathExpandResult resultOpt) {
            this.resultOpt = resultOpt;
            return this;
        }

        public Builder alias(@Nullable String alias) {
            this.alias = alias;
            return this;
        }

        public Builder startAlias(@Nullable String startAlias) {
            this.startAlias = startAlias;
            return this;
        }

        public PathExpandConfig buildConfig() {
            return new PathExpandConfig(this.expand, this.getV, this.offset, this.fetch, this.resultOpt, this.pathOpt, this.untilCondition, this.alias, this.startAlias);
        }
    }
}

