/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.utils;

import com.alibaba.graphscope.common.ir.meta.schema.FileFormatType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.parser.ParserException;

public class FileUtils {
    public static String readJsonFromResource(String file) {
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(file);
            return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8).trim();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FileFormatType getFormatType(String file) throws IOException {
        FileFormatType fileFormatType;
        if (file.endsWith(".properties")) {
            return FileFormatType.PROPERTIES;
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree((InputStream)inputStream);
            fileFormatType = FileFormatType.JSON;
        }
        catch (Throwable mapper) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable) {
                    mapper.addSuppressed(throwable);
                }
                throw mapper;
            }
            catch (IOException e1) {
                FileFormatType fileFormatType2;
                FileInputStream inputStream2 = new FileInputStream(file);
                try {
                    Yaml yaml = new Yaml();
                    yaml.load((InputStream)inputStream2);
                    fileFormatType2 = FileFormatType.YAML;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)inputStream2).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (ParserException e2) {
                        throw new UnsupportedOperationException("unsupported file format " + file);
                    }
                }
                ((InputStream)inputStream2).close();
                return fileFormatType2;
            }
        }
        ((InputStream)inputStream).close();
        return fileFormatType;
    }
}

