/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.antlr4.visitor;

import com.alibaba.graphscope.common.antlr4.ExprUniqueAliasInfer;
import com.alibaba.graphscope.common.antlr4.ExprVisitorResult;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalAggregate;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rex.RexTmpVariableConverter;
import com.alibaba.graphscope.common.ir.rex.RexVariableAliasCollector;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.tools.config.PathExpandConfig;
import com.alibaba.graphscope.cypher.antlr4.visitor.ExpressionVisitor;
import com.alibaba.graphscope.cypher.antlr4.visitor.LiteralVisitor;
import com.alibaba.graphscope.cypher.antlr4.visitor.PathExpandBuilderVisitor;
import com.alibaba.graphscope.cypher.antlr4.visitor.Utils;
import com.alibaba.graphscope.grammar.CypherGSBaseVisitor;
import com.alibaba.graphscope.grammar.CypherGSParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphBuilderVisitor
extends CypherGSBaseVisitor<GraphBuilder> {
    private final GraphBuilder builder;
    private final ExpressionVisitor expressionVisitor;
    private final ExprUniqueAliasInfer aliasInfer;

    public GraphBuilderVisitor(GraphBuilder builder) {
        this(builder, new ExprUniqueAliasInfer());
    }

    public GraphBuilderVisitor(GraphBuilder builder, ExprUniqueAliasInfer aliasInfer) {
        this.builder = Objects.requireNonNull(builder);
        this.aliasInfer = Objects.requireNonNull(aliasInfer);
        this.expressionVisitor = new ExpressionVisitor(this);
    }

    @Override
    public GraphBuilder visitOC_Cypher(CypherGSParser.OC_CypherContext ctx) {
        return (GraphBuilder)((Object)this.visitOC_Statement(ctx.oC_Statement()));
    }

    @Override
    public GraphBuilder visitOC_Unwind(CypherGSParser.OC_UnwindContext ctx) {
        RexNode expr = ((ExprVisitorResult)this.expressionVisitor.visitOC_Expression(ctx.oC_Expression())).getExpr();
        String alias = ctx.oC_Variable() == null ? null : ctx.oC_Variable().getText();
        return this.builder.unfold(expr, alias);
    }

    @Override
    public GraphBuilder visitOC_Match(CypherGSParser.OC_MatchContext ctx) {
        int childCnt = ctx.oC_Pattern().getChildCount();
        ArrayList<RelNode> sentences = new ArrayList<RelNode>();
        for (int i = 0; i < childCnt; ++i) {
            CypherGSParser.OC_PatternPartContext partCtx = ctx.oC_Pattern().oC_PatternPart(i);
            if (partCtx == null) continue;
            sentences.add(((GraphBuilder)((Object)this.visitOC_PatternPart(partCtx))).build());
        }
        if (sentences.size() == 1) {
            this.builder.match((RelNode)sentences.get(0), ctx.OPTIONAL() != null ? GraphOpt.Match.OPTIONAL : GraphOpt.Match.INNER);
        } else if (sentences.size() > 1) {
            Preconditions.checkArgument((ctx.OPTIONAL() == null ? 1 : 0) != 0, (Object)"multiple sentences in match should not be optional");
            this.builder.match((RelNode)sentences.get(0), sentences.subList(1, sentences.size()));
        } else {
            throw new IllegalArgumentException("sentences in match should not be empty");
        }
        return ctx.oC_Where() != null ? this.visitOC_Where(ctx.oC_Where()) : this.builder;
    }

    @Override
    public GraphBuilder visitOC_PatternElementChain(CypherGSParser.OC_PatternElementChainContext ctx) {
        CypherGSParser.OC_RelationshipPatternContext relationCtx = ctx.oC_RelationshipPattern();
        CypherGSParser.OC_RangeLiteralContext literalCtx = relationCtx.oC_RelationshipDetail().oC_RangeLiteral();
        if (literalCtx != null && literalCtx.oC_IntegerLiteral().size() > 1) {
            this.builder.pathExpand(((PathExpandConfig.Builder)((Object)new PathExpandBuilderVisitor(this).visitOC_PatternElementChain(ctx))).buildConfig());
            if (ctx.oC_NodePattern() != null) {
                this.builder.getV(Utils.getVConfig(ctx.oC_NodePattern()));
                return this.visitOC_Properties(ctx.oC_NodePattern().oC_Properties());
            }
            return this.builder;
        }
        return (GraphBuilder)((Object)super.visitOC_PatternElementChain(ctx));
    }

    @Override
    public GraphBuilder visitOC_NodePattern(CypherGSParser.OC_NodePatternContext ctx) {
        if (!(ctx.parent instanceof CypherGSParser.OC_PatternElementChainContext)) {
            this.builder.source(Utils.sourceConfig(ctx));
        } else {
            this.builder.getV(Utils.getVConfig(ctx));
        }
        return this.visitOC_Properties(ctx.oC_Properties());
    }

    @Override
    public GraphBuilder visitOC_RelationshipPattern(CypherGSParser.OC_RelationshipPatternContext ctx) {
        this.builder.expand(Utils.expandConfig(ctx));
        return this.visitOC_Properties(ctx.oC_RelationshipDetail().oC_Properties());
    }

    @Override
    public GraphBuilder visitOC_Properties(CypherGSParser.OC_PropertiesContext ctx) {
        return ctx == null ? this.builder : this.builder.filter(Utils.propertyFilters(this.builder, this.expressionVisitor, ctx));
    }

    @Override
    public GraphBuilder visitOC_Where(CypherGSParser.OC_WhereContext ctx) {
        ExprVisitorResult res = (ExprVisitorResult)this.expressionVisitor.visitOC_Expression(ctx.oC_Expression());
        if (!res.getAggCalls().isEmpty()) {
            throw new IllegalArgumentException("aggregate functions should not exist in filter expression");
        }
        List conditions = RelOptUtil.conjunctions((RexNode)res.getExpr());
        ArrayList conditionsToRemove = Lists.newArrayList();
        for (RexNode condition : conditions) {
            RelNode antiSentence = this.getSubQueryRel(condition);
            if (antiSentence == null) continue;
            this.builder.match(antiSentence, GraphOpt.Match.ANTI);
            conditionsToRemove.add(condition);
        }
        conditions.removeAll(conditionsToRemove);
        if (!conditions.isEmpty()) {
            this.builder.filter((Iterable)conditions);
        }
        return this.builder;
    }

    private @Nullable RelNode getSubQueryRel(RexNode condition) {
        RexNode operand;
        RexCall call;
        if (condition instanceof RexCall && (call = (RexCall)condition).getOperator().getKind() == SqlKind.NOT && (operand = (RexNode)((RexCall)condition).operands.get(0)) instanceof RexSubQuery && ((RexSubQuery)operand).getOperator().getKind() == SqlKind.EXISTS) {
            return ((RexSubQuery)operand).rel;
        }
        return null;
    }

    @Override
    public GraphBuilder visitOC_With(CypherGSParser.OC_WithContext ctx) {
        this.visitOC_ProjectionBody(ctx.oC_ProjectionBody());
        return ctx.oC_Where() != null ? this.visitOC_Where(ctx.oC_Where()) : this.builder;
    }

    @Override
    public GraphBuilder visitOC_ProjectionBody(CypherGSParser.OC_ProjectionBodyContext ctx) {
        boolean isDistinct = ctx.DISTINCT() != null;
        ArrayList<RexNode> keyExprs = new ArrayList<RexNode>();
        ArrayList<String> keyAliases = new ArrayList<String>();
        ArrayList<RelBuilder.AggCall> aggCalls = new ArrayList<RelBuilder.AggCall>();
        List<Object> extraExprs = new ArrayList<RexNode>();
        ArrayList<String> extraAliases = new ArrayList<String>();
        if (this.isGroupPattern(ctx, keyExprs, keyAliases, aggCalls, extraExprs, extraAliases)) {
            RelBuilder.GroupKey groupKey = keyExprs.isEmpty() ? this.builder.groupKey() : this.builder.groupKey(keyExprs, keyAliases);
            this.builder.aggregate(groupKey, aggCalls);
            if (!extraExprs.isEmpty()) {
                RexTmpVariableConverter converter = new RexTmpVariableConverter(true, this.builder);
                extraExprs = extraExprs.stream().map(k -> (RexNode)k.accept((RexVisitor)converter)).collect(Collectors.toList());
                ArrayList projectExprs = Lists.newArrayList();
                ArrayList projectAliases = Lists.newArrayList();
                ArrayList extraVarNames = Lists.newArrayList();
                RexVariableAliasCollector<String> varNameCollector = new RexVariableAliasCollector<String>(true, v -> {
                    String[] splits = v.getName().split("\\.");
                    return splits[0];
                });
                extraExprs.forEach(k -> extraVarNames.addAll((Collection)k.accept((RexVisitor)varNameCollector)));
                GraphLogicalAggregate aggregate = (GraphLogicalAggregate)this.builder.peek();
                aggregate.getRowType().getFieldList().forEach(field -> {
                    if (!extraVarNames.contains(field.getName())) {
                        projectExprs.add(this.builder.variable(field.getName()));
                        projectAliases.add(field.getName());
                    }
                });
                for (int i = 0; i < extraExprs.size(); ++i) {
                    projectExprs.add((RexNode)extraExprs.get(i));
                    projectAliases.add((String)extraAliases.get(i));
                }
                this.builder.project((Iterable)projectExprs, (Iterable)projectAliases, false);
            }
        } else if (isDistinct) {
            this.builder.aggregate(this.builder.groupKey(keyExprs, keyAliases), new RelBuilder.AggCall[0]);
        } else {
            this.builder.project(keyExprs, keyAliases, false);
        }
        if (ctx.oC_Order() != null) {
            this.visitOC_Order(ctx.oC_Order());
        }
        if (ctx.oC_Limit() != null) {
            this.visitOC_Limit(ctx.oC_Limit());
        }
        return this.builder;
    }

    private boolean isGroupPattern(CypherGSParser.OC_ProjectionBodyContext ctx, List<RexNode> keyExprs, List<String> keyAliases, List<RelBuilder.AggCall> aggCalls, List<RexNode> extraExprs, List<String> extraAliases) {
        for (CypherGSParser.OC_ProjectionItemContext itemCtx : ctx.oC_ProjectionItems().oC_ProjectionItem()) {
            String alias;
            ExprVisitorResult item = (ExprVisitorResult)this.expressionVisitor.visitOC_Expression(itemCtx.oC_Expression());
            String string = alias = itemCtx.AS() == null ? null : itemCtx.oC_Variable().getText();
            if (item.getAggCalls().isEmpty()) {
                keyExprs.add(item.getExpr());
                keyAliases.add(alias);
                continue;
            }
            if (item.getExpr() instanceof RexCall) {
                extraExprs.add(item.getExpr());
                extraAliases.add(alias);
                aggCalls.addAll(item.getAggCalls());
                continue;
            }
            if (item.getAggCalls().size() == 1) {
                GraphAggCall original = (GraphAggCall)item.getAggCalls().get(0);
                aggCalls.add(new GraphAggCall(original.getCluster(), original.getAggFunction(), original.getOperands()).as(alias).distinct(original.isDistinct()));
                continue;
            }
            throw new IllegalArgumentException("invalid expr visit result");
        }
        return !aggCalls.isEmpty();
    }

    @Override
    public GraphBuilder visitOC_Order(CypherGSParser.OC_OrderContext ctx) {
        ArrayList<RexNode> orderBy = new ArrayList<RexNode>();
        for (CypherGSParser.OC_SortItemContext itemCtx : ctx.oC_SortItem()) {
            RexNode expr = ((ExprVisitorResult)this.expressionVisitor.visitOC_Expression(itemCtx.oC_Expression())).getExpr();
            if (itemCtx.DESC() != null || itemCtx.DESCENDING() != null) {
                expr = this.builder.desc(expr);
            }
            orderBy.add(expr);
        }
        return (GraphBuilder)this.builder.sort(orderBy);
    }

    @Override
    public GraphBuilder visitOC_Limit(CypherGSParser.OC_LimitContext ctx) {
        return (GraphBuilder)this.builder.limit(0, (Integer)LiteralVisitor.INSTANCE.visitOC_IntegerLiteral(ctx.oC_IntegerLiteral()));
    }

    public GraphBuilder getGraphBuilder() {
        return this.builder;
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public ExprUniqueAliasInfer getAliasInfer() {
        return this.aliasInfer;
    }
}

