/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.antlr4.visitor;

import com.alibaba.graphscope.grammar.CypherGSBaseVisitor;
import com.alibaba.graphscope.grammar.CypherGSParser;
import java.math.BigInteger;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.text.StringEscapeUtils;

public class LiteralVisitor
extends CypherGSBaseVisitor<Object> {
    public static final LiteralVisitor INSTANCE = new LiteralVisitor();

    private LiteralVisitor() {
    }

    @Override
    public Object visitOC_BooleanLiteral(CypherGSParser.OC_BooleanLiteralContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Object visitOC_IntegerLiteral(CypherGSParser.OC_IntegerLiteralContext ctx) {
        Object integerLiteral = ctx.getText().toLowerCase();
        try {
            char lastChar;
            if (((String)integerLiteral).length() > 1 && ((lastChar = ((String)integerLiteral).charAt(((String)integerLiteral).length() - 1)) == 'l' || lastChar == 'L')) {
                return Long.decode(((String)integerLiteral).substring(0, ((String)integerLiteral).length() - 1));
            }
            return Integer.decode((String)integerLiteral);
        }
        catch (NumberFormatException ignoredExpection1) {
            try {
                return Long.decode((String)integerLiteral);
            }
            catch (NumberFormatException ignoredExpection2) {
                boolean negative;
                int startIndex = 0;
                char firstChar = ((String)integerLiteral).charAt(0);
                boolean bl = negative = firstChar == '-';
                if (firstChar == '-' || firstChar == '+') {
                    ++startIndex;
                }
                int radix = 10;
                if (((String)integerLiteral).charAt(startIndex + 1) == 'x') {
                    radix = 16;
                    integerLiteral = ((String)integerLiteral).substring(startIndex += 2);
                    if (negative) {
                        integerLiteral = "-" + (String)integerLiteral;
                    }
                } else if (((String)integerLiteral).charAt(startIndex) == '0') {
                    radix = 8;
                }
                return new BigInteger((String)integerLiteral, radix);
            }
        }
    }

    @Override
    public Object visitOC_DoubleLiteral(CypherGSParser.OC_DoubleLiteralContext ctx) {
        String floatLiteral = ctx.getText().toLowerCase();
        return Double.valueOf(floatLiteral);
    }

    public Object visitTerminal(TerminalNode node) {
        switch (node.getSymbol().getType()) {
            case 116: {
                return StringEscapeUtils.unescapeJava((String)this.stripQuotes(node.getText()));
            }
            case 76: {
                return null;
            }
        }
        throw new UnsupportedOperationException("terminal node type " + node.getSymbol().getType() + " is unsupported yet");
    }

    private String stripQuotes(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1);
    }
}

