/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.antlr4.visitor;

import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.procedure.StoredProcedureMeta;
import com.alibaba.graphscope.common.ir.rel.graph.AbstractBindableTableScan;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.LogicalPlan;
import com.alibaba.graphscope.cypher.antlr4.visitor.GraphBuilderVisitor;
import com.alibaba.graphscope.cypher.antlr4.visitor.ProcedureCallVisitor;
import com.alibaba.graphscope.grammar.CypherGSBaseVisitor;
import com.alibaba.graphscope.grammar.CypherGSParser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogicalPlanVisitor
extends CypherGSBaseVisitor<LogicalPlan> {
    private final GraphBuilder builder;
    private final IrMeta irMeta;

    public LogicalPlanVisitor(GraphBuilder builder, IrMeta irMeta) {
        this.builder = builder;
        this.irMeta = irMeta;
    }

    @Override
    public LogicalPlan visitOC_Cypher(CypherGSParser.OC_CypherContext ctx) {
        return (LogicalPlan)this.visitOC_Statement(ctx.oC_Statement());
    }

    @Override
    public LogicalPlan visitOC_Query(CypherGSParser.OC_QueryContext ctx) {
        if (ctx.oC_RegularQuery() != null) {
            GraphBuilderVisitor builderVisitor = new GraphBuilderVisitor(this.builder);
            RelNode regularQuery = ((GraphBuilder)((Object)builderVisitor.visitOC_RegularQuery(ctx.oC_RegularQuery()))).build();
            Map<Integer, String> map = builderVisitor.getExpressionVisitor().getDynamicParams();
            return new LogicalPlan(regularQuery, this.getParameters(regularQuery, map));
        }
        RexNode procedureCall = new ProcedureCallVisitor(this.builder, this.irMeta).visitOC_StandaloneCall(ctx.oC_StandaloneCall());
        return new LogicalPlan(procedureCall);
    }

    private List<StoredProcedureMeta.Parameter> getParameters(RelNode relNode, final Map<Integer, String> paramsIdToName) {
        final ArrayList params = Lists.newArrayList();
        RexVisitorImpl parameterCollector = new RexVisitorImpl(true){

            public Void visitDynamicParam(RexDynamicParam dynamicParam) {
                String paramName = (String)paramsIdToName.get(dynamicParam.getIndex());
                params.add(new StoredProcedureMeta.Parameter(paramName, dynamicParam.getType()));
                return null;
            }
        };
        RelVisitor relVisitor = new RelVisitor((RexVisitor)parameterCollector){
            final /* synthetic */ RexVisitor val$parameterCollector;
            {
                this.val$parameterCollector = rexVisitor;
            }

            public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
                super.visit(node, ordinal, parent);
                if (node instanceof GraphLogicalSingleMatch) {
                    this.visit(((GraphLogicalSingleMatch)node).getSentence(), 0, null);
                } else if (node instanceof GraphLogicalMultiMatch) {
                    ((GraphLogicalMultiMatch)node).getSentences().forEach(s -> this.visit((RelNode)s, 0, null));
                } else if (node instanceof AbstractBindableTableScan) {
                    ImmutableList<RexNode> filters = ((AbstractBindableTableScan)node).getFilters();
                    if (ObjectUtils.isNotEmpty(filters)) {
                        for (RexNode filter : filters) {
                            filter.accept(this.val$parameterCollector);
                        }
                    }
                } else if (node instanceof Filter) {
                    RexNode condition = ((Filter)node).getCondition();
                    condition.accept(this.val$parameterCollector);
                }
            }
        };
        relVisitor.go(relNode);
        return params.stream().distinct().collect(Collectors.toList());
    }
}

