/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.antlr4.visitor;

import com.alibaba.graphscope.common.antlr4.ExprVisitorResult;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.procedure.GraphStoredProcedures;
import com.alibaba.graphscope.common.ir.meta.procedure.StoredProcedureMeta;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.alibaba.graphscope.cypher.antlr4.visitor.ExpressionVisitor;
import com.alibaba.graphscope.cypher.antlr4.visitor.GraphBuilderVisitor;
import com.alibaba.graphscope.grammar.CypherGSBaseVisitor;
import com.alibaba.graphscope.grammar.CypherGSParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.Pair;

public class ProcedureCallVisitor
extends CypherGSBaseVisitor<RexNode> {
    private final GraphBuilder builder;
    private final ExpressionVisitor expressionVisitor;
    private final IrMeta irMeta;

    public ProcedureCallVisitor(GraphBuilder builder, IrMeta irMeta) {
        this.builder = builder;
        this.expressionVisitor = new ExpressionVisitor(new GraphBuilderVisitor(this.builder));
        this.irMeta = irMeta;
    }

    @Override
    public RexNode visitOC_Cypher(CypherGSParser.OC_CypherContext ctx) {
        return (RexNode)this.visitOC_Statement(ctx.oC_Statement());
    }

    @Override
    public RexNode visitOC_StandaloneCall(CypherGSParser.OC_StandaloneCallContext ctx) {
        if (ctx.oC_ExplicitProcedureInvocation() != null) {
            return this.visitOC_ExplicitProcedureInvocation(ctx.oC_ExplicitProcedureInvocation());
        }
        return this.visitOC_ImplicitProcedureInvocation(ctx.oC_ImplicitProcedureInvocation());
    }

    @Override
    public RexNode visitOC_ExplicitProcedureInvocation(CypherGSParser.OC_ExplicitProcedureInvocationContext ctx) {
        Pair<SqlOperator, StoredProcedureMeta> operator = this.visitOC_ProcedureNameAsOperator(ctx.oC_ProcedureName());
        List operands = ctx.oC_Expression().stream().map(this::visitOC_Expression).collect(Collectors.toList());
        return this.builder.procedureCall((SqlOperator)operator.left, operands, (StoredProcedureMeta)operator.right);
    }

    @Override
    public RexNode visitOC_ImplicitProcedureInvocation(CypherGSParser.OC_ImplicitProcedureInvocationContext ctx) {
        Pair<SqlOperator, StoredProcedureMeta> operator = this.visitOC_ProcedureNameAsOperator(ctx.oC_ProcedureName());
        return this.builder.procedureCall((SqlOperator)operator.left, (Iterable<? extends RexNode>)ImmutableList.of(), (StoredProcedureMeta)operator.right);
    }

    public Pair<SqlOperator, StoredProcedureMeta> visitOC_ProcedureNameAsOperator(CypherGSParser.OC_ProcedureNameContext ctx) {
        String procedureName = ctx.getText();
        StoredProcedureMeta meta = null;
        GraphStoredProcedures procedures = this.irMeta.getStoredProcedures();
        Preconditions.checkArgument((procedures != null && (meta = procedures.getStoredProcedure(procedureName)) != null ? 1 : 0) != 0, (String)"procedure %s not found", (Object)procedureName);
        return Pair.of((Object)GraphStdOperatorTable.USER_DEFINED_PROCEDURE(meta), (Object)meta);
    }

    @Override
    public RexNode visitOC_Expression(CypherGSParser.OC_ExpressionContext ctx) {
        return ((ExprVisitorResult)this.expressionVisitor.visitOC_Expression(ctx)).getExpr();
    }
}

