/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.result;

import com.alibaba.graphscope.common.client.type.ExecutionResponseListener;
import com.alibaba.graphscope.common.config.QueryTimeoutConfig;
import com.alibaba.graphscope.common.exception.FrontendException;
import com.alibaba.graphscope.common.result.RecordParser;
import com.alibaba.graphscope.common.utils.ClassUtils;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.plugin.QueryStatusCallback;
import com.alibaba.graphscope.proto.frontend.Code;
import com.alibaba.pegasus.common.StreamIterator;
import java.util.List;
import java.util.Map;
import org.neo4j.fabric.stream.summary.EmptySummary;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;

public class CypherRecordProcessor
implements QueryExecution,
ExecutionResponseListener {
    private final RecordParser<AnyValue> recordParser;
    private final QuerySubscriber subscriber;
    private final StreamIterator<IrResult.Record> recordIterator;
    private final Summary summary;
    private final QueryTimeoutConfig timeoutConfig;
    private final QueryStatusCallback statusCallback;

    public CypherRecordProcessor(RecordParser<AnyValue> recordParser, QuerySubscriber subscriber, QueryTimeoutConfig timeoutConfig, QueryStatusCallback statusCallback) {
        this.recordParser = recordParser;
        this.subscriber = subscriber;
        this.recordIterator = new StreamIterator();
        this.summary = new EmptySummary();
        this.timeoutConfig = timeoutConfig;
        this.statusCallback = statusCallback;
        this.initializeSubscriber();
    }

    private void initializeSubscriber() {
        try {
            this.subscriber.onResult(this.fieldNames().length);
            this.subscriber.onRecord();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public QueryExecutionType executionType() {
        return QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY);
    }

    public ExecutionPlanDescription executionPlanDescription() {
        return this.summary.executionPlanDescription();
    }

    public Iterable<Notification> getNotifications() {
        return this.summary.getNotifications();
    }

    public String[] fieldNames() {
        return this.recordParser.schema().getFieldNames().toArray(new String[0]);
    }

    public void request(long l) throws Exception {
        while (l > 0L && this.recordIterator.hasNext()) {
            IrResult.Record record = (IrResult.Record)this.recordIterator.next();
            List columns = ClassUtils.callExceptionWithDetails(() -> this.recordParser.parseFrom(record), Code.CYPHER_INVALID_RESULT, Map.of("QueryId", this.statusCallback.getQueryLogger().getQueryId()));
            for (int i = 0; i < columns.size(); ++i) {
                this.subscriber.onField(i, (AnyValue)columns.get(i));
            }
            this.subscriber.onRecordCompleted();
            --l;
        }
        if (!this.recordIterator.hasNext()) {
            this.subscriber.onResultCompleted(QueryStatistics.EMPTY);
        }
    }

    public void cancel() {
        this.recordIterator.close();
    }

    public boolean await() throws Exception {
        return this.recordIterator.hasNext();
    }

    @Override
    public void onNext(IrResult.Record record) {
        try {
            this.recordIterator.putData((Object)record);
        }
        catch (InterruptedException e) {
            this.onError(e);
        }
    }

    @Override
    public void onCompleted() {
        try {
            this.recordIterator.finish();
            this.statusCallback.onSuccessEnd();
        }
        catch (InterruptedException e) {
            this.onError(e);
        }
    }

    @Override
    public void onError(Throwable t) {
        Exception executionException = ClassUtils.handleExecutionException(t, this.timeoutConfig);
        if (executionException instanceof FrontendException) {
            ((FrontendException)executionException).getDetails().put("QueryId", this.statusCallback.getQueryLogger().getQueryId());
        }
        this.recordIterator.fail((Throwable)executionException);
        this.statusCallback.onErrorEnd(executionException, executionException.getMessage());
    }
}

