/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.service;

import com.alibaba.graphscope.common.client.ExecutionClient;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.common.ir.tools.QueryCache;
import com.alibaba.graphscope.common.ir.tools.QueryIdGenerator;
import com.alibaba.graphscope.common.manager.IrMetaQueryCallback;
import com.alibaba.graphscope.cypher.executor.GraphQueryExecutor;
import com.alibaba.graphscope.gremlin.Utils;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.cache.ExecutorBasedCaffeineCacheFactory;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.planner.spi.ProcedureSignatureResolver;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.fabric.bookmark.TransactionBookmarkManagerFactory;
import org.neo4j.fabric.bootstrap.FabricServicesBootstrap;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.eval.CatalogManager;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.FabricDatabaseAccess;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.fabric.executor.FabricLocalExecutor;
import org.neo4j.fabric.executor.FabricRemoteExecutor;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.pipeline.SignatureResolver;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.FabricTransactionMonitor;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitorScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.MonitoredJobExecutor;
import org.neo4j.time.SystemNanoClock;

public class CypherQueryServiceBootstrap
extends FabricServicesBootstrap.Community {
    private final Config config;
    private final FabricConfig fabricConfig;
    private final LogService logService;
    private final AvailabilityGuard availabilityGuard;
    private final AbstractSecurityLog securityLog;

    public CypherQueryServiceBootstrap(LifeSupport lifeSupport, Dependencies dependencies, LogService logService) {
        super(lifeSupport, dependencies, logService);
        this.logService = logService;
        this.config = (Config)Utils.getFieldValue(FabricServicesBootstrap.class, (Object)this, "config");
        this.fabricConfig = (FabricConfig)Utils.getFieldValue(FabricServicesBootstrap.class, (Object)this, "fabricConfig");
        this.availabilityGuard = (AvailabilityGuard)Utils.getFieldValue(FabricServicesBootstrap.class, (Object)this, "availabilityGuard");
        this.securityLog = (AbstractSecurityLog)Utils.getFieldValue(FabricServicesBootstrap.class, (Object)this, "securityLog");
    }

    public void bootstrapServices() {
        LogProvider internalLogProvider = this.logService.getInternalLogProvider();
        DatabaseManager databaseManager = (DatabaseManager)this.resolve(DatabaseManager.class);
        FabricDatabaseManager fabricDatabaseManager = (FabricDatabaseManager)this.register(this.createFabricDatabaseManager(this.fabricConfig), FabricDatabaseManager.class);
        JobScheduler jobScheduler = (JobScheduler)this.resolve(JobScheduler.class);
        Monitors monitors = (Monitors)this.resolve(Monitors.class);
        FabricDatabaseAccess databaseAccess = this.createFabricDatabaseAccess();
        FabricRemoteExecutor remoteExecutor = this.bootstrapRemoteStack();
        FabricLocalExecutor localExecutor = (FabricLocalExecutor)this.register(new FabricLocalExecutor(this.fabricConfig, fabricDatabaseManager, databaseAccess), FabricLocalExecutor.class);
        SystemNanoClock systemNanoClock = (SystemNanoClock)this.resolve(SystemNanoClock.class);
        FabricTransactionMonitor transactionMonitor = new FabricTransactionMonitor(systemNanoClock, this.logService, this.fabricConfig);
        long transactionCheckInterval = ((Duration)this.config.get(GraphDatabaseSettings.transaction_monitor_check_interval)).toMillis();
        this.register(new TransactionMonitorScheduler((TransactionMonitor)transactionMonitor, jobScheduler, transactionCheckInterval, null), TransactionMonitorScheduler.class);
        ErrorReporter errorReporter = new ErrorReporter(this.logService);
        this.register(new TransactionManager(remoteExecutor, localExecutor, errorReporter, this.fabricConfig, transactionMonitor, this.securityLog, (Clock)systemNanoClock, this.config, this.availabilityGuard), TransactionManager.class);
        CypherConfiguration cypherConfig = CypherConfiguration.fromConfig((Config)this.config);
        Supplier<GlobalProcedures> proceduresSupplier = () -> (GlobalProcedures)this.resolve(GlobalProcedures.class);
        CatalogManager catalogManager = (CatalogManager)this.register(this.createCatalogManger((DatabaseIdRepository)databaseManager.databaseIdRepository()), CatalogManager.class);
        SignatureResolver signatureResolver = new SignatureResolver(proceduresSupplier);
        FabricStatementLifecycles statementLifecycles = new FabricStatementLifecycles(databaseManager, monitors, this.config, systemNanoClock);
        MonitoredJobExecutor monitoredExecutor = jobScheduler.monitoredJobExecutor(Group.CYPHER_CACHE);
        ExecutorBasedCaffeineCacheFactory cacheFactory = new ExecutorBasedCaffeineCacheFactory(job -> monitoredExecutor.execute(JobMonitoringParams.systemJob((String)"Query plan cache maintenance"), job));
        FabricPlanner planner = (FabricPlanner)this.register(new FabricPlanner(this.fabricConfig, cypherConfig, monitors, (CaffeineCacheFactory)cacheFactory, (ProcedureSignatureResolver)signatureResolver), FabricPlanner.class);
        UseEvaluation useEvaluation = (UseEvaluation)this.register(new UseEvaluation(catalogManager, proceduresSupplier, (ProcedureSignatureResolver)signatureResolver), UseEvaluation.class);
        CallableExecutor fabricWorkerExecutor = jobScheduler.executor(Group.FABRIC_WORKER);
        Configs graphConfig = (Configs)this.resolve(Configs.class);
        QueryIdGenerator idGenerator = (QueryIdGenerator)this.resolve(QueryIdGenerator.class);
        IrMetaQueryCallback metaQueryCallback = (IrMetaQueryCallback)this.resolve(IrMetaQueryCallback.class);
        ExecutionClient executionClient = (ExecutionClient)this.resolve(ExecutionClient.class);
        QueryCache queryCache = (QueryCache)this.resolve(QueryCache.class);
        GraphPlanner graphPlanner = (GraphPlanner)this.resolve(GraphPlanner.class);
        GraphQueryExecutor fabricExecutor = new GraphQueryExecutor(this.fabricConfig, planner, useEvaluation, catalogManager, internalLogProvider, statementLifecycles, (Executor)fabricWorkerExecutor, graphConfig, idGenerator, metaQueryCallback, executionClient, queryCache, graphPlanner);
        this.register((Object)fabricExecutor, FabricExecutor.class);
        this.register(new TransactionBookmarkManagerFactory(fabricDatabaseManager), TransactionBookmarkManagerFactory.class);
    }
}

