/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.antlr4x.visitor;

import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.alibaba.graphscope.grammar.GremlinGSBaseVisitor;
import com.alibaba.graphscope.grammar.GremlinGSParser;
import com.alibaba.graphscope.gremlin.antlr4.TraversalEnumParser;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.LiteralList;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.LiteralVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.NestedTraversalRexVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.PathFunctionVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.Utils;
import com.alibaba.graphscope.gremlin.exception.UnsupportedEvalException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.tinkerpop.gremlin.structure.T;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExpressionVisitor
extends GremlinGSBaseVisitor<RexNode> {
    protected final RexNode propertyKey;
    protected final GraphBuilder builder;
    protected final boolean throwsOnPropertyNotFound;
    public static final int SIMPLE_PREDICATE_CHILD_COUNT = 1;
    public static final int CONNECTIVE_PREDICATE_CHILD_COUNT = 6;

    public ExpressionVisitor(GraphBuilder builder, RexNode propertyKey) {
        this(builder, propertyKey, true);
    }

    public ExpressionVisitor(GraphBuilder builder, RexNode propertyKey, boolean throwsOnPropertyNotFound) {
        this.builder = Objects.requireNonNull(builder);
        this.propertyKey = Objects.requireNonNull(propertyKey);
        this.throwsOnPropertyNotFound = throwsOnPropertyNotFound;
    }

    @Override
    public RexNode visitTraversalMethod_valueMap(GremlinGSParser.TraversalMethod_valueMapContext ctx) {
        List<String> ctxProperties = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(String.class);
        if (this.isPathFunction(ctxProperties)) {
            return new PathFunctionVisitor(this.builder, this.propertyKey).visitTraversalMethod_valueMap(ctx);
        }
        String tag = this.getPropertyTag();
        return this.builder.call(GraphStdOperatorTable.MAP_VALUE_CONSTRUCTOR, this.getProperties(ctxProperties, tag).stream().flatMap(k -> Stream.of(new RexNode[]{this.builder.literal(k), this.builder.variable(tag, (String)k)})).collect(Collectors.toList()));
    }

    @Override
    public RexNode visitTraversalMethod_values(GremlinGSParser.TraversalMethod_valuesContext ctx) {
        ArrayList ctxProperties = Lists.newArrayList((Object[])new String[]{(String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral())});
        if (this.isPathFunction(ctxProperties)) {
            return new PathFunctionVisitor(this.builder, this.propertyKey).visitTraversalMethod_values(ctx);
        }
        String tag = this.getPropertyTag();
        List<String> properties = this.getProperties(ctxProperties, tag);
        return properties.isEmpty() ? null : this.builder.variable(tag, properties.get(0));
    }

    @Override
    public RexNode visitTraversalMethod_elementMap(GremlinGSParser.TraversalMethod_elementMapContext ctx) {
        List<String> ctxProperties = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(String.class);
        if (this.isPathFunction(ctxProperties)) {
            return new PathFunctionVisitor(this.builder, this.propertyKey).visitTraversalMethod_elementMap(ctx);
        }
        String tag = this.getPropertyTag();
        return this.builder.call(GraphStdOperatorTable.MAP_VALUE_CONSTRUCTOR, this.getElementMapProperties(this.getProperties(ctxProperties, tag)).stream().flatMap(k -> Stream.of(new RexNode[]{this.builder.literal(k), this.builder.variable(tag, (String)k)})).collect(Collectors.toList()));
    }

    @Override
    public RexNode visitTraversalMethod_selectby(GremlinGSParser.TraversalMethod_selectbyContext byCtx) {
        int byChildCount = byCtx.getChildCount();
        if (byChildCount == 3) {
            return this.propertyKey;
        }
        String tag = this.getPropertyTag();
        if (byChildCount == 4 && byCtx.StringLiteral() != null) {
            ArrayList ctxProperties = Lists.newArrayList((Object[])new String[]{(String)LiteralVisitor.INSTANCE.visit((ParseTree)byCtx.StringLiteral())});
            if (this.isPathFunction(ctxProperties)) {
                return new PathFunctionVisitor(this.builder, this.propertyKey).visitTraversalMethod_selectby(byCtx);
            }
            List<String> properties = this.getProperties(ctxProperties, tag);
            return properties.isEmpty() ? null : this.builder.variable(tag, properties.get(0));
        }
        if (byChildCount == 4 && byCtx.traversalToken() != null) {
            T token = TraversalEnumParser.parseTraversalEnumFromContext(T.class, byCtx.traversalToken());
            return this.builder.variable(tag, token.getAccessor());
        }
        if (byCtx.traversalMethod_valueMap() != null) {
            return new ExpressionVisitor(this.builder, this.propertyKey).visitTraversalMethod_valueMap(byCtx.traversalMethod_valueMap());
        }
        if (byCtx.traversalMethod_elementMap() != null) {
            return new ExpressionVisitor(this.builder, this.propertyKey).visitTraversalMethod_elementMap(byCtx.traversalMethod_elementMap());
        }
        if (byCtx.nestedTraversal() != null) {
            return (RexNode)Utils.convertExprToPair(new NestedTraversalRexVisitor(this.builder, tag, byCtx).visitNestedTraversal(byCtx.nestedTraversal())).getValue0();
        }
        throw new UnsupportedEvalException(GremlinGSParser.TraversalMethod_selectbyContext.class, byCtx.getText() + " is unsupported yet in select");
    }

    private boolean isPathFunction(List<String> ctxProperties) {
        return this.propertyKey.getType() instanceof GraphPathType && ctxProperties.stream().allMatch(k -> !k.equals("~len"));
    }

    private List<String> getProperties(List<String> ctxProperties, @Nullable String tag) {
        if (this.throwsOnPropertyNotFound || ctxProperties.isEmpty()) {
            return ctxProperties.isEmpty() ? this.getAllProperties(tag) : ctxProperties;
        }
        ctxProperties.retainAll(this.getAllProperties(tag));
        return ctxProperties;
    }

    private List<String> getElementMapProperties(List<String> properties) {
        properties.add(0, "~label");
        properties.add(1, "~id");
        return properties;
    }

    private List<String> getAllProperties(@Nullable String tag) {
        RexGraphVariable curVar = this.builder.variable(tag);
        RelDataType dataType = curVar.getType();
        Preconditions.checkArgument((boolean)(dataType instanceof GraphSchemaType), (String)"can not get property from type=", (Object)dataType);
        return dataType.getFieldList().stream().map(k -> k.getName()).collect(Collectors.toList());
    }

    private String getPropertyTag() {
        Preconditions.checkArgument((this.propertyKey instanceof RexGraphVariable && ((RexGraphVariable)this.propertyKey).getProperty() == null ? 1 : 0) != 0, (String)"variable: [%s] cannot denote a start tag", (Object)this.propertyKey);
        return ((RexGraphVariable)this.propertyKey).getName();
    }

    @Override
    public RexNode visitTraversalPredicate(GremlinGSParser.TraversalPredicateContext ctx) {
        switch (ctx.getChildCount()) {
            case 1: {
                return (RexNode)this.visitChildren((RuleNode)ctx);
            }
            case 6: {
                int childIndexOfParameterOperator = 2;
                boolean childIndexOfCaller = false;
                int childIndexOfArgument = 4;
                if (ctx.getChild(2).getText().equals("or")) {
                    return this.builder.call((SqlOperator)GraphStdOperatorTable.OR, (RexNode)this.visit(ctx.getChild(0)), (RexNode)this.visit(ctx.getChild(4)));
                }
                return this.builder.call((SqlOperator)GraphStdOperatorTable.AND, (RexNode)this.visit(ctx.getChild(0)), (RexNode)this.visit(ctx.getChild(4)));
            }
        }
        throw new UnsupportedEvalException(((Object)((Object)ctx)).getClass(), "unexpected number of children in TraversalPredicateContext " + ctx.getChildCount());
    }

    @Override
    public RexNode visitTraversalPredicate_eq(GremlinGSParser.TraversalPredicate_eqContext ctx) {
        return this.builder.call((SqlOperator)GraphStdOperatorTable.EQUALS, new RexNode[]{this.propertyKey, this.builder.literal(LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal()))});
    }

    @Override
    public RexNode visitTraversalPredicate_neq(GremlinGSParser.TraversalPredicate_neqContext ctx) {
        return this.builder.call((SqlOperator)GraphStdOperatorTable.NOT_EQUALS, new RexNode[]{this.propertyKey, this.builder.literal(LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal()))});
    }

    @Override
    public RexNode visitTraversalPredicate_lt(GremlinGSParser.TraversalPredicate_ltContext ctx) {
        return this.builder.call((SqlOperator)GraphStdOperatorTable.LESS_THAN, new RexNode[]{this.propertyKey, this.builder.literal(LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal()))});
    }

    @Override
    public RexNode visitTraversalPredicate_lte(GremlinGSParser.TraversalPredicate_lteContext ctx) {
        return this.builder.call((SqlOperator)GraphStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.propertyKey, this.builder.literal(LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal()))});
    }

    @Override
    public RexNode visitTraversalPredicate_gt(GremlinGSParser.TraversalPredicate_gtContext ctx) {
        return this.builder.call((SqlOperator)GraphStdOperatorTable.GREATER_THAN, new RexNode[]{this.propertyKey, this.builder.literal(LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal()))});
    }

    @Override
    public RexNode visitTraversalPredicate_gte(GremlinGSParser.TraversalPredicate_gteContext ctx) {
        return this.builder.call((SqlOperator)GraphStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{this.propertyKey, this.builder.literal(LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal()))});
    }

    @Override
    public RexNode visitTraversalPredicate_within(GremlinGSParser.TraversalPredicate_withinContext ctx) {
        List<Object> points = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(Object.class);
        return this.builder.getRexBuilder().makeIn(this.propertyKey, points.stream().map(k -> this.builder.literal(k)).collect(Collectors.toList()));
    }

    @Override
    public RexNode visitTraversalPredicate_without(GremlinGSParser.TraversalPredicate_withoutContext ctx) {
        List<Object> points = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(Object.class);
        return this.builder.not(this.builder.getRexBuilder().makeIn(this.propertyKey, points.stream().map(k -> this.builder.literal(k)).collect(Collectors.toList())));
    }

    @Override
    public RexNode visitTraversalPredicate_not(GremlinGSParser.TraversalPredicate_notContext ctx) {
        return this.builder.not(this.visitTraversalPredicate(ctx.traversalPredicate()));
    }

    @Override
    public RexNode visitTraversalPredicate_inside(GremlinGSParser.TraversalPredicate_insideContext ctx) {
        Number lower = (Number)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal(0));
        Number upper = (Number)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal(1));
        return this.builder.getRexBuilder().makeBetween(this.propertyKey, (RexNode)this.builder.literal(new BigDecimal(lower.longValue() + 1L)), (RexNode)this.builder.literal(new BigDecimal(upper.longValue() - 1L)));
    }

    @Override
    public RexNode visitTraversalPredicate_outside(GremlinGSParser.TraversalPredicate_outsideContext ctx) {
        Number lower = (Number)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal(0));
        Number upper = (Number)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal(1));
        return this.builder.not(this.builder.getRexBuilder().makeBetween(this.propertyKey, (RexNode)this.builder.literal(new BigDecimal(lower.longValue() + 1L)), (RexNode)this.builder.literal(new BigDecimal(upper.longValue() - 1L))));
    }

    @Override
    public RexNode visitTraversalPredicate_startingWith(GremlinGSParser.TraversalPredicate_startingWithContext ctx) {
        String posixRegex = "^" + LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral()) + ".*";
        return this.builder.call(GraphStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE, new RexNode[]{this.propertyKey, this.builder.literal(posixRegex)});
    }

    @Override
    public RexNode visitTraversalPredicate_notStartingWith(GremlinGSParser.TraversalPredicate_notStartingWithContext ctx) {
        String posixRegex = "^" + LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral()) + ".*";
        return this.builder.not(this.builder.call(GraphStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE, new RexNode[]{this.propertyKey, this.builder.literal(posixRegex)}));
    }

    @Override
    public RexNode visitTraversalPredicate_endingWith(GremlinGSParser.TraversalPredicate_endingWithContext ctx) {
        String posixRegex = ".*" + LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral()) + "$";
        return this.builder.call(GraphStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE, new RexNode[]{this.propertyKey, this.builder.literal(posixRegex)});
    }

    @Override
    public RexNode visitTraversalPredicate_notEndingWith(GremlinGSParser.TraversalPredicate_notEndingWithContext ctx) {
        String posixRegex = ".*" + LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral()) + "$";
        return this.builder.not(this.builder.call(GraphStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE, new RexNode[]{this.propertyKey, this.builder.literal(posixRegex)}));
    }

    @Override
    public RexNode visitTraversalPredicate_containing(GremlinGSParser.TraversalPredicate_containingContext ctx) {
        String posixRegex = ".*" + LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral()) + ".*";
        return this.builder.call(GraphStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE, new RexNode[]{this.propertyKey, this.builder.literal(posixRegex)});
    }

    @Override
    public RexNode visitTraversalPredicate_notContaining(GremlinGSParser.TraversalPredicate_notContainingContext ctx) {
        String posixRegex = ".*" + LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral()) + ".*";
        return this.builder.not(this.builder.call(GraphStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE, new RexNode[]{this.propertyKey, this.builder.literal(posixRegex)}));
    }
}

