/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.antlr4x.visitor;

import com.alibaba.graphscope.grammar.GremlinGSParser;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.LiteralVisitor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.ObjectUtils;

public class LiteralList {
    private final GremlinGSParser.OC_ListLiteralContext literalCtx;
    private final List<GremlinGSParser.OC_ExpressionContext> exprCtxList;

    public LiteralList(GremlinGSParser.OC_ListLiteralContext literalCtx, List<GremlinGSParser.OC_ExpressionContext> exprCtxList) {
        this.literalCtx = literalCtx;
        this.exprCtxList = exprCtxList;
    }

    public boolean isEmpty() {
        return this.literalCtx == null && ObjectUtils.isEmpty(this.exprCtxList);
    }

    public <T> List<T> toList(Class<T> clazz) {
        ArrayList literals = Lists.newArrayList();
        if (this.literalCtx != null) {
            List objs = (List)LiteralVisitor.INSTANCE.visit((ParseTree)this.literalCtx);
            literals.addAll(objs.stream().map(clazz::cast).collect(Collectors.toList()));
        } else if (ObjectUtils.isNotEmpty(this.exprCtxList)) {
            for (GremlinGSParser.OC_ExpressionContext exprCtx : this.exprCtxList) {
                if (exprCtx == null) continue;
                Object value = LiteralVisitor.INSTANCE.visit((ParseTree)exprCtx);
                Preconditions.checkArgument((boolean)clazz.isInstance(value), (Object)("value type [" + value.getClass() + "] mismatch with the expected type [" + clazz + "]"));
                literals.add(clazz.cast(value));
            }
        }
        return literals;
    }
}

