/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.antlr4x.visitor;

import com.alibaba.graphscope.grammar.GremlinGSBaseVisitor;
import com.alibaba.graphscope.grammar.GremlinGSParser;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.text.StringEscapeUtils;

public class LiteralVisitor
extends GremlinGSBaseVisitor<Object> {
    public static final LiteralVisitor INSTANCE = new LiteralVisitor();

    private LiteralVisitor() {
    }

    @Override
    public Object visitOC_BooleanLiteral(GremlinGSParser.OC_BooleanLiteralContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Object visitOC_IntegerLiteral(GremlinGSParser.OC_IntegerLiteralContext ctx) {
        Object integerLiteral = ctx.getText().toLowerCase();
        try {
            if (((String)integerLiteral).endsWith("l")) {
                integerLiteral = ((String)integerLiteral).substring(0, ((String)integerLiteral).length() - 1);
                return Long.decode((String)integerLiteral);
            }
            return Integer.decode((String)integerLiteral);
        }
        catch (NumberFormatException ignoredExpection1) {
            try {
                return Long.decode((String)integerLiteral);
            }
            catch (NumberFormatException ignoredExpection2) {
                boolean negative;
                int startIndex = 0;
                char firstChar = ((String)integerLiteral).charAt(0);
                boolean bl = negative = firstChar == '-';
                if (firstChar == '-' || firstChar == '+') {
                    ++startIndex;
                }
                int radix = 10;
                if (((String)integerLiteral).charAt(startIndex + 1) == 'x') {
                    radix = 16;
                    integerLiteral = ((String)integerLiteral).substring(startIndex += 2);
                    if (negative) {
                        integerLiteral = "-" + (String)integerLiteral;
                    }
                } else if (((String)integerLiteral).charAt(startIndex) == '0') {
                    radix = 8;
                }
                return new BigInteger((String)integerLiteral, radix);
            }
        }
    }

    @Override
    public Object visitOC_DoubleLiteral(GremlinGSParser.OC_DoubleLiteralContext ctx) {
        return Double.valueOf(ctx.getText());
    }

    public Object visitTerminal(TerminalNode node) {
        switch (node.getSymbol().getType()) {
            case 193: {
                return StringEscapeUtils.unescapeJava((String)this.stripQuotes(node.getText()));
            }
            case 152: {
                return null;
            }
        }
        throw new UnsupportedOperationException("terminal node type " + node.getSymbol() + " is unsupported yet");
    }

    @Override
    public Object visitOC_ListLiteral(GremlinGSParser.OC_ListLiteralContext ctx) {
        return ctx.oC_Expression().stream().map(arg_0 -> ((LiteralVisitor)this).visit(arg_0)).collect(Collectors.toList());
    }

    @Override
    public Object visitOC_UnaryAddOrSubtractExpression(GremlinGSParser.OC_UnaryAddOrSubtractExpressionContext ctx) {
        Object value = this.visit((ParseTree)ctx.oC_ListOperatorExpression());
        if (ctx.getChildCount() > 0 && ctx.getChild(0) instanceof TerminalNode && ctx.getChild(0).getText().equals("-")) {
            Preconditions.checkArgument((boolean)(value instanceof Number), (Object)"unary minus can only be applied to number");
            if (value instanceof Integer) {
                value = Math.negateExact((Integer)value);
            } else if (value instanceof Long) {
                value = Math.negateExact((Long)value);
            } else if (value instanceof Double) {
                Double doubleVal = (Double)value;
                if (Double.compare(0.0, doubleVal) == 0 || Double.compare(-0.0, doubleVal) == 0) {
                    return 0.0;
                }
                if (Double.isInfinite(doubleVal) || Double.isNaN(doubleVal)) {
                    throw new ArithmeticException("double overflow");
                }
                value = -doubleVal.doubleValue();
            } else if (value instanceof Float) {
                Float floatVal = (Float)value;
                if (Float.compare(0.0f, floatVal.floatValue()) == 0 || Float.compare(-0.0f, floatVal.floatValue()) == 0) {
                    return Float.valueOf(0.0f);
                }
                if (Float.isInfinite(floatVal.floatValue()) || Double.isNaN(floatVal.floatValue())) {
                    throw new ArithmeticException("float overflow");
                }
                value = Float.valueOf(-floatVal.floatValue());
            } else if (value instanceof BigInteger) {
                value = ((BigInteger)value).negate();
            } else if (value instanceof BigDecimal) {
                value = ((BigDecimal)value).negate();
            } else {
                throw new UnsupportedOperationException("unsupported number type " + value.getClass() + " in unary minus operator");
            }
        }
        return value;
    }

    private String stripQuotes(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1);
    }
}

