/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.antlr4x.visitor;

import com.alibaba.graphscope.common.ir.meta.schema.CommonOptTable;
import com.alibaba.graphscope.common.ir.rel.CommonTableScan;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.grammar.GremlinGSBaseVisitor;
import com.alibaba.graphscope.grammar.GremlinGSParser;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.GraphBuilderVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.LiteralVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.SubQueryChecker;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.TraversalMethodIterator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.function.Predicate;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NestedTraversalRexVisitor
extends GremlinGSBaseVisitor<RexNode> {
    private final GraphBuilder parentBuilder;
    private final GraphBuilder nestedBuilder;
    private final @Nullable String headAlias;
    private final ParserRuleContext parentCtx;

    public NestedTraversalRexVisitor(GraphBuilder parentBuilder, @Nullable String headAlias, ParserRuleContext parentCtx) {
        this.parentBuilder = parentBuilder;
        this.nestedBuilder = GraphBuilder.create(this.parentBuilder.getContext(), (GraphOptCluster)this.parentBuilder.getCluster(), this.parentBuilder.getRelOptSchema());
        this.headAlias = headAlias;
        this.parentCtx = parentCtx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RexNode visitNestedTraversal(GremlinGSParser.NestedTraversalContext ctx) {
        RexSubQuery expr;
        RelNode relNode = Objects.requireNonNull(this.parentBuilder.peek(), "parentCtx builder should not be empty");
        CommonTableScan commonTableScan = new CommonTableScan(relNode.getCluster(), relNode.getTraitSet(), new CommonOptTable(relNode));
        this.nestedBuilder.push((RelNode)commonTableScan);
        if (this.headAlias != null) {
            this.nestedBuilder.project((Iterable)ImmutableList.of((Object)((Object)this.nestedBuilder.variable(this.headAlias))), (Iterable)ImmutableList.of(), true);
        }
        String tailAlias = null;
        int methodCounter = 0;
        TraversalMethodIterator iterator = new TraversalMethodIterator(ctx);
        while (iterator.hasNext()) {
            GremlinGSParser.TraversalMethodContext cur = iterator.next();
            if (methodCounter != 0 && !iterator.hasNext() && cur.traversalMethod_as() != null) {
                tailAlias = (String)LiteralVisitor.INSTANCE.visit((ParseTree)cur.traversalMethod_as().StringLiteral());
            }
            ++methodCounter;
        }
        TrimAlias trimAlias = new TrimAlias(methodCounter);
        GraphBuilderVisitor visitor = new GraphBuilderVisitor(this.nestedBuilder, trimAlias);
        RelNode subRel = ((GraphBuilder)((Object)visitor.visitNestedTraversal(ctx))).build();
        if (new SubQueryChecker((RelNode)commonTableScan).test(subRel)) {
            if (this.parentCtx instanceof GremlinGSParser.TraversalMethod_whereContext) {
                if (tailAlias != null) {
                    subRel = this.nestedBuilder.push(subRel).filter(this.nestedBuilder.equals((RexNode)this.nestedBuilder.variable(null), (RexNode)this.nestedBuilder.variable(tailAlias))).build();
                    tailAlias = null;
                }
                expr = RexSubQuery.exists((RelNode)subRel);
                return this.nestedBuilder.alias((RexNode)expr, tailAlias);
            } else if (this.parentCtx instanceof GremlinGSParser.TraversalMethod_notContext) {
                expr = this.nestedBuilder.not((RexNode)RexSubQuery.exists((RelNode)subRel));
                return this.nestedBuilder.alias((RexNode)expr, tailAlias);
            } else {
                if (!(this.parentCtx instanceof GremlinGSParser.TraversalMethod_wherebyContext) && !(this.parentCtx instanceof GremlinGSParser.TraversalMethod_selectbyContext) && !(this.parentCtx instanceof GremlinGSParser.TraversalMethod_dedupbyContext) && !(this.parentCtx instanceof GremlinGSParser.TraversalMethod_orderbyContext) && !(this.parentCtx instanceof GremlinGSParser.TraversalMethod_group_keybyContext)) throw new UnsupportedOperationException("unsupported nested traversal in parent: " + this.parentCtx.getText());
                expr = RexSubQuery.scalar((RelNode)subRel);
            }
            return this.nestedBuilder.alias((RexNode)expr, tailAlias);
        } else {
            Project project = (Project)subRel;
            Preconditions.checkArgument((project.getProjects().size() == 1 ? 1 : 0) != 0, (Object)"value returned from sub query should be single value");
            expr = (RexNode)project.getProjects().get(0);
            if (this.parentCtx instanceof GremlinGSParser.TraversalMethod_whereContext) {
                expr = this.nestedBuilder.isNotNull((RexNode)expr);
                return this.nestedBuilder.alias((RexNode)expr, tailAlias);
            } else {
                if (!(this.parentCtx instanceof GremlinGSParser.TraversalMethod_notContext)) return this.nestedBuilder.alias((RexNode)expr, tailAlias);
                expr = this.nestedBuilder.isNull((RexNode)expr);
            }
        }
        return this.nestedBuilder.alias((RexNode)expr, tailAlias);
    }

    private class TrimAlias
    implements Predicate<ParseTree> {
        private int methodIdx;
        private final int methodCount;

        public TrimAlias(int methodCount) {
            this.methodCount = methodCount;
            this.methodIdx = 0;
        }

        @Override
        public boolean test(ParseTree parseTree) {
            if (parseTree.getParent() instanceof GremlinGSParser.TraversalMethodContext) {
                boolean toSkip = parseTree instanceof GremlinGSParser.TraversalMethod_asContext && (this.methodIdx == 0 || this.methodIdx == this.methodCount - 1);
                ++this.methodIdx;
                return toSkip;
            }
            return false;
        }
    }
}

