/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.antlr4x.visitor;

import com.alibaba.graphscope.common.ir.meta.schema.CommonOptTable;
import com.alibaba.graphscope.common.ir.rel.CommonTableScan;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.alibaba.graphscope.grammar.GremlinGSBaseVisitor;
import com.alibaba.graphscope.grammar.GremlinGSParser;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.ExpressionVisitor;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;

public class PathFunctionVisitor
extends GremlinGSBaseVisitor<RexNode> {
    private final GraphBuilder parentBuilder;
    private final RexNode variable;
    private final GraphLogicalPathExpand pathExpand;
    private final RelNode innerExpand;
    private final RelNode innerGetV;

    public PathFunctionVisitor(GraphBuilder parentBuilder, RexNode variable) {
        Preconditions.checkArgument((variable instanceof RexGraphVariable && ((RexGraphVariable)variable).getProperty() == null && variable.getType() instanceof GraphPathType ? 1 : 0) != 0, (Object)("variable [" + variable + "] can not denote a path expand"));
        this.parentBuilder = parentBuilder;
        this.variable = variable;
        this.pathExpand = this.getPathExpand(parentBuilder.peek(), variable);
        this.innerExpand = Objects.requireNonNull(this.pathExpand.getExpand(), "expand in path expand can not be null");
        this.innerGetV = Objects.requireNonNull(this.pathExpand.getGetV(), "getV in path expand can not be null");
    }

    private GraphLogicalPathExpand getPathExpand(RelNode top, RexNode variable) {
        int expectedAlias = ((RexGraphVariable)variable).getAliasId();
        ArrayList inputQueue = Lists.newArrayList((Object[])new RelNode[]{top});
        while (!inputQueue.isEmpty()) {
            RelNode cur = (RelNode)inputQueue.remove(0);
            if (cur instanceof GraphLogicalPathExpand && (expectedAlias == -1 || ((GraphLogicalPathExpand)cur).getAliasId() == expectedAlias)) {
                return (GraphLogicalPathExpand)cur;
            }
            if (cur instanceof Project) {
                Project project = (Project)cur;
                RelDataType projectType = project.getRowType();
                for (int i = 0; i < projectType.getFieldList().size(); ++i) {
                    RelDataTypeField field = (RelDataTypeField)projectType.getFieldList().get(i);
                    if (field.getIndex() != expectedAlias) continue;
                    if (i < project.getProjects().size() && project.getProjects().get(i) instanceof RexGraphVariable) {
                        return this.getPathExpand(project.getInput(), (RexNode)project.getProjects().get(i));
                    }
                    break;
                }
            } else {
                if (cur instanceof CommonTableScan) {
                    CommonOptTable optTable = (CommonOptTable)((CommonTableScan)cur).getTable();
                    return this.getPathExpand(optTable.getCommon(), variable);
                }
                if (cur instanceof GraphLogicalSingleMatch) {
                    return this.getPathExpand(((GraphLogicalSingleMatch)cur).getSentence(), variable);
                }
                if (cur instanceof GraphLogicalMultiMatch) {
                    List<RelNode> sentences = ((GraphLogicalMultiMatch)cur).getSentences();
                    for (RelNode sentence : sentences) {
                        try {
                            return this.getPathExpand(sentence, variable);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
            }
            if (AliasInference.removeAlias(cur)) break;
            inputQueue.addAll(cur.getInputs());
        }
        throw new IllegalArgumentException("can not find path expand by variable " + variable);
    }

    @Override
    public RexNode visitTraversalMethod_valueMap(GremlinGSParser.TraversalMethod_valueMapContext ctx) {
        GraphBuilder builder = GraphBuilder.create(this.parentBuilder.getContext(), (GraphOptCluster)this.parentBuilder.getCluster(), this.parentBuilder.getRelOptSchema());
        GraphOpt.PathExpandFunction funcOpt = this.getFuncOpt();
        boolean throwsOnPropertyNotFound = funcOpt != GraphOpt.PathExpandFunction.VERTEX_EDGE;
        RexNode propertyProjection = this.propertyProjection((Supplier<RexNode>)((Supplier)() -> new ExpressionVisitor(builder.push(this.innerExpand), (RexNode)builder.variable(null), throwsOnPropertyNotFound).visitTraversalMethod_valueMap(ctx)), (Supplier<RexNode>)((Supplier)() -> new ExpressionVisitor(builder.push(this.innerGetV), (RexNode)builder.variable(null), throwsOnPropertyNotFound).visitTraversalMethod_valueMap(ctx)), builder);
        return builder.call(GraphStdOperatorTable.PATH_FUNCTION, new RexNode[]{this.variable, builder.getRexBuilder().makeFlag((Enum)funcOpt), propertyProjection});
    }

    @Override
    public RexNode visitTraversalMethod_values(GremlinGSParser.TraversalMethod_valuesContext ctx) {
        GraphBuilder builder = GraphBuilder.create(this.parentBuilder.getContext(), (GraphOptCluster)this.parentBuilder.getCluster(), this.parentBuilder.getRelOptSchema());
        GraphOpt.PathExpandFunction funcOpt = this.getFuncOpt();
        boolean throwsOnPropertyNotFound = funcOpt != GraphOpt.PathExpandFunction.VERTEX_EDGE;
        RexNode propertyProjection = this.propertyProjection((Supplier<RexNode>)((Supplier)() -> new ExpressionVisitor(builder.push(this.innerExpand), (RexNode)builder.variable(null), throwsOnPropertyNotFound).visitTraversalMethod_values(ctx)), (Supplier<RexNode>)((Supplier)() -> new ExpressionVisitor(builder.push(this.innerGetV), (RexNode)builder.variable(null), throwsOnPropertyNotFound).visitTraversalMethod_values(ctx)), builder);
        return builder.call(GraphStdOperatorTable.PATH_FUNCTION, new RexNode[]{this.variable, builder.getRexBuilder().makeFlag((Enum)funcOpt), propertyProjection});
    }

    @Override
    public RexNode visitTraversalMethod_elementMap(GremlinGSParser.TraversalMethod_elementMapContext ctx) {
        GraphBuilder builder = GraphBuilder.create(this.parentBuilder.getContext(), (GraphOptCluster)this.parentBuilder.getCluster(), this.parentBuilder.getRelOptSchema());
        GraphOpt.PathExpandFunction funcOpt = this.getFuncOpt();
        boolean throwsOnPropertyNotFound = funcOpt != GraphOpt.PathExpandFunction.VERTEX_EDGE;
        RexNode propertyProjection = this.propertyProjection((Supplier<RexNode>)((Supplier)() -> new ExpressionVisitor(builder.push(this.innerExpand), (RexNode)builder.variable(null), throwsOnPropertyNotFound).visitTraversalMethod_elementMap(ctx)), (Supplier<RexNode>)((Supplier)() -> new ExpressionVisitor(builder.push(this.innerGetV), (RexNode)builder.variable(null), throwsOnPropertyNotFound).visitTraversalMethod_elementMap(ctx)), builder);
        return builder.call(GraphStdOperatorTable.PATH_FUNCTION, new RexNode[]{this.variable, builder.getRexBuilder().makeFlag((Enum)funcOpt), propertyProjection});
    }

    @Override
    public RexNode visitTraversalMethod_selectby(GremlinGSParser.TraversalMethod_selectbyContext ctx) {
        GraphBuilder builder = GraphBuilder.create(this.parentBuilder.getContext(), (GraphOptCluster)this.parentBuilder.getCluster(), this.parentBuilder.getRelOptSchema());
        GraphOpt.PathExpandFunction funcOpt = this.getFuncOpt();
        boolean throwsOnPropertyNotFound = funcOpt != GraphOpt.PathExpandFunction.VERTEX_EDGE;
        RexNode propertyProjection = this.propertyProjection((Supplier<RexNode>)((Supplier)() -> new ExpressionVisitor(builder.push(this.innerExpand), (RexNode)builder.variable(null), throwsOnPropertyNotFound).visitTraversalMethod_selectby(ctx)), (Supplier<RexNode>)((Supplier)() -> new ExpressionVisitor(builder.push(this.innerGetV), (RexNode)builder.variable(null), throwsOnPropertyNotFound).visitTraversalMethod_selectby(ctx)), builder);
        return builder.call(GraphStdOperatorTable.PATH_FUNCTION, new RexNode[]{this.variable, builder.getRexBuilder().makeFlag((Enum)funcOpt), propertyProjection});
    }

    private RexNode propertyProjection(Supplier<RexNode> expandSupplier, Supplier<RexNode> getVSupplier, GraphBuilder builder) {
        GraphOpt.PathExpandFunction funcOpt = this.getFuncOpt();
        switch (funcOpt) {
            case VERTEX: {
                return (RexNode)getVSupplier.get();
            }
            case EDGE: {
                return (RexNode)expandSupplier.get();
            }
        }
        RexNode expandProjection = (RexNode)expandSupplier.get();
        RexNode getVProjection = (RexNode)getVSupplier.get();
        return this.unionProjection(expandProjection, getVProjection, builder);
    }

    private RexNode unionProjection(RexNode expandProjection, RexNode getVProjection, GraphBuilder builder) {
        if (expandProjection == null || getVProjection == null) {
            Preconditions.checkArgument((expandProjection != null || getVProjection != null ? 1 : 0) != 0, (Object)"invalid query given properties, not found in path expand");
            return expandProjection != null ? expandProjection : getVProjection;
        }
        Preconditions.checkArgument((expandProjection.getKind() == getVProjection.getKind() ? 1 : 0) != 0, (Object)("expand projection [" + expandProjection + "] is not consistent with getV projection [" + getVProjection + "]"));
        if (expandProjection instanceof RexCall) {
            RexCall expandCall = (RexCall)expandProjection;
            RexCall getVCall = (RexCall)getVProjection;
            ArrayList newOperands = Lists.newArrayList((Iterable)expandCall.getOperands());
            newOperands.addAll(getVCall.getOperands());
            Preconditions.checkArgument((!newOperands.isEmpty() ? 1 : 0) != 0, (Object)"invalid query given properties, not found in path expand");
            return builder.call(expandCall.getOperator(), newOperands.stream().distinct().collect(Collectors.toList()));
        }
        return expandProjection;
    }

    private GraphOpt.PathExpandFunction getFuncOpt() {
        switch (this.pathExpand.getResultOpt()) {
            case ALL_V: 
            case END_V: {
                return GraphOpt.PathExpandFunction.VERTEX;
            }
        }
        return GraphOpt.PathExpandFunction.VERTEX_EDGE;
    }
}

