/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.auth;

import com.alibaba.graphscope.common.config.AuthConfig;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.gremlin.auth.AuthManager;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;

public class DefaultAuthManager
implements AuthManager<AuthenticatedUser> {
    private Configs configs;

    public DefaultAuthManager(Configs configs) {
        this.configs = configs;
    }

    @Override
    public AuthenticatedUser authenticate(String userName, String password) throws AuthenticationException {
        String authUserName = AuthConfig.AUTH_USERNAME.get(this.configs);
        String authPassword = AuthConfig.AUTH_PASSWORD.get(this.configs);
        if (!this.requireAuthentication()) {
            return AuthenticatedUser.ANONYMOUS_USER;
        }
        if (!authUserName.equals(userName) || !authPassword.equals(password)) {
            throw new AuthenticationException("user " + userName + " is invalid");
        }
        return new AuthenticatedUser(userName);
    }

    @Override
    public boolean requireAuthentication() {
        String authUserName = AuthConfig.AUTH_USERNAME.get(this.configs);
        String authPassword = AuthConfig.AUTH_PASSWORD.get(this.configs);
        return authUserName != null && !authUserName.isEmpty() && authPassword != null && !authPassword.isEmpty();
    }
}

