/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin;

import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;

public interface MetricsCollector {
    public long getStartMillis();

    public long getElapsedMillis();

    public void stop();

    public static class Cypher
    implements MetricsCollector {
        private final long startMills;
        private long endMills;

        public Cypher(long startMills) {
            this.startMills = startMills;
        }

        @Override
        public void stop() {
            this.endMills = System.currentTimeMillis();
        }

        @Override
        public long getStartMillis() {
            return this.startMills;
        }

        @Override
        public long getElapsedMillis() {
            return this.endMills - this.startMills;
        }
    }

    public static class Gremlin
    implements MetricsCollector {
        private final Timer.Context timeContext;
        private final long startMillis;
        private long elapsedMillis;

        public Gremlin(Timer timer) {
            this.timeContext = timer.time();
            this.startMillis = System.currentTimeMillis();
        }

        @Override
        public long getStartMillis() {
            return this.startMillis;
        }

        @Override
        public long getElapsedMillis() {
            return this.elapsedMillis;
        }

        @Override
        public void stop() {
            this.elapsedMillis = TimeUnit.NANOSECONDS.toMillis(this.timeContext.stop());
        }
    }
}

