/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin;

import com.alibaba.graphscope.gremlin.plugin.MetricsCollector;
import com.alibaba.graphscope.gremlin.plugin.QueryLogger;
import com.alibaba.graphscope.groot.common.constant.LogConstant;
import com.google.gson.JsonObject;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.trace.Span;
import org.checkerframework.checker.nullness.qual.Nullable;

public class QueryStatusCallback {
    private final MetricsCollector metricsCollector;
    private final QueryLogger queryLogger;
    private final @Nullable LongHistogram queryHistogram;
    private final long printThreshold;

    public QueryStatusCallback(MetricsCollector metricsCollector, @Nullable LongHistogram histogram, QueryLogger queryLogger, long printThreshold) {
        this.metricsCollector = metricsCollector;
        this.queryLogger = queryLogger;
        this.queryHistogram = histogram;
        this.printThreshold = printThreshold;
    }

    public void onStart() {
    }

    public void onErrorEnd(@Nullable String msg) {
        this.metricsCollector.stop();
        this.onErrorEnd(null, msg);
    }

    public void onErrorEnd(@Nullable Throwable t) {
        this.metricsCollector.stop();
        this.onErrorEnd(t, null);
    }

    public void onErrorEnd(Throwable t, String msg) {
        String errorMsg = msg;
        if (t != null) {
            errorMsg = t.getMessage();
        }
        JsonObject logJson = this.buildSimpleLog(false, this.metricsCollector.getElapsedMillis());
        this.fillLogDetail(logJson, errorMsg, this.metricsCollector.getStartMillis());
        this.queryLogger.print(logJson.toString(), false, t);
        Attributes attrs = Attributes.builder().put("id", this.queryLogger.getQueryId().toString()).put("query", this.queryLogger.getQuery()).put("success", false).put("message", msg != null ? msg : "").build();
        if (this.queryHistogram != null) {
            this.queryHistogram.record(this.metricsCollector.getElapsedMillis(), attrs);
        }
        this.queryLogger.metricsInfo(false, this.metricsCollector.getElapsedMillis());
    }

    public void onSuccessEnd() {
        this.metricsCollector.stop();
        this.queryLogger.info("total execution time is {} ms", this.metricsCollector.getElapsedMillis());
        JsonObject logJson = this.buildSimpleLog(true, this.metricsCollector.getElapsedMillis());
        this.fillLogDetail(logJson, null);
        this.queryLogger.print(logJson.toString(), true, null);
        Attributes attrs = Attributes.builder().put("id", this.queryLogger.getQueryId().toString()).put("query", this.queryLogger.getQuery()).put("success", true).put("message", "").build();
        if (this.queryHistogram != null) {
            this.queryHistogram.record(this.metricsCollector.getElapsedMillis(), attrs);
        }
        this.queryLogger.metricsInfo(true, this.metricsCollector.getElapsedMillis());
    }

    private JsonObject buildSimpleLog(boolean isSucceed, long elapsedMillis) {
        String traceId = Span.current().getSpanContext().getTraceId();
        JsonObject simpleJson = new JsonObject();
        simpleJson.addProperty(LogConstant.TRACE_ID, traceId);
        simpleJson.addProperty(LogConstant.QUERY_ID, (Number)this.queryLogger.getQueryId());
        simpleJson.addProperty(LogConstant.SUCCESS, Boolean.valueOf(isSucceed));
        if (this.queryLogger.getUpstreamId() != null) {
            simpleJson.addProperty(LogConstant.UPSTREAM_ID, this.queryLogger.getUpstreamId());
        }
        simpleJson.addProperty(LogConstant.COST, (Number)elapsedMillis);
        return simpleJson;
    }

    private void fillLogDetail(JsonObject logJson, String errorMsg) {
        try {
            if (this.metricsCollector.getElapsedMillis() > this.printThreshold) {
                this.fillLogDetail(logJson, errorMsg, this.metricsCollector.getStartMillis());
            }
        }
        catch (Throwable t) {
            this.queryLogger.warn("fill log detail error", t);
        }
    }

    private void fillLogDetail(JsonObject logJson, String errorMessage, long startMillis) {
        logJson.addProperty(LogConstant.QUERY, this.queryLogger.getQuery());
        if (errorMessage != null) {
            logJson.addProperty(LogConstant.ERROR_MESSAGE, errorMessage);
        }
        logJson.addProperty(LogConstant.IR_PLAN, this.queryLogger.getIrPlan());
        logJson.addProperty(LogConstant.STAGE, "java");
        logJson.addProperty(LogConstant.START_TIME, (Number)startMillis);
    }

    public QueryLogger getQueryLogger() {
        return this.queryLogger;
    }
}

