/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin.processor;

import com.alibaba.graphscope.common.client.ExecutionClient;
import com.alibaba.graphscope.common.client.type.ExecutionRequest;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.QueryTimeoutConfig;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.common.ir.tools.QueryCache;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.plugin.QueryStatusCallback;
import com.alibaba.graphscope.gremlin.resultx.GremlinRecordParser;
import com.alibaba.graphscope.gremlin.resultx.GremlinResultProcessor;
import com.alibaba.graphscope.gremlin.resultx.ResultSchema;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.Context;

public class LifeCycleSupplier
implements Supplier<GremlinExecutor.LifeCycle> {
    private final Configs configs;
    private final QueryCache queryCache;
    private final GraphPlanner graphPlanner;
    private final ExecutionClient client;
    private final Context ctx;
    private final BigInteger queryId;
    private final String queryName;
    private final IrMeta meta;
    private final QueryStatusCallback statusCallback;
    private final QueryTimeoutConfig timeoutConfig;

    public LifeCycleSupplier(Configs configs, Context ctx, QueryCache queryCache, GraphPlanner graphPlanner, ExecutionClient client, BigInteger queryId, String queryName, IrMeta meta, QueryStatusCallback statusCallback, QueryTimeoutConfig timeoutConfig) {
        this.configs = configs;
        this.ctx = ctx;
        this.queryCache = queryCache;
        this.graphPlanner = graphPlanner;
        this.client = client;
        this.queryId = queryId;
        this.queryName = queryName;
        this.meta = meta;
        this.statusCallback = statusCallback;
        this.timeoutConfig = timeoutConfig;
    }

    @Override
    public GremlinExecutor.LifeCycle get() {
        return GremlinExecutor.LifeCycle.build().evaluationTimeoutOverride(Long.valueOf(this.timeoutConfig.getExecutionTimeoutMS())).beforeEval(b -> {
            b.put("graph.query.cache", (Object)this.queryCache);
            b.put("graph.planner", (Object)this.graphPlanner);
            b.put("graph.meta", (Object)this.meta);
        }).withResult(o -> {
            try {
                Preconditions.checkArgument((boolean)(o instanceof QueryCache.Value), (String)"input of 'withResult' is invalid, expect type=%s, actual type=%s", QueryCache.Value.class, o.getClass());
                QueryCache.Value value = (QueryCache.Value)o;
                GraphPlanner.Summary summary = value.summary;
                this.statusCallback.getQueryLogger().debug("ir plan {}", summary.getPhysicalPlan().explain());
                ResultSchema resultSchema = new ResultSchema(summary.getLogicalPlan());
                GremlinResultProcessor listener = new GremlinResultProcessor(this.configs, this.ctx, new GremlinRecordParser(resultSchema), resultSchema, this.statusCallback, this.timeoutConfig);
                if (value.result != null && value.result.isCompleted) {
                    List<IrResult.Results> records = value.result.records;
                    records.forEach(k -> listener.onNext(k.getRecord()));
                    listener.onCompleted();
                } else {
                    this.client.submit(new ExecutionRequest(this.queryId, this.queryName, summary.getLogicalPlan(), summary.getPhysicalPlan()), listener, this.timeoutConfig);
                }
                listener.request();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).create();
    }
}

