/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin.step;

import com.alibaba.graphscope.common.jna.type.PathOpt;
import com.alibaba.graphscope.common.jna.type.ResultOpt;
import com.alibaba.graphscope.gremlin.exception.ExtendGremlinStepException;
import com.alibaba.graphscope.gremlin.plugin.step.ExpandFusionStep;
import com.google.common.base.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PathExpandStep
extends ExpandFusionStep<Vertex> {
    private Traversal rangeTraversal;
    private PathOpt pathOpt;
    private ResultOpt resultOpt;
    private @Nullable String untilCondition;

    public PathExpandStep(Traversal.Admin traversal, Direction direction, Traversal rangeTraversal, String ... edgeLabels) {
        super(traversal, Vertex.class, direction, edgeLabels);
        this.rangeTraversal = rangeTraversal;
        this.pathOpt = PathOpt.Arbitrary;
        this.resultOpt = ResultOpt.EndV;
    }

    public int getLower() {
        Traversal.Admin admin = this.rangeTraversal.asAdmin();
        if (admin.getSteps().size() == 1 && admin.getStartStep() instanceof RangeGlobalStep) {
            RangeGlobalStep range = (RangeGlobalStep)admin.getStartStep();
            return (int)range.getLowRange();
        }
        throw new ExtendGremlinStepException("rangeTraversal should only have one RangeGlobalStep");
    }

    public int getUpper() {
        Traversal.Admin admin = this.rangeTraversal.asAdmin();
        if (admin.getSteps().size() == 1 && admin.getStartStep() instanceof RangeGlobalStep) {
            RangeGlobalStep range = (RangeGlobalStep)admin.getStartStep();
            return (int)range.getHighRange();
        }
        throw new ExtendGremlinStepException("rangeTraversal should only have one RangeGlobalStep");
    }

    public PathOpt getPathOpt() {
        return this.pathOpt;
    }

    public ResultOpt getResultOpt() {
        return this.resultOpt;
    }

    public @Nullable String getUntilCondition() {
        return this.untilCondition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(Object ... keyValues) {
        String originalKey = (String)keyValues[0];
        String originalVal = (String)keyValues[1];
        String key = this.toCamelCaseInsensitive(originalKey);
        String value = this.toCamelCaseInsensitive(originalVal);
        if (key.equals("PathOpt")) {
            if (!value.equals("Arbitrary") && !value.equals("Simple") && !value.equals("Trail")) throw new ExtendGremlinStepException("value " + originalVal + " is invalid, use ARBITRARY, SIMPLE or TRAIL instead (case insensitive)");
            this.pathOpt = PathOpt.valueOf(value);
            return;
        } else if (key.equals("ResultOpt")) {
            if (!value.equals("AllV") && !value.equals("EndV") && !value.equals("AllVE")) throw new ExtendGremlinStepException("value " + originalVal + " is invalid, use ALL_V, END_V, ALL_V_E instead (case insensitive)");
            this.resultOpt = ResultOpt.valueOf(value);
            return;
        } else {
            if (!key.equals("Until")) throw new ExtendGremlinStepException("key " + originalKey + " is invalid, use PATH_OPT or RESULT_OPT or UNTIL instead (case insensitive)");
            this.untilCondition = (String)ObjectUtils.requireNonEmpty((Object)originalVal);
        }
    }

    private String toCamelCaseInsensitive(String underscore) {
        String[] splits = underscore.split("_");
        Object camelCase = "";
        for (int i = 0; i < splits.length; ++i) {
            String split = splits[i];
            camelCase = (String)camelCase + (String)(split.isEmpty() ? split : Character.toUpperCase(split.charAt(0)) + split.substring(1).toLowerCase());
        }
        return camelCase;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathExpandStep that = (PathExpandStep)((Object)o);
        return Objects.equal((Object)this.rangeTraversal, (Object)that.rangeTraversal) && this.pathOpt == that.pathOpt && this.resultOpt == that.resultOpt;
    }

    @Override
    public String toString() {
        return "PathExpandStep{rangeTraversal=" + this.rangeTraversal + ", pathOpt=" + this.pathOpt + ", resultOpt=" + this.resultOpt + "}";
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.rangeTraversal, this.pathOpt, this.resultOpt});
    }
}

