/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin.traversal;

import com.alibaba.graphscope.gremlin.plugin.traversal.IrCustomizedTraversal;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IrCustomizedTraversalSource
extends GraphTraversalSource {
    private @Nullable Map<String, String> queryConfigs;

    public IrCustomizedTraversalSource(Graph graph, TraversalStrategies traversalStrategies) {
        super(graph, traversalStrategies);
    }

    public IrCustomizedTraversalSource(Graph graph) {
        this(graph, TraversalStrategies.GlobalCache.getStrategies(graph.getClass()));
    }

    public IrCustomizedTraversalSource(RemoteConnection connection) {
        super(connection);
    }

    public IrCustomizedTraversalSource clone() {
        IrCustomizedTraversalSource clone = (IrCustomizedTraversalSource)super.clone();
        clone.queryConfigs = Maps.newHashMap();
        return clone;
    }

    public IrCustomizedTraversal<Vertex, Vertex> V(Object ... vertexIds) {
        this.bytecode.addStep("V", vertexIds);
        IrCustomizedTraversal traversal = new IrCustomizedTraversal(this);
        return (IrCustomizedTraversal)traversal.addStep((Step)new GraphStep(traversal, Vertex.class, true, vertexIds));
    }

    public IrCustomizedTraversal<Edge, Edge> E(Object ... edgesIds) {
        this.bytecode.addStep("E", edgesIds);
        IrCustomizedTraversal traversal = new IrCustomizedTraversal(this);
        return (IrCustomizedTraversal)traversal.addStep((Step)new GraphStep(traversal, Edge.class, true, edgesIds));
    }

    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public String toString() {
        return StringFactory.traversalSourceString((TraversalSource)this);
    }

    public @Nullable Map<String, String> getConfigs() {
        if (this.queryConfigs != null) {
            return Collections.unmodifiableMap(this.queryConfigs);
        }
        return null;
    }

    public void addConfig(String key, Object value) {
        if (this.queryConfigs != null) {
            this.queryConfigs.put(key, String.valueOf(value));
        }
    }
}

