/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.result;

import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.Utils;
import com.alibaba.graphscope.gremlin.exception.GremlinResultParserException;
import com.alibaba.graphscope.gremlin.plugin.step.GroupCountStep;
import com.alibaba.graphscope.gremlin.plugin.step.GroupStep;
import com.alibaba.graphscope.gremlin.result.EmptyValue;
import com.alibaba.graphscope.gremlin.result.GremlinResultParser;
import com.alibaba.graphscope.gremlin.result.ParserUtils;
import com.alibaba.graphscope.gremlin.transform.alias.AliasManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupResultParser
implements GremlinResultParser {
    private static final Logger logger = LoggerFactory.getLogger(GroupResultParser.class);
    private Map<String, KeyValueType> queryGivenAliasTypeMap = new HashMap<String, KeyValueType>();

    public static GroupResultParser create(Step groupStep) {
        return new GroupResultParser(groupStep);
    }

    private GroupResultParser(Step groupStep) {
        List<Object> valueTraversals;
        List<Object> keyTraversals;
        if (Utils.equalClass(groupStep, GroupStep.class)) {
            keyTraversals = ((GroupStep)groupStep).getKeyTraversalList();
            valueTraversals = ((GroupStep)groupStep).getValueTraversalList();
        } else if (Utils.equalClass(groupStep, GroupCountStep.class)) {
            keyTraversals = ((GroupCountStep)groupStep).getKeyTraversalList();
            valueTraversals = ((GroupCountStep)groupStep).getValueTraversalList();
        } else {
            throw new GremlinResultParserException("invalid type " + groupStep.getClass());
        }
        keyTraversals.forEach(k -> {
            Step endStep = k.getEndStep();
            if (!endStep.getLabels().isEmpty()) {
                if (endStep.getLabels().size() > 1) {
                    logger.error("multiple aliases of one object is unsupported, take the first and ignore others");
                }
                String label = (String)endStep.getLabels().iterator().next();
                this.queryGivenAliasTypeMap.put(label, KeyValueType.Key);
            }
        });
        valueTraversals.forEach(v -> {
            Step endStep = v.getEndStep();
            if (!endStep.getLabels().isEmpty()) {
                if (endStep.getLabels().size() > 1) {
                    logger.error("multiple aliases of one object is unsupported, take the first and ignore others");
                }
                String label = (String)endStep.getLabels().iterator().next();
                this.queryGivenAliasTypeMap.put(label, KeyValueType.Value);
            }
        });
    }

    @Override
    public Object parseFrom(IrResult.Results results) {
        ArrayList<Object> groupValue;
        logger.debug("{}", (Object)results);
        IrResult.Record record = results.getRecord();
        ArrayList<Object> keys = new ArrayList<Object>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (IrResult.Column column : record.getColumnsList()) {
            String alias;
            Common.NameOrId columnName = column.getNameOrId();
            if (columnName.getItemCase() != Common.NameOrId.ItemCase.NAME) {
                throw new GremlinResultParserException("column key in group should be ItemCase.NAME");
            }
            Object parseEntry = ParserUtils.parseEntry(column.getEntry());
            if (parseEntry instanceof EmptyValue) {
                parseEntry = null;
            }
            if (AliasManager.isGroupKeysPrefix(alias = columnName.getName()) || this.isKeyType(alias)) {
                keys.add(parseEntry);
                continue;
            }
            values.add(parseEntry);
        }
        ArrayList<Object> groupKey = keys.size() == 1 ? keys.get(0) : keys;
        ArrayList<Object> arrayList = groupValue = values.size() == 1 ? values.get(0) : values;
        if (groupValue == null) {
            return EmptyValue.INSTANCE;
        }
        return Collections.singletonMap(groupKey, groupValue);
    }

    private boolean isKeyType(String queryGivenAlias) {
        KeyValueType type = this.queryGivenAliasTypeMap.get(queryGivenAlias);
        return type != null && type == KeyValueType.Key;
    }

    private static enum KeyValueType {
        Key,
        Value;

    }
}

