/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.result;

import com.alibaba.graphscope.common.jna.type.FfiKeyType;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gremlin.plugin.step.ExpandFusionStep;
import com.alibaba.graphscope.gremlin.result.GremlinResultAnalyzer;
import com.alibaba.graphscope.gremlin.result.ParserUtils;
import com.alibaba.graphscope.gremlin.transform.TraversalParentTransformFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.TokenTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.structure.T;

public abstract class LabelParser {
    public Object parseLabelInProjectResults(Map originalValues, Step step) {
        return this.parseLabel(originalValues, "", step, (Step)EmptyStep.instance());
    }

    public Object parseLabel(Object values, String tag, Object stepOrTraversal, Step parent) {
        if (stepOrTraversal instanceof SelectOneStep || stepOrTraversal instanceof SelectStep) {
            Iterator<Map.Entry<String, Traversal.Admin>> projectIterator = TraversalParentTransformFactory.PROJECT_BY_STEP.getProjectTraversals((TraversalParent)stepOrTraversal).entrySet().iterator();
            Iterator iterator = ((Map)values).entrySet().iterator();
            while (iterator.hasNext() && projectIterator.hasNext()) {
                Map.Entry valuesEntry = iterator.next();
                Map.Entry<String, Traversal.Admin> projectEntry = projectIterator.next();
                Traversal.Admin admin = projectEntry.getValue();
                valuesEntry.setValue(this.parseLabel(valuesEntry.getValue(), projectEntry.getKey(), admin == null || admin.getSteps().isEmpty() ? admin : admin.getEndStep(), (Step)stepOrTraversal));
            }
            return values;
        }
        if (values instanceof Map) {
            for (Map.Entry entry : ((Map)values).entrySet()) {
                if (entry.getValue() instanceof Map) {
                    this.parseLabel(entry.getValue(), tag, stepOrTraversal, parent);
                    continue;
                }
                if (stepOrTraversal instanceof ElementMapStep && !entry.getKey().equals(T.label)) continue;
                entry.setValue(this.parseLabelByType(entry.getValue(), this.getLabelType(tag, stepOrTraversal, parent)));
            }
            return values;
        }
        return this.parseLabelByType(values, this.getLabelType(tag, stepOrTraversal, parent));
    }

    private Object parseLabelByType(Object original, LabelType type) {
        switch (type) {
            case VERTEX_LABEL: {
                return this.parseLabelByFfiType(original, FfiKeyType.Entity);
            }
            case EDGE_LABEL: {
                return this.parseLabelByFfiType(original, FfiKeyType.Relation);
            }
        }
        return original;
    }

    private Object parseLabelByFfiType(Object label, FfiKeyType ffiKeyType) {
        if (label instanceof Number) {
            return ParserUtils.getKeyName(Common.NameOrId.newBuilder().setId(((Number)label).intValue()).build(), ffiKeyType);
        }
        if (label instanceof List) {
            ArrayList parseLabels = Lists.newArrayList();
            for (Object o : (List)label) {
                parseLabels.add(this.parseLabelByFfiType(o, ffiKeyType));
            }
            return parseLabels;
        }
        return label;
    }

    private LabelType getLabelType(String tag, Object traversalOrStep, Step parent) {
        if (!this.containsLabel(traversalOrStep)) {
            return LabelType.NONE;
        }
        EmptyStep tagStep = EmptyStep.instance();
        if (traversalOrStep instanceof Traversal) {
            tagStep = parent;
        } else if (traversalOrStep instanceof Step) {
            tagStep = parent instanceof SelectStep || parent instanceof SelectOneStep ? parent : (Step)traversalOrStep;
        }
        for (tagStep = tagStep.getPreviousStep(); tagStep != EmptyStep.instance(); tagStep = tagStep.getPreviousStep()) {
            if (!ObjectUtils.isEmpty((Object)tag) && !tagStep.getLabels().contains(tag)) continue;
            while (tagStep != EmptyStep.instance() && GremlinResultAnalyzer.isSameInAndOutputType((Step)tagStep)) {
                tagStep = tagStep.getPreviousStep();
            }
            break;
        }
        if (tagStep instanceof GraphStep) {
            return ((GraphStep)tagStep).returnsVertex() ? LabelType.VERTEX_LABEL : LabelType.EDGE_LABEL;
        }
        if (tagStep instanceof ExpandFusionStep) {
            switch (((ExpandFusionStep)tagStep).getExpandOpt()) {
                case Vertex: {
                    return LabelType.VERTEX_LABEL;
                }
                case Edge: {
                    return LabelType.EDGE_LABEL;
                }
            }
            return LabelType.NONE;
        }
        if (tagStep instanceof VertexStep) {
            return ((VertexStep)tagStep).returnsVertex() ? LabelType.VERTEX_LABEL : LabelType.EDGE_LABEL;
        }
        if (tagStep instanceof EdgeVertexStep || tagStep instanceof EdgeOtherVertexStep) {
            return LabelType.VERTEX_LABEL;
        }
        return LabelType.NONE;
    }

    private boolean containsLabel(Object traversalOrStep) {
        return traversalOrStep instanceof TokenTraversal && ((TokenTraversal)traversalOrStep).getToken().equals((Object)T.label) || traversalOrStep instanceof LabelStep || traversalOrStep instanceof ElementMapStep;
    }

    private static enum LabelType {
        VERTEX_LABEL,
        EDGE_LABEL,
        NONE;

    }
}

