/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.result;

import com.alibaba.graphscope.common.jna.type.FfiKeyType;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.exception.GremlinResultParserException;
import com.alibaba.graphscope.gremlin.result.EmptyValue;
import com.alibaba.graphscope.gremlin.result.GremlinResultParser;
import com.alibaba.graphscope.gremlin.result.LabelParser;
import com.alibaba.graphscope.gremlin.result.ParserUtils;
import com.alibaba.graphscope.gremlin.transform.alias.AliasManager;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.structure.T;

public class ProjectResultParser
extends LabelParser
implements GremlinResultParser {
    private final Step step;

    private ProjectResultParser(Step step) {
        this.step = step;
    }

    public static ProjectResultParser create(Step step) {
        return new ProjectResultParser(step);
    }

    @Override
    public Object parseFrom(IrResult.Results results) {
        IrResult.Record record = results.getRecord();
        LinkedHashMap projectResult = new LinkedHashMap();
        record.getColumnsList().forEach(column -> {
            String tag = this.getColumnKeyAsResultKey(column.getNameOrId());
            Object parseEntry = ParserUtils.parseEntry(column.getEntry());
            if (parseEntry instanceof Map) {
                Map projectTags = (Map)parseEntry;
                Map tagEntry = (Map)projectResult.computeIfAbsent(tag, k1 -> new LinkedHashMap());
                tagEntry.putAll(this.flatMap(projectTags));
            } else if (!(parseEntry instanceof EmptyValue)) {
                projectResult.put(tag, parseEntry);
            }
        });
        Map parseLabel = (Map)this.parseLabelInProjectResults(projectResult, this.step);
        if (parseLabel.isEmpty()) {
            return EmptyValue.INSTANCE;
        }
        if (parseLabel.size() == 1) {
            return parseLabel.entrySet().iterator().next().getValue();
        }
        return parseLabel;
    }

    private Map<Object, Object> flatMap(Map<String, Object> map) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String k = entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Map) {
                result.putAll(this.flatMap((Map)v));
                continue;
            }
            if (v instanceof EmptyValue) continue;
            String nameOrId = null;
            if (k instanceof List) {
                nameOrId = (String)((List)((Object)k)).get(1);
            } else if (k instanceof String) {
                nameOrId = k;
            } else if (k instanceof Number) {
                nameOrId = String.valueOf(k);
            }
            if (nameOrId == null || nameOrId.isEmpty()) {
                throw new GremlinResultParserException("map value should have property key");
            }
            String property = this.getPropertyName(nameOrId);
            if (this.step instanceof PropertyMapStep) {
                result.put(property, Collections.singletonList(v));
                continue;
            }
            if (property.equals(T.id.getAccessor())) {
                result.put(T.id, v);
                continue;
            }
            if (property.equals(T.label.getAccessor())) {
                result.put(T.label, v);
                continue;
            }
            result.put(property, v);
        }
        return result;
    }

    private String getColumnKeyAsResultKey(Common.NameOrId columnKey) {
        if (columnKey.getItemCase() == Common.NameOrId.ItemCase.ITEM_NOT_SET) {
            return "";
        }
        switch (columnKey.getItemCase()) {
            case ITEM_NOT_SET: {
                return "";
            }
            case NAME: {
                String key = columnKey.getName();
                return AliasManager.getPrefix(key);
            }
            case ID: {
                return String.valueOf(columnKey.getId());
            }
        }
        throw new GremlinResultParserException(columnKey.getItemCase() + " is invalid");
    }

    private String getPropertyName(String nameOrId) {
        Common.NameOrId.Builder builder = Common.NameOrId.newBuilder();
        if (nameOrId.matches("^[0-9]+$")) {
            builder.setId(Integer.valueOf(nameOrId));
        } else {
            builder.setName(nameOrId);
        }
        return ParserUtils.getKeyName(builder.build(), FfiKeyType.Column);
    }
}

