/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.resultx;

import com.alibaba.graphscope.common.ir.rel.GraphLogicalAggregate;
import com.alibaba.graphscope.common.ir.tools.LogicalPlan;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResultSchema {
    public final RelDataType outputType;
    public final boolean isGroupBy;
    public final int groupKeyCount;

    public ResultSchema(LogicalPlan plan) {
        this.outputType = plan.getOutputType();
        GraphLogicalAggregate aggregate = this.tailAggregate(plan);
        this.isGroupBy = aggregate != null;
        this.groupKeyCount = this.getGroupKeyCount(aggregate);
    }

    private @Nullable GraphLogicalAggregate tailAggregate(LogicalPlan logicalPlan) {
        RelNode top = logicalPlan.getRegularQuery();
        ArrayList queue = Lists.newArrayList((Object[])new RelNode[]{top});
        while (!queue.isEmpty()) {
            RelNode node = (RelNode)queue.remove(0);
            if (!node.getInputs().isEmpty() && node.getInput(0).getRowType().equals(node.getRowType())) {
                queue.addAll(node.getInputs());
                continue;
            }
            if (!(node instanceof GraphLogicalAggregate) || ((GraphLogicalAggregate)node).getAggCalls().isEmpty() || ((GraphLogicalAggregate)node).getGroupKey().groupKeyCount() == 0) continue;
            return (GraphLogicalAggregate)node;
        }
        return null;
    }

    private int getGroupKeyCount(@Nullable GraphLogicalAggregate aggregate) {
        if (aggregate == null) {
            return 0;
        }
        return aggregate.getGroupKey().groupKeyCount();
    }
}

