/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.service;

import com.alibaba.graphscope.common.client.ExecutionClient;
import com.alibaba.graphscope.common.client.channel.ChannelFetcher;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.FrontendConfig;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.common.ir.tools.QueryCache;
import com.alibaba.graphscope.common.ir.tools.QueryIdGenerator;
import com.alibaba.graphscope.common.manager.IrMetaQueryCallback;
import com.alibaba.graphscope.common.manager.RateLimitExecutor;
import com.alibaba.graphscope.gremlin.Utils;
import com.alibaba.graphscope.gremlin.auth.AuthManagerReference;
import com.alibaba.graphscope.gremlin.auth.DefaultAuthManager;
import com.alibaba.graphscope.gremlin.integration.processor.IrTestOpProcessor;
import com.alibaba.graphscope.gremlin.integration.result.GraphProperties;
import com.alibaba.graphscope.gremlin.plugin.processor.IrOpLoader;
import com.alibaba.graphscope.gremlin.plugin.processor.IrStandardOpProcessor;
import com.alibaba.graphscope.gremlin.plugin.traversal.IrCustomizedTraversalSource;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.apache.tinkerpop.gremlin.server.util.ThreadFactoryUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerFactory;

public class IrGremlinServer
implements AutoCloseable {
    private final Configs configs;
    private final QueryCache queryCache;
    private final GraphPlanner graphPlanner;
    private final ExecutionClient executionClient;
    private final ChannelFetcher channelFetcher;
    private final IrMetaQueryCallback metaQueryCallback;
    private final GraphProperties testGraph;
    private GremlinServer gremlinServer;
    private final Settings settings;
    private final Graph graph;
    private final GraphTraversalSource g;
    private final QueryIdGenerator idGenerator;

    public IrGremlinServer(Configs configs, QueryIdGenerator idGenerator, QueryCache queryCache, GraphPlanner graphPlanner, ExecutionClient executionClient, ChannelFetcher channelFetcher, IrMetaQueryCallback metaQueryCallback, GraphProperties testGraph) {
        this.configs = configs;
        this.idGenerator = idGenerator;
        this.queryCache = queryCache;
        this.graphPlanner = graphPlanner;
        this.executionClient = executionClient;
        this.channelFetcher = channelFetcher;
        this.metaQueryCallback = metaQueryCallback;
        this.testGraph = testGraph;
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/gremlin-server.yaml");
        this.settings = Settings.read((InputStream)input);
        this.settings.host = "0.0.0.0";
        int port = FrontendConfig.GREMLIN_SERVER_PORT.get(configs);
        if (port >= 0) {
            this.settings.port = port;
        }
        this.settings.evaluationTimeout = FrontendConfig.QUERY_EXECUTION_TIMEOUT_MS.get(configs).intValue();
        this.graph = TinkerFactory.createModern();
        this.g = (GraphTraversalSource)this.graph.traversal(IrCustomizedTraversalSource.class);
    }

    public void start() throws Exception {
        IrStandardOpProcessor standardProcessor = new IrStandardOpProcessor(this.configs, this.idGenerator, this.queryCache, this.graphPlanner, this.executionClient, this.channelFetcher, this.metaQueryCallback, this.graph, this.g);
        IrOpLoader.addProcessor(standardProcessor.getName(), (OpProcessor)standardProcessor);
        IrTestOpProcessor testProcessor = new IrTestOpProcessor(this.configs, this.idGenerator, this.queryCache, this.graphPlanner, this.executionClient, this.channelFetcher, this.metaQueryCallback, this.graph, this.g, this.testGraph);
        IrOpLoader.addProcessor(testProcessor.getName(), (OpProcessor)testProcessor);
        DefaultAuthManager authManager = new DefaultAuthManager(this.configs);
        AuthManagerReference.setAuthManager(authManager);
        this.gremlinServer = new GremlinServer(this.settings, this.createRateLimitExecutor());
        ServerGremlinExecutor serverGremlinExecutor = (ServerGremlinExecutor)Utils.getFieldValue(GremlinServer.class, this.gremlinServer, "serverGremlinExecutor");
        serverGremlinExecutor.getGraphManager().putGraph("graph", this.graph);
        serverGremlinExecutor.getGraphManager().putTraversalSource("g", (TraversalSource)this.graph.traversal());
        this.gremlinServer.start().join();
    }

    private ExecutorService createRateLimitExecutor() {
        if (this.settings.gremlinPool == 0) {
            this.settings.gremlinPool = Runtime.getRuntime().availableProcessors();
        }
        ThreadFactory threadFactoryGremlin = ThreadFactoryUtil.create((String)"exec-%d");
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(this.settings.maxWorkQueueSize);
        return new RateLimitExecutor(this.configs, this.settings.gremlinPool, this.settings.gremlinPool, 0L, TimeUnit.MILLISECONDS, queue, threadFactoryGremlin, new ThreadPoolExecutor.AbortPolicy());
    }

    @Override
    public void close() throws Exception {
        if (this.gremlinServer != null) {
            this.gremlinServer.stop();
        }
    }
}

