/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.service;

import com.alibaba.graphscope.gremlin.plugin.processor.IrOpLoader;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.Channelizer;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.OpSelectorHandler;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class IrOpSelectorHandler
extends OpSelectorHandler {
    private static final Logger logger = LoggerFactory.getLogger(IrOpSelectorHandler.class);
    private final Settings settings;
    private final GraphManager graphManager;
    private final GremlinExecutor gremlinExecutor;
    private final ScheduledExecutorService scheduledExecutorService;

    public IrOpSelectorHandler(Settings settings, GraphManager graphManager, GremlinExecutor gremlinExecutor, ScheduledExecutorService scheduledExecutorService, Channelizer channelizer) {
        super(settings, graphManager, gremlinExecutor, scheduledExecutorService, channelizer);
        this.settings = settings;
        this.graphManager = graphManager;
        this.gremlinExecutor = gremlinExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    protected void decode(ChannelHandlerContext ctx, RequestMessage msg, List<Object> objects) {
        Context gremlinServerContext = new Context(msg, ctx, this.settings, this.graphManager, this.gremlinExecutor, this.scheduledExecutorService);
        try {
            Optional<OpProcessor> processor = IrOpLoader.getProcessor(msg.getProcessor());
            if (!processor.isPresent()) {
                String errorMessage = String.format("Invalid OpProcessor requested [%s]", msg.getProcessor());
                throw new OpProcessorException(errorMessage, ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(errorMessage).create());
            }
            objects.add(Pair.with((Object)msg, (Object)processor.get().select(gremlinServerContext)));
        }
        catch (OpProcessorException var7) {
            logger.error(var7.getMessage(), (Throwable)var7);
            ctx.writeAndFlush((Object)var7.getResponseMessage());
        }
    }
}

