/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.transform;

import com.alibaba.graphscope.common.exception.OpArgIllegalException;
import com.alibaba.graphscope.gremlin.plugin.type.AnyValue;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Text;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;

public interface PredicateExprTransform
extends Function<Step, String> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public String flatPredicate(String subject, P predicate) {
        Object expr = "";
        if (predicate instanceof ConnectiveP) {
            ConnectiveP connectiveP = (ConnectiveP)predicate;
            String connector = connectiveP instanceof AndP ? " && " : " || ";
            List predicates = connectiveP.getPredicates();
            int i = 0;
            while (i < predicates.size()) {
                P cur = (P)predicates.get(i);
                if (cur instanceof ConnectiveP) {
                    throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, "composition of and & or is unsupported");
                }
                if (i > 0) {
                    expr = (String)expr + connector;
                }
                String flatPredicate = this.flatPredicate(subject, cur);
                expr = i > 0 ? (String)expr + "(" + flatPredicate + ")" : (String)expr + flatPredicate;
                ++i;
            }
            return expr;
        }
        Object predicateValue = predicate.getValue();
        BiPredicate biPredicate = predicate.getBiPredicate();
        if (predicateValue instanceof AnyValue) {
            String propertyExist = subject;
            if (biPredicate == Compare.eq) {
                return propertyExist;
            }
            if (biPredicate != Compare.neq) throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "property type is invalid in checking property existence, " + biPredicate.toString());
            return "!" + propertyExist;
        }
        Function<Triple, String> defaultFormat = t -> String.format("%s %s %s", t.getLeft(), t.getMiddle(), this.getPredicateValue(t.getRight()));
        if (biPredicate == Compare.eq) {
            return (String)expr + this.getPredicateExpr(subject, "==", predicateValue, defaultFormat);
        }
        if (biPredicate == Compare.neq) {
            return (String)expr + this.getPredicateExpr(subject, "!=", predicateValue, defaultFormat);
        }
        if (biPredicate == Compare.lt) {
            return (String)expr + this.getPredicateExpr(subject, "<", predicateValue, defaultFormat);
        }
        if (biPredicate == Compare.lte) {
            return (String)expr + this.getPredicateExpr(subject, "<=", predicateValue, defaultFormat);
        }
        if (biPredicate == Compare.gt) {
            return (String)expr + this.getPredicateExpr(subject, ">", predicateValue, defaultFormat);
        }
        if (biPredicate == Compare.gte) {
            return (String)expr + this.getPredicateExpr(subject, ">=", predicateValue, defaultFormat);
        }
        if (biPredicate == Contains.within) {
            return (String)expr + this.getPredicateExpr(subject, "within", predicateValue, defaultFormat);
        }
        if (biPredicate == Contains.without) {
            return (String)expr + this.getPredicateExpr(subject, "without", predicateValue, defaultFormat);
        }
        if (biPredicate == Text.containing) {
            return (String)expr + this.getPredicateExpr(subject, "within", predicateValue, t -> String.format("%s %s %s", this.getPredicateValue(t.getRight()), t.getMiddle(), t.getLeft()));
        }
        if (biPredicate == Text.notContaining) {
            return (String)expr + this.getPredicateExpr(subject, "without", predicateValue, t -> String.format("%s %s %s", this.getPredicateValue(t.getRight()), t.getMiddle(), t.getLeft()));
        }
        if (biPredicate == Text.startingWith) {
            return (String)expr + this.getPredicateExpr(subject, "StartsWith", predicateValue, defaultFormat);
        }
        if (biPredicate == Text.notStartingWith) {
            return (String)expr + String.format("!(%s)", this.getPredicateExpr(subject, "StartsWith", predicateValue, defaultFormat));
        }
        if (biPredicate == Text.endingWith) {
            return (String)expr + this.getPredicateExpr(subject, "EndsWith", predicateValue, defaultFormat);
        }
        if (biPredicate != Text.notEndingWith) throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, "predicate type is unsupported");
        return (String)expr + String.format("!(%s)", this.getPredicateExpr(subject, "EndsWith", predicateValue, defaultFormat));
    }

    default public String getPredicateValue(Object value) {
        String predicateValue;
        if (value instanceof String) {
            predicateValue = String.format("\"%s\"", value);
        } else if (value instanceof List) {
            Object content = "";
            List values = (List)value;
            for (int i = 0; i < values.size(); ++i) {
                Object v;
                if (i != 0) {
                    content = (String)content + ", ";
                }
                if ((v = values.get(i)) instanceof List) {
                    throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, "nested list of predicate value is unsupported");
                }
                content = (String)content + this.getPredicateValue(v);
            }
            predicateValue = String.format("[%s]", content);
        } else {
            predicateValue = value.toString();
        }
        return predicateValue;
    }

    default public String getPredicateExpr(String subject, String predicate, Object value, Function<Triple, String> format) {
        return format.apply(Triple.of((Object)subject, (Object)predicate, (Object)value));
    }
}

